/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.util.printer;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import kz.arta.synergy.forms.common.object.ASFDefinition;
import kz.arta.synergy.forms.common.object.ASFLayout;
import kz.arta.synergy.forms.common.object.ASFProperty;
import kz.arta.synergy.forms.common.object.printer.ColumnWidth;
import kz.arta.synergy.forms.common.object.printer.DataSignList;
import kz.arta.synergy.forms.common.object.printer.DataStorage;
import kz.arta.synergy.forms.common.object.printer.foElements.FOBlock;
import kz.arta.synergy.forms.common.object.printer.foElements.FOExternalGraphic;
import kz.arta.synergy.forms.common.object.printer.foElements.FOInline;
import kz.arta.synergy.forms.common.object.printer.foElements.FOTable;
import kz.arta.synergy.forms.common.util.printer.TextUtilits;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenerateFoV2 {
    private double coof = 0.021;
    private String coo = "cm";
    private FileOutputStream fofile;
    private ContentHandler hd;
    private AttributesImpl atts = new AttributesImpl();
    private static String[][] ROOT = new String[][]{{"xmlns:fo", "http://www.w3.org/1999/XSL/Format"}, {"fo:root"}};
    private String[][] SIMPLE_PAGE_MASTER = new String[][]{{"master-name", ""}, {"page-height", ""}, {"page-width", ""}, {"margin-top", ""}, {"margin-bottom", ""}, {"margin-left", ""}, {"margin-right", "1cm"}, {"fo:simple-page-master"}};
    private static final String LAYOUT_MASER_SET = "fo:layout-master-set";
    private static String[][] REGION_BODY = new String[][]{{"margin-left", "1cm"}, {"margin-right", "1cm"}, {"margin-top", "1cm"}, {"margin-bottom", "1cm"}, {"fo:region-body"}};
    private String[][] PAGE_SEQUENCE = new String[][]{{"master-reference", "simpleA4"}, {"fo:page-sequence"}};
    private static String[][] FLOW = new String[][]{{"flow-name", "xsl-region-body"}, {"fo:flow"}};
    private static String[][] BLOCK_CONTAINER = new String[][]{{"overflow", "hidden"}, {"height", ""}, {"fo:block-container"}};
    private static final String TEXTAREA = "textarea";
    private static final String LABEL = "label";
    private static final String TABLE_TYPE = "table";
    private static final String IMG = "image";
    private static final String HTD_EDITOR = "htd";
    private static final String SIGNLIST = "signlist";
    private static final String RESOLUTIONLIST = "resolutionlist";
    private int countNodes = 0;
    private List<String> listPageFormatNames = new ArrayList<String>();
    private boolean listStarted = false;
    private boolean cellStarted = false;
    private ASFDefinition asfDefinition;
    private DataStorage dataStor;
    private String url;
    private List<FOInline> foInline = new ArrayList<FOInline>();
    private FOBlock foBlock = new FOBlock();
    private FOBlock htdFOBlock = new FOBlock();
    private FOBlock labelFoBlock = new FOBlock();
    private boolean tempHTDFlagFirst = true;
    private String locale;
    private FOTable foTableMain = new FOTable();

    public GenerateFoV2(String param, DataStorage ds, String url) throws IOException, SAXException {
        this.dataStor = ds;
        this.fofile = new FileOutputStream(param);
        OutputFormat of = new OutputFormat("XML", "UTF-8", true);
        of.setIndent(1);
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(this.fofile, of);
        this.hd = serializer.asContentHandler();
        this.hd.startDocument();
        this.genHD(ROOT);
        this.url = url;
    }

    public void addPageFormat(String pageFormatName, String pageFormat) throws SAXException {
        this.SIMPLE_PAGE_MASTER[0][1] = pageFormatName;
        if (pageFormat.equals("A4")) {
            this.SIMPLE_PAGE_MASTER[1][1] = "29.7cm";
            this.SIMPLE_PAGE_MASTER[2][1] = "21cm";
        }
        this.pageGen();
        this.listPageFormatNames.add(pageFormatName);
    }

    private void pageGen() throws SAXException {
        this.genHD(LAYOUT_MASER_SET);
        this.genHD(this.SIMPLE_PAGE_MASTER);
        this.genHD(REGION_BODY);
        this.genEndHD(3);
    }

    private void genEndHD(int count) throws SAXException {
        for (int i = 0; i < count; ++i) {
            this.genEndHD();
        }
    }

    private void genEndHDAll() throws SAXException {
        while (this.countNodes != 0) {
            this.genEndHD();
        }
    }

    private void genEndHD() throws SAXException {
        if (this.countNodes > 0) {
            this.hd.endElement("", "", "");
            --this.countNodes;
        }
    }

    private void genHD(String[][] node) throws SAXException {
        int tempSize = node.length;
        for (int i = 0; i < tempSize - 1; ++i) {
            this.atts.addAttribute("", "", node[i][0], "CDATA", node[i][1]);
        }
        this.hd.startElement("", "", node[tempSize - 1][0], this.atts);
        this.atts.clear();
        ++this.countNodes;
    }

    private void genHD(String node) throws SAXException {
        this.hd.startElement("", "", node, this.atts);
        this.atts.clear();
        ++this.countNodes;
    }

    public void addPage(String pageFormatName) throws SAXException {
        this.PAGE_SEQUENCE[0][1] = pageFormatName.equals("") ? this.getLastPageFormatName() : pageFormatName;
        if (this.listStarted) {
            this.endPage();
        }
        this.startPage();
    }

    public String getLastPageFormatName() {
        return this.listPageFormatNames.get(this.listPageFormatNames.size() - 1);
    }

    private void startPage() throws SAXException {
        this.listStarted = true;
        this.genHD(this.PAGE_SEQUENCE);
        this.genHD(FLOW);
    }

    private void endPage() throws SAXException {
        this.listStarted = false;
        this.genEndHD(2);
    }

    public void endDocument() throws SAXException, IOException {
        this.genEndHDAll();
        this.hd.endDocument();
        this.fofile.close();
    }

    public void addMaintTable(ASFLayout curentPage, ASFDefinition asfDefinition) throws SAXException {
        int j;
        this.asfDefinition = asfDefinition;
        this.genHD(this.foTableMain.asFoTable());
        List<ASFLayout.Config> tempConfig = curentPage.getConfig();
        ColumnWidth mainCW = new ColumnWidth(curentPage.getColumns(), Double.parseDouble(this.SIMPLE_PAGE_MASTER[2][1].substring(0, this.SIMPLE_PAGE_MASTER[2][1].indexOf("cm"))) - 2.0);
        mainCW.setRatio(this.coof);
        if (tempConfig != null) {
            for (int i = 0; i < tempConfig.size(); ++i) {
                double max = Double.parseDouble(tempConfig.get(i).getWidth());
                for (int j2 = 0; j2 < curentPage.getRows(); ++j2) {
                    if (curentPage.getComponent(j2, i) == null || asfDefinition.getProperties().get(0).getASFProperty(curentPage.getComponent(j2, i).getId()) == null || asfDefinition.getProperties().get(0).getASFProperty(curentPage.getComponent(j2, i).getId()).getStyle().getWidth() == null || !(max < Double.parseDouble(asfDefinition.getProperties().get(0).getASFProperty(curentPage.getComponent(j2, i).getId()).getStyle().getWidth()))) continue;
                    max = Double.parseDouble(asfDefinition.getProperties().get(0).getASFProperty(curentPage.getComponent(j2, i).getId()).getStyle().getWidth());
                }
                mainCW.setColumnSize(i, max);
            }
        }
        for (j = 0; j < curentPage.getColumns(); ++j) {
            this.foTableMain.setColumnColumnWidthCm(mainCW.getColumnWidthCM(j));
            this.genHD(this.foTableMain.asFoTableColumn());
            this.genEndHD();
        }
        this.genHD(this.foTableMain.asFoTableBody());
        for (j = 0; j < curentPage.getRows(); ++j) {
            this.addRow(this.foTableMain);
            for (int i = 0; i < curentPage.getColumns(); ++i) {
                this.addCell(this.foTableMain);
                if (curentPage.getComponent(j, i) != null) {
                    if (!asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(LABEL) && !"".equals(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getLabel()) && asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getLabel() != null) {
                        this.genHD(new FOBlock().asFoBlock());
                        this.hd.characters(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getLabel().toCharArray(), 0, asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getLabel().length());
                        this.genEndHD();
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(TEXTAREA)) {
                        this.addLabel(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()));
                        continue;
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(LABEL)) {
                        this.addLabel(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()));
                        continue;
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(IMG)) {
                        this.addLabel(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()));
                        continue;
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(TABLE_TYPE)) {
                        if ("1".equals(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getStyle().getBorder())) {
                            this.addTable(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()), mainCW.getColumnWidthCM(i), true);
                            continue;
                        }
                        this.addTable(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()), mainCW.getColumnWidthCM(i), false);
                        continue;
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(HTD_EDITOR)) {
                        this.foBlock.reset();
                        this.tempHTDFlagFirst = true;
                        this.addHtdEditor(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()));
                        continue;
                    }
                    if (asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()).getType().equals(SIGNLIST)) {
                        this.addSignList(curentPage.getComponent(j, i).getId());
                        continue;
                    }
                    this.addLabel(asfDefinition.getASFProperty(curentPage.getComponent(j, i).getId()));
                    continue;
                }
                this.addParagraph("", null, -1.0);
            }
            this.endRow();
        }
    }

    private void addSignList(String id) throws SAXException {
        FOTable foTableSlave = new FOTable();
        foTableSlave.setCellBorder("solid black 1px");
        this.genHD(foTableSlave.asFoTable());
        int colum = 5;
        ColumnWidth signCW = new ColumnWidth(colum, Double.parseDouble(this.SIMPLE_PAGE_MASTER[2][1].substring(0, this.SIMPLE_PAGE_MASTER[2][1].indexOf("cm"))) - 2.0);
        signCW.setRatio(this.coof);
        for (int j = 0; j < colum; ++j) {
            foTableSlave.setColumnColumnWidthCm(signCW.getColumnWidthCM(j));
            this.genHD(foTableSlave.asFoTableColumn());
            this.genEndHD();
        }
        this.genHD(foTableSlave.asFoTableBody());
        ArrayList sl = new ArrayList();
        sl.addAll((List)this.dataStor.getValueById(id));
        this.addRow(foTableSlave);
        this.genHD(foTableSlave.asFoTableCell());
        this.genHD(FOBlock.getClean());
        this.hd.characters(DataSignList.getMessage("fullName", this.locale).toCharArray(), 0, DataSignList.getMessage("fullName", this.locale).length());
        this.genEndHD();
        this.genEndHD();
        this.genHD(foTableSlave.asFoTableCell());
        this.genHD(FOBlock.getClean());
        this.hd.characters(DataSignList.getMessage("position", this.locale).toCharArray(), 0, DataSignList.getMessage("position", this.locale).length());
        this.genEndHD();
        this.genEndHD();
        this.genHD(foTableSlave.asFoTableCell());
        this.genHD(FOBlock.getClean());
        this.hd.characters(DataSignList.getMessage("date", this.locale).toCharArray(), 0, DataSignList.getMessage("date", this.locale).length());
        this.genEndHD();
        this.genEndHD();
        this.genHD(foTableSlave.asFoTableCell());
        this.genHD(FOBlock.getClean());
        this.hd.characters(DataSignList.getMessage("sign_type", this.locale).toCharArray(), 0, DataSignList.getMessage("sign_type", this.locale).length());
        this.genEndHD();
        this.genEndHD();
        this.genHD(foTableSlave.asFoTableCell());
        this.genHD(FOBlock.getClean());
        this.hd.characters(DataSignList.getMessage("comment_form_completion", this.locale).toCharArray(), 0, DataSignList.getMessage("comment_form_completion", this.locale).length());
        this.genEndHD();
        this.genEndHD();
        this.genEndHD();
        if (sl.size() > 0) {
            for (int j = 0; j < sl.size(); ++j) {
                this.addRow(foTableSlave);
                this.genHD(foTableSlave.asFoTableCell());
                this.genHD(FOBlock.getClean());
                if (sl.get(j) != null && ((DataSignList)sl.get(j)).getName() != null) {
                    this.hd.characters(((DataSignList)sl.get(j)).getName().toCharArray(), 0, ((DataSignList)sl.get(j)).getName().toCharArray().length);
                }
                this.genEndHD();
                this.genEndHD();
                this.genHD(foTableSlave.asFoTableCell());
                this.genHD(FOBlock.getClean());
                if (sl.get(j) != null && ((DataSignList)sl.get(j)).getPosition() != null) {
                    this.hd.characters(((DataSignList)sl.get(j)).getPosition().toCharArray(), 0, ((DataSignList)sl.get(j)).getPosition().toCharArray().length);
                }
                this.genEndHD();
                this.genEndHD();
                this.genHD(foTableSlave.asFoTableCell());
                this.genHD(FOBlock.getClean());
                if (sl.get(j) != null && ((DataSignList)sl.get(j)).getDate() != null) {
                    this.hd.characters(((DataSignList)sl.get(j)).getDate().toCharArray(), 0, ((DataSignList)sl.get(j)).getDate().toCharArray().length);
                }
                this.genEndHD();
                this.genEndHD();
                this.genHD(foTableSlave.asFoTableCell());
                this.genHD(FOBlock.getClean());
                if (sl.get(j) != null && ((DataSignList)sl.get(j)).getSignType() != null) {
                    this.hd.characters(((DataSignList)sl.get(j)).getSignType().toCharArray(), 0, ((DataSignList)sl.get(j)).getSignType().toCharArray().length);
                }
                this.genEndHD();
                this.genEndHD();
                this.genHD(foTableSlave.asFoTableCell());
                this.genHD(FOBlock.getClean());
                if (sl.get(j) != null && ((DataSignList)sl.get(j)).getComment() != null) {
                    this.hd.characters(((DataSignList)sl.get(j)).getComment().toCharArray(), 0, ((DataSignList)sl.get(j)).getComment().toCharArray().length);
                }
                this.genEndHD();
                this.genEndHD();
                this.genEndHD();
            }
        }
        this.genEndHD();
        this.genEndHD();
    }

    private void addHtdEditor(ASFProperty asfProperty) throws SAXException {
        this.htdFOBlock.reset();
        if (asfProperty.getStyle().getAlign() != null && !"".equals(asfProperty.getStyle().getAlign())) {
            this.htdFOBlock.setTextAlign(TextUtilits.reformAlign(asfProperty.getStyle().getAlign()));
        }
        if (asfProperty.getStyle().getBorder() != null && !"".equals(asfProperty.getStyle().getBorder())) {
            this.htdFOBlock.setBorderWidth(asfProperty.getStyle().getBorder());
        }
        if (asfProperty.getStyle().getFont() != null && !"".equals(asfProperty.getStyle().getFont())) {
            this.htdFOBlock.setFont(asfProperty.getStyle().getFont());
        }
        if (asfProperty.getStyle().getFontsize() != null && !"".equals(asfProperty.getStyle().getFont())) {
            this.htdFOBlock.setFontSize(asfProperty.getStyle().getFontsize() + "pt");
        }
        if (asfProperty.getStyle().getHeight() != null) {
            GenerateFoV2.BLOCK_CONTAINER[1][1] = Double.parseDouble(asfProperty.getStyle().getHeight()) * this.coof + this.coo;
            this.genHD(BLOCK_CONTAINER);
        }
        this.htdFOBlock.setBold(asfProperty.getStyle().isBold());
        this.htdFOBlock.setItalic(asfProperty.getStyle().isItalic());
        if (asfProperty.getStyle().isUnderline()) {
            this.htdFOBlock.setUnderline(asfProperty.getStyle().isUnderline());
        }
        if (asfProperty.getStyle().isStrike()) {
            this.htdFOBlock.setStrike(asfProperty.getStyle().isStrike());
        }
        this.genHD(this.htdFOBlock.asFoBlock());
        this.htdText((String)this.dataStor.getValueById(asfProperty.getId()));
        this.genEndHD();
        if (asfProperty.getStyle().getHeight() != null) {
            this.genEndHD();
        }
    }

    private void htdText(String htmlText) throws SAXException {
        this.genHD(this.htdFOBlock.asFoBlock());
        this.addHTDTextBlock(htmlText, null);
        this.genEndHD();
    }

    private void addHTDTextBlock(String str, FOInline curentHTD) throws SAXException {
        if ((str = this.tagsReader(str)).equals("")) {
            return;
        }
        if (curentHTD == null) {
            if (this.foInline.size() != 0) {
                curentHTD = this.foInline.get(this.foInline.size() - 1);
            } else {
                this.foInline.add(new FOInline());
                curentHTD = this.foInline.get(this.foInline.size() - 1);
            }
        }
        if (this.tempHTDFlagFirst) {
            this.genHD(this.foBlock.asFoBlock());
        }
        this.genHD(curentHTD.asFoInline());
        char[] strTmp = TextUtilits.modifyNBSP(this.foBlock.numberMod(str));
        this.hd.characters(strTmp, 0, strTmp.length);
        this.genEndHD();
        if (this.tempHTDFlagFirst) {
            this.genEndHD();
            this.tempHTDFlagFirst = false;
        }
    }

    private String tagsReader(String str) throws SAXException {
        if (str.contains("<") || str.contains(">")) {
            StringBuilder tempStr = new StringBuilder();
            if (str.length() >= 1) {
                while (str.length() >= 1) {
                    if (str.charAt(0) == '<') {
                        this.addHTDTextBlock(tempStr.toString(), null);
                        this.tagHandler(str.substring(0, str.indexOf(">") + 1));
                        tempStr.delete(0, tempStr.length());
                        str = str.substring(str.indexOf(">") + 1, str.length());
                        continue;
                    }
                    tempStr.append(str.charAt(0));
                    str = str.substring(1);
                }
            }
            return tempStr.toString();
        }
        return str;
    }

    private FOInline tagHandler(String tag) throws SAXException {
        if (this.foInline.size() == 0) {
            this.foInline.add(new FOInline());
        }
        int current = this.foInline.size() - 1;
        if (tag.toLowerCase().contains("<b>")) {
            this.foInline.add(this.foInline.get(current).clone().setBold(true));
        } else if (tag.toLowerCase().contains("</b>")) {
            if (current >= 1) {
                if (this.foInline.get(current - 1).getBoldCount() < this.foInline.get(current - 1).getBoldCount()) {
                    this.foInline.remove(current);
                } else {
                    this.foInline.add(this.foInline.get(current).clone().setBold(false));
                }
            }
            this.foInline.add(this.foInline.get(current).clone().setBold(false));
        } else if (tag.toLowerCase().contains("<div")) {
            if (tag.toLowerCase().contains("text-align: center")) {
                this.foBlock.setTextAlign(TextUtilits.TEXT_ALIGN.CENTER);
            } else if (tag.toLowerCase().contains("text-align: justify")) {
                this.foBlock.setTextAlign(TextUtilits.TEXT_ALIGN.JUSTIFY);
            } else if (tag.toLowerCase().contains("text-align: right")) {
                this.foBlock.setTextAlign(TextUtilits.TEXT_ALIGN.END);
            }
            this.genHD(this.foBlock.asFoBlock());
        } else if (tag.toLowerCase().contains("<br>")) {
            this.genHD(this.foBlock.asFoBlock());
        } else if (tag.toLowerCase().contains("<blockquote")) {
            this.foBlock.addmMarginLift();
        } else if (tag.toLowerCase().contains("</blockquote>")) {
            this.foBlock.removeMarginLift();
        } else if (tag.toLowerCase().contains("<ol>")) {
            this.foBlock.setNumeric(true);
        } else if (tag.toLowerCase().contains("<ul>")) {
            this.foBlock.setPunkted(true);
        } else if (tag.toLowerCase().contains("</ol>")) {
            this.foBlock.setNumeric(false);
        } else if (tag.toLowerCase().contains("</ul>")) {
            this.foBlock.setPunkted(false);
        } else if (tag.toLowerCase().contains("</li>")) {
            this.foBlock.addLi();
            this.genEndHD();
            this.genHD(this.foBlock.asFoBlock());
        } else if (tag.toLowerCase().contains("</div>")) {
            this.foBlock.reset();
            this.genEndHD();
        } else if (tag.toLowerCase().contains("<i>")) {
            this.foInline.add(this.foInline.get(current).clone().setItalic(true));
        } else if (tag.toLowerCase().contains("</i>")) {
            if (current >= 1) {
                if (this.foInline.get(current - 1).getItalicCount() < this.foInline.get(current - 1).getItalicCount()) {
                    this.foInline.remove(current);
                } else {
                    this.foInline.add(this.foInline.get(current).clone().setItalic(false));
                }
            }
            this.foInline.add(this.foInline.get(current).clone().setItalic(false));
        } else if (tag.toLowerCase().contains("<u>")) {
            this.foInline.add(this.foInline.get(current).clone().setUnderline(true));
        } else if (tag.toLowerCase().contains("</u>")) {
            if (current >= 1) {
                if (this.foInline.get(current - 1).getUnderlineCount() < this.foInline.get(current - 1).getUnderlineCount()) {
                    this.foInline.remove(current);
                } else {
                    this.foInline.add(this.foInline.get(current).clone().setUnderline(false));
                }
            }
            this.foInline.add(this.foInline.get(current).clone().setUnderline(false));
        } else if (tag.toLowerCase().contains("<strike>")) {
            this.foInline.add(this.foInline.get(current).clone().setStrike(true));
        } else if (tag.toLowerCase().contains("</strike>")) {
            if (current >= 1) {
                if (this.foInline.get(current - 1).getStrikeCount() < this.foInline.get(current - 1).getStrikeCount()) {
                    this.foInline.remove(current);
                } else {
                    this.foInline.add(this.foInline.get(current).clone().setStrike(false));
                }
            }
        } else if (tag.toLowerCase().contains("<font")) {
            int fontSizeInt;
            this.foInline.add(this.foInline.get(current).clone());
            ++current;
            if (tag.toLowerCase().contains("face")) {
                int startFontName = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf("face")) + 1;
                int endFontName = tag.toLowerCase().indexOf("\"", startFontName + 1);
                this.foInline.get(current).setFont(tag.substring(startFontName, endFontName));
            }
            if (tag.toLowerCase().contains(" color=")) {
                int startFontColor = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf(" color=")) + 1;
                int endFontColor = tag.toLowerCase().indexOf("\"", startFontColor + 1);
                this.foInline.get(current).setFontColor(tag.substring(startFontColor, endFontColor));
            }
            if (tag.toLowerCase().contains("background-color:")) {
                int startBackgroundColor = tag.toLowerCase().indexOf("rgb", tag.toLowerCase().indexOf("background-color:"));
                int endBackgroundColor = tag.toLowerCase().indexOf(";", startBackgroundColor + 1);
                this.foInline.get(current).setBackColor(tag.substring(startBackgroundColor, endBackgroundColor));
            }
            if (tag.toLowerCase().contains("size=")) {
                int startFontSize = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf("size=")) + 1;
                int endFontSize = tag.toLowerCase().indexOf("\"", startFontSize + 1);
                fontSizeInt = Integer.parseInt(tag.substring(startFontSize, endFontSize));
            } else {
                fontSizeInt = 2;
            }
            String fontSizeStr = TextUtilits.formatFontSize(fontSizeInt);
            this.foInline.get(current).setFontSize(fontSizeStr);
        } else if (tag.toLowerCase().contains("</font>")) {
            this.foInline.add(this.foInline.get(current).clone().setFont("Arial").setFontSize("8pt").setFontColor("").setBackColor(""));
        } else if (tag.toLowerCase().contains("<span")) {
            this.foInline.add(this.foInline.get(current).clone());
            this.foInline.get(++current).setSpanStyle();
            if (tag.toLowerCase().contains("face")) {
                int startFontName = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf("face")) + 1;
                int endFontName = tag.toLowerCase().indexOf("\"", startFontName + 1);
                this.foInline.get(current).getSpanStyle().setFont(tag.substring(startFontName, endFontName));
            }
            if (tag.toLowerCase().contains(" color=")) {
                int startFontColor = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf(" color=")) + 1;
                int endFontColor = tag.toLowerCase().indexOf("\"", startFontColor + 1);
                this.foInline.get(current).getSpanStyle().setFontColor(tag.substring(startFontColor, endFontColor));
            }
            if (tag.toLowerCase().contains("font-size:")) {
                int endFontSize;
                int startFontSize = tag.toLowerCase().indexOf(" ", tag.toLowerCase().indexOf("font-size:")) + 1;
                String tempFontSize = tag.substring(startFontSize, endFontSize = tag.toLowerCase().indexOf(";", startFontSize + 1));
                if (tempFontSize.toLowerCase().contains("xxx-large")) {
                    tempFontSize = TextUtilits.formatFontSize(7);
                } else if (tempFontSize.toLowerCase().contains("xx-large")) {
                    tempFontSize = TextUtilits.formatFontSize(6);
                } else if (tempFontSize.toLowerCase().contains("x-large")) {
                    tempFontSize = TextUtilits.formatFontSize(5);
                } else if (tempFontSize.toLowerCase().contains("large")) {
                    tempFontSize = TextUtilits.formatFontSize(4);
                } else if (tempFontSize.toLowerCase().contains("medium")) {
                    tempFontSize = TextUtilits.formatFontSize(3);
                } else if (tempFontSize.toLowerCase().contains("x-small")) {
                    tempFontSize = TextUtilits.formatFontSize(1);
                } else if (tempFontSize.toLowerCase().contains("small")) {
                    tempFontSize = TextUtilits.formatFontSize(2);
                }
                this.foInline.get(current).getSpanStyle().setFontSize(tempFontSize);
            }
            if (tag.toLowerCase().contains("background-color:")) {
                int startBackgroundColor = tag.toLowerCase().indexOf("rgb", tag.toLowerCase().indexOf("background-color:"));
                int endBackgroundColor = tag.toLowerCase().indexOf(";", startBackgroundColor + 1);
                FOInline temp1 = this.foInline.get(current);
                FOInline temp2 = temp1.getSpanStyle();
                String temp3 = tag.substring(startBackgroundColor, endBackgroundColor);
                temp2.setBackColor(temp3);
            }
            if (tag.toLowerCase().contains("size=")) {
                int startFontSize = tag.toLowerCase().indexOf("\"", tag.toLowerCase().indexOf("size=")) + 1;
                int endFontSize = tag.toLowerCase().indexOf("\"", startFontSize + 1);
                int fontSizeInt = Integer.parseInt(tag.substring(startFontSize, endFontSize));
                String fontSizeStr = TextUtilits.formatFontSize(fontSizeInt);
                this.foInline.get(current).getSpanStyle().setFontSize(fontSizeStr);
            }
        } else if (tag.toLowerCase().equals("</span>")) {
            FOInline tempHtml = this.foInline.get(current);
            boolean doFlag = true;
            for (int i = 0; i < this.foInline.size() && doFlag; ++i) {
                if (this.foInline.get(current - i).getSpanStyle() == tempHtml.getSpanStyle()) continue;
                doFlag = false;
                if (i != 1) {
                    if (this.foInline.get(current - i).getSpanStyle() == null) {
                        this.foInline.add(this.foInline.get(current).clone().removeSapnStyle());
                        continue;
                    }
                    this.foInline.add(this.foInline.get(current).clone().removeSapnStyle());
                    this.foInline.add(this.foInline.get(current).clone().setSpanStyleForClone(this.foInline.get(current - i).getSpanStyle()));
                    continue;
                }
                this.foInline.remove(current);
            }
        }
        int postModification = this.foInline.size() - 1;
        return this.foInline.get(postModification);
    }

    public void addParagraph(String text, FOBlock foBlock, double doubleW) throws SAXException {
        this.addTextHard(text, foBlock, doubleW);
    }

    private void addText(String text, boolean isWarp, FOBlock foblock) throws SAXException {
        if (foblock == null) {
            foblock = new FOBlock();
        }
        if (text.equals("")) {
            this.genHD(foblock.asFoBlock());
            this.hd.characters(null, 0, 0);
            this.genEndHD();
        } else {
            String tempReturnDS;
            if (!isWarp) {
                this.genHD(foblock.asFoBlock());
            }
            if ((tempReturnDS = (String)this.dataStor.getValueById(text)) != null) {
                this.hd.characters(tempReturnDS.toCharArray(), 0, tempReturnDS.length());
            } else {
                this.hd.characters("".toCharArray(), 0, 0);
            }
            if (!isWarp) {
                this.genEndHD();
            }
        }
    }

    private void addTextHard(String text, FOBlock foBlock, double doublW) throws SAXException {
        String type;
        if (foBlock == null) {
            foBlock = new FOBlock();
        }
        if ((type = this.dataStor.getTypeById(text)) != null && type.equals(TEXTAREA)) {
            String tempReturnDS = (String)this.dataStor.getValueById(text);
            StringBuilder tempText = new StringBuilder(tempReturnDS);
            tempText.append("\n");
            while (tempText.indexOf("\n") > -1) {
                this.genHD(foBlock.asFoBlock());
                this.hd.characters(tempText.toString().toCharArray(), 0, tempText.indexOf("\n") + 1);
                this.genEndHD();
                tempText.delete(0, tempText.indexOf("\n") + 1);
            }
        } else if (type != null && type.equals(IMG)) {
            this.genHD(foBlock.asFoBlock());
            FOExternalGraphic img = new FOExternalGraphic();
            if (doublW != -1.0) {
                img.setScaling(TextUtilits.SCALING.UNIFORM);
                try {
                    double imgW = (double)ImageIO.read(new URL(this.url + this.dataStor.getValueById(text))).getWidth() * this.coof;
                    double imgH = (double)ImageIO.read(new URL(this.url + this.dataStor.getValueById(text))).getWidth() * this.coof;
                    img.setHeight(doublW / imgH * 100.0);
                }
                catch (IOException imgW) {
                    // empty catch block
                }
            }
            double imgH = 0.0;
            try {
                imgH = ImageIO.read(new URL(this.url + this.dataStor.getValueById(text))).getHeight();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            img.setScaling(TextUtilits.SCALING.UNIFORM);
            img.setContentHeight(imgH * this.coof + "cm");
            img.setSRC(this.url + this.dataStor.getValueById(text));
            this.genHD(img.asExternalGraphic());
            this.genEndHD();
            this.genEndHD();
        } else {
            this.addText(text, false, foBlock);
        }
    }

    public void addRow(FOTable foTable) throws SAXException {
        this.genHD(foTable.asFoTableRow());
    }

    public void addRow(FOTable foTable, int i) throws SAXException {
        foTable.setRowHeightCm((double)i * this.coof);
        this.genHD(foTable.asFoTableRow());
        foTable.setRowHeightCm(-1.0);
    }

    public void endRow() throws SAXException {
        if (this.cellStarted) {
            this.cellStarted = false;
            this.genEndHD();
        }
        this.genEndHD();
    }

    public void addCell(FOTable foTable) throws SAXException {
        if (this.cellStarted) {
            this.cellStarted = false;
            this.genEndHD();
        }
        this.genHD(foTable.asFoTableCell());
        this.cellStarted = true;
    }

    private void addLabel(ASFProperty asfProperty) throws SAXException {
        if (asfProperty.getStyle().getAlign() != null && !"".equals(asfProperty.getStyle().getAlign())) {
            this.labelFoBlock.setTextAlign(TextUtilits.reformAlign(asfProperty.getStyle().getAlign()));
        }
        if (asfProperty.getStyle().getBorder() != null && !"".equals(asfProperty.getStyle().getBorder())) {
            this.labelFoBlock.setBorderWidth(asfProperty.getStyle().getBorder());
        }
        if (asfProperty.getStyle().getFont() != null && !"".equals(asfProperty.getStyle().getFont())) {
            this.labelFoBlock.setFont(asfProperty.getStyle().getFont());
        }
        if (asfProperty.getStyle().getFontsize() != null && !"".equals(asfProperty.getStyle().getFont())) {
            this.labelFoBlock.setFontSize(asfProperty.getStyle().getFontsize() + "pt");
        }
        if (asfProperty.getStyle().getHeight() != null) {
            GenerateFoV2.BLOCK_CONTAINER[1][1] = Double.parseDouble(asfProperty.getStyle().getHeight()) * this.coof + this.coo;
            this.genHD(BLOCK_CONTAINER);
        }
        this.labelFoBlock.setBold(asfProperty.getStyle().isBold());
        this.labelFoBlock.setItalic(asfProperty.getStyle().isItalic());
        if (asfProperty.getStyle().isUnderline()) {
            this.labelFoBlock.setUnderline(asfProperty.getStyle().isUnderline());
        }
        if (asfProperty.getStyle().isStrike()) {
            this.labelFoBlock.setStrike(asfProperty.getStyle().isStrike());
        }
        this.genHD(this.labelFoBlock.asFoBlock());
        if (asfProperty.getStyle().getHeight() != null) {
            this.genEndHD();
        }
        if (asfProperty.getStyle().getHeight() != null) {
            GenerateFoV2.BLOCK_CONTAINER[1][1] = Double.parseDouble(asfProperty.getStyle().getHeight()) * this.coof + this.coo;
            this.genHD(BLOCK_CONTAINER);
            this.addParagraph(asfProperty.getId(), this.labelFoBlock, Double.parseDouble(asfProperty.getStyle().getHeight()) * this.coof);
        } else {
            this.addParagraph(asfProperty.getId(), this.labelFoBlock, -1.0);
        }
        if (asfProperty.getStyle().getHeight() != null) {
            this.genEndHD();
        }
        this.genEndHD();
    }

    private void addTable(ASFProperty asfProperty, double mainWidthCM, boolean isBorder) throws SAXException {
        FOInline foinline = new FOInline();
        FOTable foTableSlave = new FOTable();
        if (isBorder) {
            foTableSlave.setCellBorder("solid black 1px");
        }
        if (asfProperty.getProperties() != null && this.asfDefinition.getASFProperty(asfProperty.getId()).getStyle().isWrap()) {
            this.genHD(FOBlock.getClean());
            for (int i = 0; i < asfProperty.getProperties().size(); ++i) {
                if (asfProperty.getProperties().get(i).getStyle().getAlign() != null && !"".equals(asfProperty.getProperties().get(i).getStyle().getAlign())) {
                    foinline.setTextAlign(TextUtilits.reformAlign(asfProperty.getProperties().get(i).getStyle().getAlign()));
                }
                if (asfProperty.getProperties().get(i).getStyle().getBorder() != null && "".equals(asfProperty.getProperties().get(i).getStyle().getBorder())) {
                    foinline.setBorderWidth(asfProperty.getProperties().get(i).getStyle().getBorder());
                }
                if (asfProperty.getProperties().get(i).getStyle().getFont() != null && "".equals(asfProperty.getProperties().get(i).getStyle().getFont())) {
                    foinline.setFont(asfProperty.getProperties().get(i).getStyle().getFont());
                }
                if (asfProperty.getProperties().get(i).getStyle().getFontsize() != null && "".equals(asfProperty.getProperties().get(i).getStyle().getFontsize())) {
                    foinline.setFontSize(Double.parseDouble(asfProperty.getProperties().get(i).getStyle().getFontsize()) + "pt");
                } else {
                    foinline.setFontSize("");
                }
                if (asfProperty.getProperties().get(i).getStyle().isBold()) {
                    foinline.setBold(true);
                } else {
                    foinline.setBold(false);
                }
                if (asfProperty.getProperties().get(i).getStyle().isItalic()) {
                    foinline.setItalic(true);
                } else {
                    foinline.setItalic(false);
                }
                if (asfProperty.getProperties().get(i).getStyle().isUnderline()) {
                    foinline.setUnderline(true);
                }
                if (asfProperty.getProperties().get(i).getStyle().isStrike()) {
                    foinline.setStrike(true);
                }
                this.genHD(foinline.asFoInline());
                if (asfProperty.getProperties().get(i).getType() != null && asfProperty.getProperties().get(i).getType().equals(IMG)) {
                    double imgH;
                    this.genHD(this.foBlock.asFoBlock());
                    FOExternalGraphic img = new FOExternalGraphic();
                    img.setScaling(TextUtilits.SCALING.UNIFORM);
                    try {
                        imgH = (double)ImageIO.read(new URL(this.url + this.dataStor.getValueById(asfProperty.getProperties().get(i).getId()))).getWidth() * this.coof;
                        img.setHeight(imgH * this.coof);
                    }
                    catch (IOException imgH2) {
                        // empty catch block
                    }
                    imgH = 0.0;
                    try {
                        imgH = ImageIO.read(new URL(this.url + this.dataStor.getValueById(asfProperty.getProperties().get(i).getId()))).getHeight();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    img.setScaling(TextUtilits.SCALING.UNIFORM);
                    img.setContentHeight(imgH * this.coof + "cm");
                    img.setSRC(this.url + this.dataStor.getValueById(asfProperty.getProperties().get(i).getId()));
                    this.genHD(img.asExternalGraphic());
                    this.genEndHD();
                    this.genEndHD();
                } else {
                    this.addText(asfProperty.getProperties().get(i).getId(), true, null);
                }
                this.genEndHD();
            }
            this.genEndHD();
        } else {
            int j;
            this.genHD(foTableSlave.asFoTable());
            ASFLayout tempLayout = asfProperty.getLayout();
            int tempColumns = tempLayout.getColumns();
            ColumnWidth slaveCW = new ColumnWidth(tempColumns, mainWidthCM);
            slaveCW.setRatio(this.coof);
            if (asfProperty.getLayout() != null && asfProperty.getLayout().getConfig() != null) {
                for (int i = 0; i < asfProperty.getLayout().getConfig().size(); ++i) {
                    double max = Double.parseDouble(asfProperty.getLayout().getConfig().get(i).getWidth());
                    for (int j2 = 0; j2 < asfProperty.getLayout().getRows(); ++j2) {
                        if (asfProperty.getLayout().getComponent(j2, i) == null || asfProperty.getASFProperty(asfProperty.getLayout().getComponent(j2, i).getId()).getStyle().getWidth() == null || !(max < Double.parseDouble(asfProperty.getASFProperty(asfProperty.getLayout().getComponent(j2, i).getId()).getStyle().getWidth()))) continue;
                        max = Double.parseDouble(asfProperty.getASFProperty(asfProperty.getLayout().getComponent(j2, i).getId()).getStyle().getWidth());
                    }
                    slaveCW.setColumnSize(i, max);
                }
            }
            for (j = 0; j < asfProperty.getLayout().getColumns(); ++j) {
                foTableSlave.setColumnColumnWidthCm(slaveCW.getColumnWidthCM(j));
                this.genHD(foTableSlave.asFoTableColumn());
                this.genEndHD();
            }
            this.genHD(foTableSlave.asFoTableBody());
            for (j = 0; j < tempLayout.getRows(); ++j) {
                this.genHD(foTableSlave.asFoTableRow());
                for (int i = 0; i < tempLayout.getColumns(); ++i) {
                    this.genHD(foTableSlave.asFoTableCell());
                    if (tempLayout.getComponent(j, i) != null) {
                        List<ASFProperty> prop = asfProperty.getProperties();
                        for (ASFProperty aProp : prop) {
                            if (!tempLayout.getComponent(j, i).getId().equals(aProp.getId())) continue;
                            if (aProp.getType() != null && aProp.getType().equals(SIGNLIST)) {
                                this.addSignList(aProp.getId());
                                continue;
                            }
                            this.addLabel(aProp);
                        }
                    } else {
                        this.addParagraph("", null, -1.0);
                    }
                    this.genEndHD();
                }
                this.genEndHD();
            }
            this.genEndHD(2);
        }
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

