package queue.listeners;

import integration.ConsolidIntegration;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataWrapperExt;
import kz.arta.synergy.forms.common.util.JsonUtil;
import kz.arta.synergy.forms.common.util.rest.operations.AsfDataApi;
import operation.HttpUtils;
import operation.UnblockOperation;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonNode;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import queue.DocNumberGenerator;
import wsdl.consolid.*;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.util.List;
import java.util.Objects;

@MessageDriven(name = "ConsolidBlockQueue", activationConfig = {
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/ConsolidBlockQueue"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge") })
public class EventBlockListener implements MessageListener {

    @Override
    public void onMessage(Message message) {

        System.out.println("start event blocking");

        String dataUUID = "";
        String documentID = "";
        String executionID = "";

        try {
            JsonNode node = JsonUtil.readTree(((TextMessage) message).getText());
            dataUUID = node.get("dataUUID").asText();
            documentID = node.get("documentID").asText();
            executionID = node.get("executionID").asText();
            System.out.println("ExecutionID = " + executionID);
            System.out.println("DataUUID = " + dataUUID);
            AsfDataApi asfDataApi = new AsfDataApi("http://127.0.0.1:8080/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes()));
            ASFDataWrapperExt asfDataWrapperExt = asfDataApi.getAsfData(dataUUID);
            System.out.println("Main data was get");


            TMessage tMessage = getTMessage(asfDataWrapperExt);

            TContractInfo tContractInfo = getTContractInfo(asfDataWrapperExt);

            TSpec tSpec = getTSpec();

            addTLineToTSpec(tSpec, asfDataWrapperExt);

            tContractInfo.getRsSpec().add(tSpec);

            TContract tContract = getTContract(asfDataWrapperExt, documentID);

            TCustomer tCustomer = getTCustomer(asfDataWrapperExt);

            tContract.getRsCustomer().add(tCustomer);

            tContractInfo.getRsContract().add(tContract);
            tMessage.getTbContracts().add(tContractInfo);

            ConsolidIntegration consolidIntegration = new ConsolidIntegration();

            String res = consolidIntegration.sendRequest(tMessage);
            System.out.println(res);
            asfDataWrapperExt.getData("rsDateOperarion").setValue(tContract.getRsDateOperation());
            asfDataWrapperExt.getData("flag_consolidation").setValue(res);
            asfDataApi.saveData(JsonUtil.toJSON(asfDataWrapperExt.getData()), asfDataWrapperExt.getForm(), asfDataWrapperExt.getUuid(), null);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                UnblockOperation unblockOperation = new UnblockOperation("http://127.0.0.1:8080/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes()));
                unblockOperation.unblock(executionID, "Ok", "got_agree");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private TMessage getTMessage(ASFDataWrapperExt asfDataWrapperExt) {
        TMessage tMessage = new TMessage();

        String documentNum = String.valueOf(DocNumberGenerator.getNextDocNum());
        String organization = asfDataWrapperExt.getData("bin_ispolnitel_ru").getValue();
        String region = asfDataWrapperExt.getData("district_office_ru").getKey();
        String responsible = asfDataWrapperExt.getData("iin").getValue();
        String sendDate = DateTime.now().toString("yyyyMMddHHmmss");

        tMessage.setRsIDMessage(Objects.isNull(documentNum) ? "" : documentNum);
        tMessage.setRsDateStamp((Objects.isNull(sendDate)) ? "" : sendDate);
        tMessage.setRsCompany((Objects.isNull(organization)) ? "" : organization);
        tMessage.setRsSubdivision(Objects.isNull(region) ? "" : region);
        tMessage.setRsUser(Objects.isNull(responsible) ? "" : responsible);
        tMessage.setRsReserve("");

        return tMessage;
    }

    private TContractInfo getTContractInfo(ASFDataWrapperExt asfDataWrapperExt) {
        TContractInfo tContractInfo = new TContractInfo();

        String typeOfOperation = asfDataWrapperExt.getData("type_of_operation").getKey();

        tContractInfo.setRsIDContractInfo("");
        tContractInfo.setRsReserve("");

        tContractInfo.setRsTypeOperation(Objects.isNull(typeOfOperation) ? "" : typeOfOperation);
        return tContractInfo;
    }

    private TSpec getTSpec() {
        TSpec tSpec = new TSpec();
        tSpec.setRsIDSpec("");
        tSpec.setRsIDContract("");
        tSpec.setRsReserve("");
        return tSpec;
    }

    private void addTLineToTSpec(TSpec tSpec, ASFDataWrapperExt asfDataWrapperExt) {
        String objectType = asfDataWrapperExt.getData("object_type").getKey();
        List<ASFData.Data> nomenklatura = asfDataWrapperExt.getData("table").getData();
        if (nomenklatura.size() > 9) {
            String lastId = nomenklatura.get(nomenklatura.size() - 1).getId();
            int j = Integer.parseInt(lastId.substring(lastId.length() - 1));
            for (int i = 1; i <= j; i++) {
                TSpecLine tSpecLine = new TSpecLine();
                tSpecLine.setRsTypeObject(Objects.isNull(objectType) ? "" : objectType);
                tSpecLine.setRsReserve("");
                for (ASFData.Data com : nomenklatura) {
                    if (com.getId().equalsIgnoreCase("reglink_service_name-b" + i)) {
                        tSpecLine.setRsTypeService(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                    if (com.getId().equalsIgnoreCase("reglink_name_researh-b" + i)) {
                        tSpecLine.setRsNameItem(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                    if (com.getId().equalsIgnoreCase("research_method-b" + i)) {
                        tSpecLine.setRsNameUnit(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                    if (com.getId().equalsIgnoreCase("text_number_samples-b" + i)) {
                        tSpecLine.setRsQuantity(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                    if (com.getId().equalsIgnoreCase("num_price-b" + i)) {
                        tSpecLine.setRsPrice(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                    if (com.getId().equalsIgnoreCase("num_summa-b" + i)) {
                        tSpecLine.setRsSum(Objects.isNull(com.getValue()) ? "" : com.getValue());
                    }
                }
                tSpec.getTbSpecLines().add(tSpecLine);
            }
        } else {
            TSpecLine tSpecLine = new TSpecLine();
            tSpecLine.setRsTypeObject(Objects.isNull(objectType) ? "" : objectType);
            tSpecLine.setRsReserve("");
            tSpecLine.setRsSum("");
            tSpecLine.setRsPrice("");
            tSpecLine.setRsQuantity("");
            tSpecLine.setRsNameUnit("");
            tSpecLine.setRsNameItem("");
            tSpecLine.setRsTypeService("");
            tSpec.getTbSpecLines().add(tSpecLine);
        }
    }

    private TContract getTContract(ASFDataWrapperExt asfDataWrapperExt, String docId) throws Exception {
        TContract tContract = new TContract();
        String documentId = asfDataWrapperExt.getData("document_id").getValue();
        String documentIdDogovor = asfDataWrapperExt.getData("document_id_dogovor").getValue();

        String typeOfOperation = asfDataWrapperExt.getData("type_of_operation").getKey();
        if (!Objects.isNull(typeOfOperation) && Integer.parseInt(typeOfOperation) == 1) {
            tContract.setRsIDOperation(Objects.isNull(documentId) ? "" : documentId);
        } else {
            tContract.setRsIDOperation(Objects.isNull(documentIdDogovor) ? "" : documentIdDogovor);
        }
        tContract.setRsIDOperation("");
        tContract.setRsReserve("");
        String rsDateOperation;

        rsDateOperation = getRsDateOperation(docId);
        if (!Objects.isNull(rsDateOperation) && !rsDateOperation.equalsIgnoreCase("")) {
            rsDateOperation = DateTime.parse(rsDateOperation, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
        }

        String dateDogovor = asfDataWrapperExt.getData("date_contract_ru").getKey();
        if (!Objects.isNull(dateDogovor) && !dateDogovor.equalsIgnoreCase("")) {
            dateDogovor = DateTime.parse(dateDogovor, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
        }

        System.out.println("dateDofovor");

        String startAction = asfDataWrapperExt.getData("date_deadline_ru").getKey();
        if (!Objects.isNull(startAction) && !startAction.equalsIgnoreCase("")) {
            startAction = DateTime.parse(startAction, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
        }

        System.out.println("startAction");

        String endAction = asfDataWrapperExt.getData("data_end1_ru").getKey();
        if (!Objects.isNull(endAction) && !endAction.equalsIgnoreCase("")) {
            endAction = DateTime.parse(endAction, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
        }
        System.out.println("endAction");

        String dogovorNum = asfDataWrapperExt.getData("num_contract_number_ru").getValue();
        String sumDogovor = asfDataWrapperExt.getData("summ_ru").getValue();
        String currDogovor = asfDataWrapperExt.getData("currency_ru").getKey();
        String otdel = asfDataWrapperExt.getData("res_user_subdivision").getValue();
        String customerCategory = asfDataWrapperExt.getData("customer_category").getKey();
        System.out.println("tContact");

        tContract.setRsIDContract(Objects.isNull(documentId) ? "" : documentId);
        System.out.println(rsDateOperation);
        tContract.setRsDateOperation(Objects.isNull(rsDateOperation) ? "" : rsDateOperation);
        tContract.setRsDateContract(Objects.isNull(dateDogovor) ? "" : dateDogovor);
        tContract.setRsStartDate(Objects.isNull(startAction) ? "" : startAction) ;
        tContract.setRsEndDate(Objects.isNull(endAction) ? "" : endAction);
        tContract.setRsNumContract(Objects.isNull(dogovorNum) ? "" : dogovorNum);
        tContract.setRsSumContract(Objects.isNull(sumDogovor) ? "" : sumDogovor);
        tContract.setRsCurrencyContract(Objects.isNull(currDogovor) ? "" : currDogovor);
        tContract.setRsDepartment(Objects.isNull(otdel) ? "" : otdel);
        tContract.setRsCategoryCustomer(Objects.isNull(customerCategory) ? "" : customerCategory);
        return tContract;
    }

    private TCustomer getTCustomer(ASFDataWrapperExt asfDataWrapperExt) {

        TCustomer tCustomer = new TCustomer();

        String rsStatus = asfDataWrapperExt.getData("contract_individual_entity").getValue();
        String rsNameCustomerFirstPart = asfDataWrapperExt.getData("company_type_ru").getValue();
        String rsNameCustomerSecondPart = asfDataWrapperExt.getData("main_name_ru").getValue();
        String rsBinCustomer = asfDataWrapperExt.getData("bin_zakazchik_ru").getValue();
        String rsAddress = asfDataWrapperExt.getData("adress_zakazchik_ru").getValue();
        String rsBank = asfDataWrapperExt.getData("bankName_zakazchik_ru").getValue();
        String rsBankAccount = asfDataWrapperExt.getData("bankIIK_zakazchik_ru").getValue();
        String rsCurrencyAccount = asfDataWrapperExt.getData("bankCurrency_zakazchik_ru").getValue();
        String rsBankCode = asfDataWrapperExt.getData("bik_zakazchik_ru").getValue();
        String rsCodeBenef = asfDataWrapperExt.getData("kbe_zakazchil_ru").getValue();
        String rsNameCustomer = (Objects.isNull(rsNameCustomerFirstPart) ? "" : rsNameCustomerFirstPart) + " " + (Objects.isNull(rsNameCustomerSecondPart) ? "" : rsNameCustomerSecondPart);

        tCustomer.setRsIDCustomer("");
        tCustomer.setRsReserve("");
        tCustomer.setRsStatus(Objects.isNull(rsStatus) ? "" : rsStatus);
        tCustomer.setRsNameCustomer(Objects.isNull(rsNameCustomer) ? "" : rsNameCustomer);
        tCustomer.setRsBinCustomer(Objects.isNull(rsBinCustomer) ? "" : rsBinCustomer);
        tCustomer.setRsAddress(Objects.isNull(rsAddress) ? "" : rsAddress);
        tCustomer.setRsBank(Objects.isNull(rsBank) ? "" : rsBank);
        tCustomer.setRsBankAccount(Objects.isNull(rsBankAccount) ? "" : rsBankAccount);
        tCustomer.setRsCurrencyAccount(Objects.isNull(rsCurrencyAccount) ? "" : rsCurrencyAccount);
        tCustomer.setRsBankCode(Objects.isNull(rsBankCode) ? "" : rsBankCode);
        tCustomer.setRsCodeBenef(Objects.isNull(rsCodeBenef) ? "" : rsCodeBenef);
        tCustomer.setRsReserve("");

        return tCustomer;
    }

    private String getRsDateOperation(String docId) throws Exception {
        HttpUtils httpUtils = new HttpUtils("http://127.0.0.1:8080/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes()));
        JsonNode docData = httpUtils.getDocData(docId);
        return docData.get("createDate").asText();
    }
}
