package kz.arta.nca_iiscon.service;

import kz.arta.nca_iiscon.data.forward.ForwardApplication;
import kz.arta.nca_iiscon.data.search.SearchOrderByReferenceNumberRequest;
import kz.arta.nca_iiscon.shep.*;
import kz.arta.nca_iiscon.util.XmlTemplateBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.xml.bind.*;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import java.io.StringWriter;
import java.util.*;

@Slf4j
@Service
public class ForwardApplicationNcaService {
    @Value("${login}")
    private String senderIdSHEP;
    @Value("${password}")
    private String senderPassSHEP;
    @Value("${forward_service_id}")
    private String serviceIdSHEP;
    @Value("${service_url}")
    private String urlSHEP;
    @Value("${service_url}")
    private String keyFile;

    @Autowired
    private RestService restService;


    public Object sendRequest(ForwardApplication request) throws Exception {
        try {
            log.info("Initiating SHEP request to URL: {}", urlSHEP);

            // Prepare the SHEP request
            SyncSendMessageRequest shepRequest = prepareShepRequest(request);
            logRequest(shepRequest);

            // Get and configure the port
            ISyncChannel port = getConfiguredPort();

            // Send the request and process response
            SyncSendMessageResponse response = port.sendMessage(shepRequest);

            log.info("Received SHEP response: {}", response);
            return response;
        } catch (SendMessageSendMessageFaultMsg e) {
            String errorResponse = handleFaultMessage(e.getFaultInfo());
            log.error("SHEP request failed: {}", errorResponse);
            return errorResponse;
        } catch (Exception e) {
            log.error("Unexpected error during SHEP request", e);
            throw e;
        }
    }

    public String sendRequestByTemplate(ForwardApplication forwardApplication) throws Exception {
        String request;
        //generate id

        try {

            request = XmlTemplateBuilder.buildXMLForward(forwardApplication, serviceIdSHEP, senderIdSHEP, senderPassSHEP);

            log.info("Request: {}\n", request);
            String response =  restService.getPostWithsSoapHeaders(urlSHEP, request);
            log.info("Response: {}\n", response);

            return response;
//            return request;
        } catch (Exception e) {
            log.error("Ошибка: {}", e.getMessage(), e);
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private SyncSendMessageRequest prepareShepRequest(ForwardApplication request)
            throws DatatypeConfigurationException {
        SyncSendMessageRequest shepRequest = new SyncSendMessageRequest();
        SyncMessageInfo info = new SyncMessageInfo();

        // Set sender information
        SenderInfo sender = new SenderInfo();
        sender.setPassword(senderPassSHEP);
        sender.setSenderId(senderIdSHEP);

        // Configure message info
        info.setSender(sender);
        info.setMessageId(UUID.randomUUID().toString());
        info.setServiceId(serviceIdSHEP);
        info.setMessageDate(new Date());

        shepRequest.setRequestInfo(info);
        shepRequest.setRequestData(new RequestData());

        // Оборачиваем в JAXBElement с пустым namespace для элемента data
        QName qname = new QName("", "data");
        JAXBElement<ForwardApplication> jaxbElement =
                new JAXBElement<>(qname, ForwardApplication.class, request);

        shepRequest.getRequestData().setData(jaxbElement);

        return shepRequest;
    }

    private ISyncChannel getConfiguredPort() {
        ISyncChannel port = getPort();
        BindingProvider bp = (BindingProvider) port;

        // Configure endpoint address
        bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlSHEP);

        // Add handlers
        List<Handler> handlers = new ArrayList<>(2);
        handlers.add(new ForwardSOAPHandler()); // Добавляем кастомный handler первым
        handlers.add(new WriteHandler());
        bp.getBinding().setHandlerChain(handlers);

        return port;
    }

    private void logRequest(SyncSendMessageRequest request) {
        if (log.isInfoEnabled()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance(
                        SyncSendMessageRequest.class,
                        SearchOrderByReferenceNumberRequest.class,
                        ForwardApplication.class
                );
                StringWriter sw = new StringWriter();
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
                marshaller.marshal(request, sw);
                log.info("SHEP REQUEST: {}", sw.toString());
            } catch (JAXBException e) {
                log.warn("Failed to log request", e);
            }
        }
    }

    private String handleFaultMessage(Object e) {
        StringWriter sw = new StringWriter();
        JAXB.marshal(e, sw);
        return sw.toString();
    }

    private ISyncChannel getPort() {
        ISyncChannel port;
        QName portQName = new QName("http://bip.bee.kz/SyncChannel/v10/Interfaces", "ISyncChannel");
        javax.xml.ws.Service service = javax.xml.ws.Service.create(portQName);
        port = service.getPort(ISyncChannel.class);
        return port;
    }
}
