package kz.arta.nca_iiscon.util;

import java.util.concurrent.atomic.AtomicLong;

public class ApplicationIdGenerator {
    private static final String PREFIX = "052";

    private final AtomicLong counter;

    public ApplicationIdGenerator() {
        long start = System.currentTimeMillis() % 1_000_000_000L;
        this.counter = new AtomicLong(start);
    }

    public String generate() {
        long next = counter.getAndUpdate(prev -> (prev + 1) % 1_000_000_000L);
        String suffix = String.format("%09d", next);
        return PREFIX + suffix;
    }

    //    public static String buildXMLForwardResident(ForwardApplication request, String serviceId, String login, String password) throws IOException {
//        String template = loadTemplate("/templates/forward-example.xml");
//        String messageID = UUID.randomUUID().toString();
//        OffsetDateTime messageDate = OffsetDateTime.now(TimeZone.getDefault().toZoneId());
//        String formattedDate = messageDate.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
//        String applicationId =request.getApplicationId();
//
//        ApplicationRegistrationData applicationRegistrationData = request.getRegisterApplication().getApplicationRegistrationData();
//        String registerId = applicationRegistrationData.getRegisterId();
////        String registerOrgCode = applicationRegistrationData.getRegisterOrgCode();
////        String serviceTypeCode = applicationRegistrationData.getServiceTypeCode();
//        String registerDate = applicationRegistrationData.getRegisterDate();
//        Employee employee = applicationRegistrationData.getRegisterEmployee();
//        String lastName = employee.getLastName();
//        String firstName = employee.getFirstName();
//        String middleName = employee.getMiddleName();
//        String position = employee.getPosition();
//        String iin =employee.getIin();
////        String smsCode = applicationRegistrationData.getSmsCode();
////        String registerMethod = applicationRegistrationData.getRegisterMethod();
//
//        UpdateApplication updateApplication = request.getUpdateApplication();
//        CallOrigin callOrigin = updateApplication.getCallOrigin();
////        String orgCode =callOrigin.getOrgCode();
//        Employee employee1 = callOrigin.getEmployee();
//        ApplicationData applicationData = updateApplication.getApplicationData();
//        Person applicant = applicationData.getApplicant().getPerson();
//        Location legalLocation = applicant.getLegalLocation();
//        Location actualLocation = applicant.getActualLocation();
//
//        Contact contact = new Contact();
//        if (applicant.getContacts() != null && applicant.getContacts().getContact() != null && !applicant.getContacts().getContact().isEmpty() && applicant.getContacts().getContact().get(0) != null) {
//            contact = applicant.getContacts().getContact().get(0);
//        }
//        IdentityDocument identityDocument = applicant.getIdentityDocument();
//
//        Payment payment = new Payment();
//        if(applicationData.getPayments() != null && applicationData.getPayments().getPayment() != null && !applicationData.getPayments().getPayment().isEmpty() && applicationData.getPayments().getPayment().get(0) != null){
//            payment = applicationData.getPayments().getPayment().get(0);
//        }
//
//        Document document = new Document();
//        if(applicationData.getDocuments() != null && applicationData.getDocuments().getDocument() != null && !applicationData.getDocuments().getDocument().isEmpty() && applicationData.getDocuments().getDocument().get(0) != null){
//            document = applicationData.getDocuments().getDocument().get(0);
//        }
//
//        String digiSign = applicationData.getData().getDigiSign();//this
//        ConfirmOrder confirmOrder = applicationData.getData().getConfirmOrder();
//
//        ChangeApplicationStatus changeApplicationStatus1 = Optional.ofNullable(request)
//                .map(ForwardApplication::getStatusHistory)
//                .map(StatusHistory::getChangeApplicationStatus)
//                .filter(list -> !list.isEmpty())
//                .map(list -> list.get(0))
//                .orElse(null);
//        assert changeApplicationStatus1 != null;
//        CallOrigin callOrigin1 = changeApplicationStatus1.getCallOrigin();
//        ExecutionStatus executionStatus1 = changeApplicationStatus1.getApplicationStatus().getExecutionStatus();
//
//
//        ChangeApplicationStatus changeApplicationStatus2 = Optional.ofNullable(request)
//                .map(ForwardApplication::getStatusHistory)
//                .map(StatusHistory::getChangeApplicationStatus)
//                .filter(list -> !list.isEmpty())
//                .map(list -> list.get(1))
//                .orElse(null);
//        assert changeApplicationStatus2 != null;
//        CallOrigin callOrigin2 = changeApplicationStatus2.getCallOrigin();
//        ExecutionStatus executionStatus2 = changeApplicationStatus2.getApplicationStatus().getExecutionStatus();
//
////        String employeeLastName = employee1.getLastName();
////        String employeeFirstName = employee1.getFirstName();
////        String employeeMiddleName = employee1.getMiddleName();
////        String employeePosition = employee1.getPosition();
////        String employeeIin = employee1.getIin();
////        String employeeSystemCode = callOrigin.getSystemCode();
//
//        String personIin = applicant.getIin();
//        String personLastName = applicant.getLastName();
//        String personFirstName = applicant.getFirstName();
//        String personMiddleName = applicant.getMiddleName();
//
////        String legalLocationAreaCode =legalLocation.getAreaCode();
////        String legalLocationDistrictCode = legalLocation.getDistrictCode();
////        String legalLocationCountryName = legalLocation.getCountryName();
////        String legalLocationStreetName = legalLocation.getStreetName();
////        String legalLocationDom = legalLocation.getBuilding().getDom();
////        String legalLocationApartment = legalLocation.getApartment();
////        String actualLocationAreaCode = actualLocation.getAreaCode();
////        String actualLocationDistrictCode = actualLocation.getDistrictCode();
////        String actualLocationCountryName = actualLocation.getCountryName();
////        String actualLocationStreetName = actualLocation.getStreetName();
////        String actualLocationDom = actualLocation.getBuilding().getDom();
////        String actualLocationApartment = actualLocation.getApartment();
//
//        String contactType = contact.getContactType(); //проверять
//        String contactData = contact.getContactData();
//        Boolean isForNotification = contact.getIsForNotification();
//        String identityDocumentDocType = identityDocument.getDocType();
//        String identityDocumentDocNum = identityDocument.getDocNum();
//        String identityDocumentDocDate = identityDocument.getDocDate();
//        String identityDocumentDocSource = identityDocument.getDocSource();
//        String identityDocumentExpirationDate = identityDocument.getExpirationDate();
//        String identityDocumentDocName = identityDocument.getDocName();
//        String dateOfBirth = applicant.getDateOfBirth();
//        String placeOfBirth = applicant.getPlaceOfBirth();
//        String gender = applicant.getGender();
//        Boolean isForeigner = applicant.getIsForeigner();
//        String citizenship = applicant.getCitizenship();
//        String executorOrgCode = applicationData.getExecutorOrgCode();
//        String deliveryOrgCode = applicationData.getDeliveryOrgCode();
//        String deadline = applicationData.getDeadline(); //generate
////        Double cost = applicationData.getCost();
//        String paymentsPaymentId = payment.getPaymentId();//generate
////        Double paymentsCost = payment.getCost();
////        String paymentsPaymentType = payment.getPaymentType();
//        Integer copies = applicationData.getCopies();
//        String language = applicationData.getLanguage(); //check
//        String finalDocumentLang = applicationData.getFinalDocumentLang();
//        String documentId = document.getDocumentId();
//        String docTypeCode = document.getDocTypeCode();
//        String copyType = document.getCopyType();
//        String docName = document.getDocName();
//        String confirmOrderDigiSign = confirmOrder.getDigiSign();//this
//        String name = Optional.of(applicationData)
//                .map(ApplicationData::getApplicationAttrs)
//                .map(ApplicationAttrs::getAttr)
//                .filter(list -> !list.isEmpty())
//                .map(list -> list.get(0))
//                .map(Attr::getName)
//                .orElse(null);
//
//        String subServiceTypeCode = applicationData.getSubServiceTypeCode();
//        String callOriginOrgCode1 = callOrigin1.getOrgCode();
//        String callOriginLastName1 = callOrigin1.getEmployee().getLastName();
//        String callOriginFirstName1 = callOrigin1.getEmployee().getFirstName();
//        String callOriginMiddleName1 = callOrigin1.getEmployee().getMiddleName();
//        String callOriginPosition1 = callOrigin1.getEmployee().getPosition();
//        String callOriginIin1 = callOrigin1.getEmployee().getIin();
//        String callOriginSystemCode1 = callOrigin1.getSystemCode();
//        String appState1 = executionStatus1.getAppState();
//        String statusInfo1 = executionStatus1.getStatusInfo();
//        String statusInfoKz1 = executionStatus1.getStatusInfoKz();
//        String statusDate1 = changeApplicationStatus1.getStatusDate();
//
//        String callOriginOrgCode2 = callOrigin2.getOrgCode();
//        String callOriginLastName2 = callOrigin2.getEmployee().getLastName();
//        String callOriginFirstName2 = callOrigin2.getEmployee().getFirstName();
//        String callOriginMiddleName2 = callOrigin2.getEmployee().getMiddleName();
//        String callOriginPosition2 = callOrigin2.getEmployee().getPosition();
//        String callOriginIin2 = callOrigin2.getEmployee().getIin();
//        String callOriginSystemCode2 = callOrigin2.getSystemCode();
//        String appState2 = executionStatus2.getAppState();
//        String statusInfo2 = executionStatus2.getStatusInfo();
//        String statusInfoKz2 = executionStatus2.getStatusInfoKz();
//        String statusDate2 = changeApplicationStatus2.getStatusDate();
//
//
//        Map<String, String> values = new HashMap<>();
//        values.put("messageId", messageID);
//        values.put("serviceId", serviceId);
//        values.put("messageDate", formattedDate);
//        values.put("senderId", login);
//        values.put("password", password);
//        values.put("applicationId", applicationId);
//
//        // Register Application
////        values.put("registerId", registerId);
////        values.put("registerOrgCode", registerOrgCode);
////        values.put("serviceTypeCode", serviceTypeCode);
//        values.put("registerDate", registerDate);
//        //Employee
//        values.put("lastName", lastName);
//        values.put("firstName", firstName);
//        values.put("middleName", middleName);
//        values.put("position", position);
//        values.put("iin", iin);
////        values.put("smsCode", smsCode);
////        values.put("registerMethod", registerMethod);
//
//        // Update Application - Call Origin
////        values.put("orgCode", orgCode);
//
////        values.put("employeeLastName", employeeLastName);
////        values.put("employeeFirstName", employeeFirstName);
////        values.put("employeeMiddleName", employeeMiddleName);
////        values.put("employeePosition", employeePosition);
////        values.put("employeeIin", employeeIin);
//        //code??
////        values.put("employeeSystemCode", employeeSystemCode);
//
//        // Applicant Person
//        values.put("personIin", personIin);
//        values.put("personLastName", personLastName);
//        values.put("personFirstName", personFirstName);
//        values.put("personMiddleName", personMiddleName);
//
//        // Legal Location
////        values.put("legalLocationAreaCode", legalLocationAreaCode);
////        values.put("legalLocationDistrictCode", legalLocationDistrictCode);
////        values.put("legalLocationCountryName", legalLocationCountryName);
////        values.put("legalLocationStreetName", legalLocationStreetName);
////        values.put("legalLocationDom", legalLocationDom);
////        values.put("legalLocationApartment", legalLocationApartment);
//
//        // Actual Location
////        values.put("actualLocationAreaCode", actualLocationAreaCode);
////        values.put("actualLocationDistrictCode", actualLocationDistrictCode);
////        values.put("actualLocationCountryName", actualLocationCountryName);
////        values.put("actualLocationStreetName", actualLocationStreetName);
////        values.put("actualLocationDom", actualLocationDom);
////        values.put("actualLocationApartment", actualLocationApartment);
//
//        // Contact
//        values.put("contactType", contactType);
//        values.put("contactData", contactData);
//        values.put("isForNotification", String.valueOf(isForNotification));
//
//        // Identity Document
//        values.put("identityDocumentDocType", identityDocumentDocType);
//        values.put("identityDocumentDocNum", identityDocumentDocNum);
//        values.put("identityDocumentDocDate", identityDocumentDocDate);
//        values.put("identityDocumentDocSource", identityDocumentDocSource);
//        values.put("identityDocumentExpirationDate", identityDocumentExpirationDate);
//        values.put("identityDocumentDocName", identityDocumentDocName);
//
//        // Person Details
//        values.put("dateOfBirth", dateOfBirth);
//        values.put("placeOfBirth", placeOfBirth);
//        values.put("gender", gender);
//        values.put("isForeigner", String.valueOf(isForeigner));
//        values.put("citizenship", citizenship);
//
//        // Application Data
////        values.put("executorOrgCode", executorOrgCode);
////        values.put("deliveryOrgCode", deliveryOrgCode);
//        values.put("deadline", deadline);
////        values.put("cost", String.valueOf(cost));
//
//        // Payments
//        values.put("paymentsPaymentId", paymentsPaymentId);
////        values.put("paymentsCost", String.valueOf(paymentsCost));
////        values.put("paymentsPaymentType", paymentsPaymentType);
//
//        // Application Details
////        values.put("copies", String.valueOf(copies));
//        values.put("language", language);
////        values.put("finalDocumentLang", finalDocumentLang);
//
//        // Documents
//        values.put("documentId", documentId);
//        values.put("docTypeCode", docTypeCode);
//        values.put("copyType", copyType);
//        values.put("docName", docName);
//
//        // Data - Экранируем XML в digiSign полях
//        values.put("dataDigiSign", escapeXml(digiSign));
//        values.put("confirmOrderDigiSign", escapeXml(confirmOrderDigiSign));
////        values.put("name", name);
////        values.put("subServiceTypeCode", subServiceTypeCode);
//
//        // Status History 1
////        values.put("callOriginOrgCode1", callOriginOrgCode1);
////        values.put("callOriginLastName1", callOriginLastName1);
////        values.put("callOriginFirstName1", callOriginFirstName1);
////        values.put("callOriginMiddleName1", callOriginMiddleName1);
////        values.put("callOriginPosition1", callOriginPosition1);
////        values.put("callOriginIin1", callOriginIin1);
////        values.put("callOriginSystemCode1", callOriginSystemCode1);
////        values.put("appState1", appState1);
////        values.put("statusInfo1", statusInfo1);
////        values.put("statusInfoKz1", statusInfoKz1);
////        values.put("statusDate1", statusDate1);
//
//        // Status History 2
//        values.put("callOriginOrgCode2", callOriginOrgCode2);
//        values.put("callOriginLastName2", callOriginLastName2);
//        values.put("callOriginFirstName2", callOriginFirstName2);
//        values.put("callOriginMiddleName2", callOriginMiddleName2);
//        values.put("callOriginPosition2", callOriginPosition2);
//        values.put("callOriginIin2", callOriginIin2);
//        values.put("callOriginSystemCode2", callOriginSystemCode2);
//        values.put("appState2", appState2);
//        values.put("statusInfo2", statusInfo2);
//        values.put("statusInfoKz2", statusInfoKz2);
//        values.put("statusDate2", statusDate2);
//
//        StringSubstitutor substitutor = new StringSubstitutor(values);
//        return substitutor.replace(template);
//
//    }
}
