package kz.arta.nca_iiscon.util;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

public class CustomNamespacePrefixMapper extends NamespacePrefixMapper {

    private static final String IISCON_NAMESPACE = "http://schemas.letograf.kz/iiscon/bus/v1";
    private static final String PKI_NAMESPACE = "http://pki.gov.kz/api/ws/iiscon/wsdl";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";

    @Override
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if (IISCON_NAMESPACE.equals(namespaceUri)) {
            return "s01";
        }
        if (XSI_NAMESPACE.equals(namespaceUri)) {
            return "xsi";
        }
        if (PKI_NAMESPACE.equals(namespaceUri)) {
            return ""; // default namespace for confirmOrder
        }
        return suggestion;
    }

    @Override
    public String[] getPreDeclaredNamespaceUris() {
        return new String[] { IISCON_NAMESPACE, XSI_NAMESPACE };
    }
}
