package kz.arta.nca_iiscon.data.forward.application;

import kz.arta.nca_iiscon.data.forward.applicant.Applicant;
import kz.arta.nca_iiscon.data.forward.document.Documents;
import kz.arta.nca_iiscon.data.forward.payment.Payments;
import lombok.Data;
import javax.xml.bind.annotation.*;

@Data
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(propOrder = {"applicant", "executorOrgCode", "deliveryOrgCode", "deadline", "cost",
        "payments", "copies", "language", "finalDocumentLang", "documents",
        "data", "applicationAttrs", "subServiceTypeCode"})
public class ApplicationData {

    @XmlElement
    private Applicant applicant;

    @XmlElement
    private String executorOrgCode;

    @XmlElement
    private String deliveryOrgCode;

    @XmlElement
    private String deadline;

    @XmlElement
    private Double cost;

    @XmlElement
    private Payments payments;

    @XmlElement
    private Integer copies;

    @XmlElement
    private String language;

    @XmlElement
    private String finalDocumentLang;

    @XmlElement
    private Documents documents;

    @XmlElement
    private kz.arta.nca_iiscon.data.forward.application.Data data;

    @XmlElement
    private ApplicationAttrs applicationAttrs;

    @XmlElement
    private String subServiceTypeCode;
}