
package kz.arta.nca_iiscon.shep;

import kz.arta.nca_iiscon.data.forward.ForwardApplication;
import kz.arta.nca_iiscon.data.search.SearchOrderByReferenceNumberRequest;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


@WebService(name = "ISyncChannel", targetNamespace = "http://bip.bee.kz/SyncChannel/v10/Interfaces")
@XmlSeeAlso({
    ObjectFactory.class, SearchOrderByReferenceNumberRequest.class, ForwardApplication.class})
public interface ISyncChannel {


    /**
     *
     * @param request
     * @return
     *     returns shep.SyncSendMessageResponse
     * @throws SendMessageSendMessageFaultMsg
     */
    @WebMethod(operationName = "SendMessage")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "SendMessage", targetNamespace = "http://bip.bee.kz/SyncChannel/v10/Types", className = "shep.SendMessage")
    @ResponseWrapper(localName = "SendMessageResponse", targetNamespace = "http://bip.bee.kz/SyncChannel/v10/Types", className = "shep.SendMessageResponse")
    public SyncSendMessageResponse sendMessage(
      @WebParam(name = "request", targetNamespace = "")
              SyncSendMessageRequest request)
        throws SendMessageSendMessageFaultMsg
    ;

}
