package kz.arta.nca_iiscon.controller;

import kz.arta.nca_iiscon.data.forward.ForwardApplication;
import kz.arta.nca_iiscon.data.search.SearchOrderByReferenceNumberRequest;
import kz.arta.nca_iiscon.service.ForwardApplicationNcaService;
import kz.arta.nca_iiscon.service.NcaIISConService;
import kz.arta.nca_iiscon.util.XmlToJsonUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@Slf4j
@ResponseBody
@RestController
@RequiredArgsConstructor
@RequestMapping(value = "/service/nca")
public class NcaIISConController {

    @Value("${secure_xml}")
    private boolean isSecureXml;

    private final NcaIISConService service;

    private final ForwardApplicationNcaService forwardService;

    @PostMapping(value = "/iiscon", produces = MediaType.APPLICATION_JSON_VALUE)
    public @ResponseBody Object getSearchOrderByReferenceNumber(@RequestBody SearchOrderByReferenceNumberRequest request
    ) throws Exception {

        XmlToJsonUtil.setSecureXml(isSecureXml);

        log.info("Received request with referenceNumber: {}", request.getReferenceNumber());

        // Отправляем запрос и получаем ответ
        Object response = service.sendRequest(request);

        // Извлекаем data и конвертируем в JSON
        String jsonResponse = XmlToJsonUtil.extractDataAsJson(response);

        log.info("Converted response to JSON");

        return jsonResponse;
    }

    @PostMapping(value = "/forward", produces = MediaType.APPLICATION_JSON_VALUE)
    public @ResponseBody Object getInfoOneC(
            @RequestBody ForwardApplication request
    ) throws Exception {

        XmlToJsonUtil.setSecureXml(isSecureXml);

        // Отправляем запрос и получаем ответ
        Object response = forwardService.sendRequest(request);

        // Извлекаем data и конвертируем в JSON
        String jsonResponse = XmlToJsonUtil.extractDataAsJson(response);

        log.info("Converted response to JSON");

        return jsonResponse;
    }
}