package kz.arta.nca_iiscon.service;

import lombok.extern.slf4j.Slf4j;

import javax.xml.namespace.QName;
import javax.xml.soap.*;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Set;

@Slf4j
public class CustomSOAPHandler implements SOAPHandler<SOAPMessageContext> {

    @Override
    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outboundProperty) {
            try {
                SOAPMessage soapMessage = context.getMessage();
                SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();

                // Устанавливаем правильный порядок namespace в envelope
                envelope.removeNamespaceDeclaration("SOAP-ENV");
                envelope.removeNamespaceDeclaration("wsu");
                envelope.removeNamespaceDeclaration("xsd");

                // Добавляем в правильном порядке
                envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                envelope.addNamespaceDeclaration("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
                envelope.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

                // Убеждаемся, что есть Header
                SOAPHeader header = envelope.getHeader();
                if (header == null) {
                    envelope.addHeader();
                }

                SOAPBody body = envelope.getBody();

                // Находим элемент SendMessage
                SOAPElement sendMessage = (SOAPElement) body.getChildElements(
                        new QName("http://bip.bee.kz/SyncChannel/v10/Types", "SendMessage")
                ).next();

                if (sendMessage != null) {
                    // Удаляем лишние namespace из SendMessage
                    sendMessage.removeNamespaceDeclaration("ns4");
                    sendMessage.removeNamespaceDeclaration("ns5");
                    sendMessage.removeNamespaceDeclaration("s01");
                    sendMessage.removeNamespaceDeclaration("xsi");

                    // SendMessage должен остаться без префикса
                    sendMessage.setPrefix("");

                    // Находим request
                    SOAPElement request = (SOAPElement) sendMessage.getChildElements(
                            new QName("", "request")
                    ).next();

                    if (request != null) {
                        request.setAttribute("xmlns", "");

                        // Обрабатываем data элемент
                        processDataElement(request);
                    }
                }

                soapMessage.saveChanges();

                // Логируем финальное сообщение
                if (log.isInfoEnabled()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    soapMessage.writeTo(out);
                    log.info("Outbound SOAP Message:\n{}", out.toString("UTF-8"));
                }

            } catch (Exception e) {
                log.error("Error in SOAP Handler", e);
            }
        }

        return true;
    }

    private void processDataElement(SOAPElement parent) throws SOAPException {
        // Рекурсивно проходим по всем элементам
        Iterator iterator = parent.getChildElements();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof SOAPElement) {
                SOAPElement element = (SOAPElement) obj;

                // Если это data элемент
                if ("data".equals(element.getLocalName())) {
                    // Убираем префикс s01 у data
                    element.setPrefix("");

                    // Добавляем xmlns:xsi и xmlns:s01
                    element.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    element.addNamespaceDeclaration("s01", "http://pki.gov.kz/api/ws/iiscon/wsdl");

                    // Устанавливаем xsi:type
                    element.setAttributeNS(
                            "http://www.w3.org/2001/XMLSchema-instance",
                            "xsi:type",
                            "s01:SearchOrderByReferenceNumberRequest"
                    );
                }

                // Меняем префикс на s01 для всех дочерних элементов из namespace http://pki.gov.kz/api/ws/iiscon/wsdl
                String namespaceURI = element.getNamespaceURI();
                if ("http://pki.gov.kz/api/ws/iiscon/wsdl".equals(namespaceURI)) {
                    element.setPrefix("s01");
                }

                // Рекурсивно обрабатываем детей
                processDataElement(element);
            }
        }
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    @Override
    public void close(MessageContext context) {
    }

    @Override
    public Set<QName> getHeaders() {
        return null;
    }
}