/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.x509;

import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSequence;

public class AlgorithmIdentifier
extends ASN1Encodable {
    private DERObjectIdentifier objectId;
    private DEREncodable parameters;
    private boolean parametersDefined = false;

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static AlgorithmIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)obj;
        }
        if (obj instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)obj);
        }
        if (obj instanceof String) {
            return new AlgorithmIdentifier((String)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public AlgorithmIdentifier(DERObjectIdentifier objectId) {
        this.objectId = objectId;
        this.parametersDefined = true;
        this.parameters = new DERNull();
    }

    public AlgorithmIdentifier(String objectId) {
        this.objectId = new DERObjectIdentifier(objectId);
    }

    public AlgorithmIdentifier(DERObjectIdentifier objectId, DEREncodable parameters) {
        this.parametersDefined = parameters != null;
        this.objectId = objectId;
        this.parameters = parameters;
    }

    public AlgorithmIdentifier(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.objectId = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
        if (seq.size() == 2) {
            this.parametersDefined = true;
            this.parameters = seq.getObjectAt(1);
        } else {
            this.parametersDefined = true;
            this.parameters = new DERNull();
        }
    }

    public DERObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public DEREncodable getParameters() {
        return this.parameters;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.objectId);
        if (this.parametersDefined) {
            v.add(this.parameters);
        }
        return new DERSequence(v);
    }
}

