/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.x509;

import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERUTF8String;

public class KeyStoreInfo
extends ASN1Encodable {
    private DERObjectIdentifier keyStoreId;
    private DERUTF8String keyStorePath;

    public KeyStoreInfo(DERObjectIdentifier keyStoreId, String keyStorePath) {
        this.keyStoreId = keyStoreId;
        if (keyStorePath != null) {
            this.keyStorePath = new DERUTF8String(keyStorePath);
        }
    }

    public KeyStoreInfo(DERObjectIdentifier keyStoreId) {
        this.keyStoreId = keyStoreId;
    }

    public KeyStoreInfo(ASN1Sequence as) {
        if (as.size() < 1 || as.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + as.size());
        }
        this.keyStoreId = DERObjectIdentifier.getInstance(as.getObjectAt(0));
        if (as.size() == 2) {
            this.keyStorePath = (DERUTF8String)as.getObjectAt(1);
        }
    }

    public static KeyStoreInfo getInstance(Object as) {
        if (as instanceof KeyStoreInfo) {
            return (KeyStoreInfo)as;
        }
        if (as instanceof ASN1Sequence) {
            return new KeyStoreInfo((ASN1Sequence)as);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    public DERObjectIdentifier getKeyStoreId() {
        return this.keyStoreId;
    }

    public DERUTF8String getPath() {
        return this.keyStorePath;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        dev.add(this.keyStoreId);
        if (this.keyStorePath != null) {
            dev.add(this.keyStorePath);
        }
        return new DERSequence(dev);
    }
}

