/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.nist.NISTObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.DigestInfo;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.AsymmetricBlockCipher;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.MD2Digest;
import kz.gov.pki.kalkan.crypto.digests.MD4Digest;
import kz.gov.pki.kalkan.crypto.digests.MD5Digest;
import kz.gov.pki.kalkan.crypto.digests.NullDigest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA224Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA256Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA384Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA512Digest;
import kz.gov.pki.kalkan.crypto.encodings.PKCS1Encoding;
import kz.gov.pki.kalkan.crypto.engines.RSABlindedEngine;
import kz.gov.pki.kalkan.crypto.params.RSAKeyParameters;
import kz.gov.pki.kalkan.jce.provider.RSAUtil;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;

public class JDKDigestSignature
extends SignatureSpi {
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private AlgorithmIdentifier algId;
    private byte keyId;
    private AKToken token = null;
    private String sigAlg;

    protected JDKDigestSignature(Digest digest, AsymmetricBlockCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.algId = null;
    }

    protected JDKDigestSignature(DERObjectIdentifier objId, Digest digest, AsymmetricBlockCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.algId = new AlgorithmIdentifier(objId, DERNull.INSTANCE);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a RSAPublicKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.digest.reset();
        this.cipher.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.digest.reset();
        if (privateKey instanceof AKRSAPrivateKey) {
            AKRSAPrivateKey key = (AKRSAPrivateKey)privateKey;
            this.keyId = key.getKeyId();
            this.token = key.getToken();
            this.sigAlg = "RSA";
            return;
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a RSAPrivateKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.cipher.init(true, param);
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = this.derEncode(hash);
            if (this.token == null) {
                return this.cipher.processBlock(bytes, 0, bytes.length);
            }
            return this.token.sign(this.sigAlg, bytes, this.keyId);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] expected;
        byte[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
            expected = this.derEncode(hash);
        }
        catch (Exception e) {
            return false;
        }
        if (sig.length == expected.length) {
            for (int i = 0; i < sig.length; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else if (sig.length == expected.length - 2) {
            int i;
            int sigOffset = sig.length - hash.length - 2;
            int expectedOffset = expected.length - hash.length - 2;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            for (i = 0; i < hash.length; ++i) {
                if (sig[sigOffset + i] == expected[expectedOffset + i]) continue;
                return false;
            }
            for (i = 0; i < sigOffset; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        if (this.algId == null) {
            return hash;
        }
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }

    public static class noneRSA256
    extends JDKDigestSignature {
        public noneRSA256() {
            super(NISTObjectIdentifiers.id_sha256, new NullDigest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class noneRSA
    extends JDKDigestSignature {
        public noneRSA() {
            super(X509ObjectIdentifiers.id_SHA1, new NullDigest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD5WithRSAEncryption
    extends JDKDigestSignature {
        public MD5WithRSAEncryption() {
            super(PKCSObjectIdentifiers.md5, new MD5Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD4WithRSAEncryption
    extends JDKDigestSignature {
        public MD4WithRSAEncryption() {
            super(PKCSObjectIdentifiers.md4, new MD4Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD2WithRSAEncryption
    extends JDKDigestSignature {
        public MD2WithRSAEncryption() {
            super(PKCSObjectIdentifiers.md2, new MD2Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512WithRSAEncryption
    extends JDKDigestSignature {
        public SHA512WithRSAEncryption() {
            super(NISTObjectIdentifiers.id_sha512, new SHA512Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA384WithRSAEncryption
    extends JDKDigestSignature {
        public SHA384WithRSAEncryption() {
            super(NISTObjectIdentifiers.id_sha384, new SHA384Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA256WithRSAEncryption
    extends JDKDigestSignature {
        public SHA256WithRSAEncryption() {
            super(NISTObjectIdentifiers.id_sha256, new SHA256Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA224WithRSAEncryption
    extends JDKDigestSignature {
        public SHA224WithRSAEncryption() {
            super(NISTObjectIdentifiers.id_sha224, new SHA224Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA1WithRSAEncryption
    extends JDKDigestSignature {
        public SHA1WithRSAEncryption() {
            super(X509ObjectIdentifiers.id_SHA1, new SHA1Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }
}

