/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.util.ByteUtils;

public class KalkanGOST3410GTPublicKey {
    private static KalkanGOST3410GTPublicKey instance;
    private byte bType = (byte)6;
    private byte bVersion = (byte)2;
    private byte[] reserved = new byte[]{0, 0};
    private int algID = 43578;
    private int magic = 826492160;
    private int bitlen;
    private byte[] keyBlob;
    private BigInteger keyX = null;
    private BigInteger keyY = null;
    private BigInteger keyBlobBigInt = null;
    private String keyString = null;

    private KalkanGOST3410GTPublicKey() {
    }

    public static KalkanGOST3410GTPublicKey getInstance() {
        if (instance == null) {
            instance = new KalkanGOST3410GTPublicKey();
        }
        return instance;
    }

    public void setKeyBlob(byte[] blob) {
        this.bType = blob[0];
        this.bVersion = blob[1];
        if (this.bType == 6 && this.bVersion == 2) {
            this.reserved = ByteUtils.copyByte(blob, 2, 2);
            this.algID = ByteUtils.byteToInt(blob, 4);
            this.magic = ByteUtils.byteToInt(blob, 8);
            this.bitlen = ByteUtils.byteToInt(blob, 12);
            this.keyBlob = new byte[this.bitlen / 8];
            this.keyBlob = ByteUtils.copyByte(blob, 16, this.bitlen / 8);
        } else {
            this.keyBlob = ByteUtils.copyByte(blob, 2, 64);
        }
        this.updateDependencies();
    }

    public void setKeyBlob(SubjectPublicKeyInfo paramSubjectPublicKeyInfo) {
        ASN1OctetString localASN1OctetString;
        DERBitString localDERBitString = paramSubjectPublicKeyInfo.getPublicKeyData();
        ASN1InputStream localASN1InputStream = new ASN1InputStream(localDERBitString.getBytes());
        try {
            localASN1OctetString = (ASN1OctetString)localASN1InputStream.readObject();
        }
        catch (IOException localIOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] arrayOfByte = localASN1OctetString.getOctets();
        this.bitlen = arrayOfByte.length * 8;
        this.keyBlob = new byte[this.bitlen / 8];
        this.keyBlob = ByteUtils.copyByte(arrayOfByte, 0, this.bitlen / 8);
        this.updateDependencies();
    }

    public SubjectPublicKeyInfo getKeySubject() {
        GOST3410PublicKeyAlgParameters localGOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004, CryptoProObjectIdentifiers.gostR3411_GT);
        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004, localGOST3410PublicKeyAlgParameters.getDERObject()), new DEROctetString(this.keyBlob));
    }

    public ASN1EncodableVector getKeyASN() {
        ASN1EncodableVector localASN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier localAlgorithmIdentifier = new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004, new DERNull());
        DERBitString localDERBitString = new DERBitString(this.getKey());
        localASN1EncodableVector.add(localAlgorithmIdentifier);
        localASN1EncodableVector.add(localDERBitString);
        return localASN1EncodableVector;
    }

    public void setKey(byte[] paramArrayOfByte) {
        this.bitlen = paramArrayOfByte.length * 8;
        this.keyBlob = new byte[this.bitlen / 8];
        this.keyBlob = ByteUtils.copyByte(paramArrayOfByte, 0, this.bitlen / 8);
        this.updateDependencies();
    }

    public byte[] getKey() {
        int i2;
        int i = this.keyBlob.length + 16;
        byte[] arrayOfByte1 = new byte[i];
        int j = 0;
        arrayOfByte1[j] = this.bType;
        arrayOfByte1[++j] = this.bVersion;
        ++j;
        for (int k = 0; k < this.reserved.length; ++k) {
            arrayOfByte1[k + j] = this.reserved[k];
        }
        j += this.reserved.length;
        byte[] arrayOfByte2 = ByteUtils.inverseCopyByte(ByteUtils.intToByte(this.algID), 0, ByteUtils.intToByte(this.algID).length);
        for (int l = 0; l < arrayOfByte2.length; ++l) {
            arrayOfByte1[l + j] = arrayOfByte2[l];
        }
        j += arrayOfByte2.length;
        byte[] arrayOfByte3 = ByteUtils.inverseCopyByte(ByteUtils.intToByte(this.magic), 0, ByteUtils.intToByte(this.magic).length);
        for (int i1 = 0; i1 < arrayOfByte3.length; ++i1) {
            arrayOfByte1[i1 + j] = arrayOfByte3[i1];
        }
        j += arrayOfByte3.length;
        byte[] arrayOfByte4 = ByteUtils.inverseCopyByte(ByteUtils.intToByte(this.bitlen), 0, ByteUtils.intToByte(this.bitlen).length);
        for (i2 = 0; i2 < arrayOfByte4.length; ++i2) {
            arrayOfByte1[i2 + j] = arrayOfByte4[i2];
        }
        j += arrayOfByte4.length;
        for (i2 = 0; i2 < this.keyBlob.length; ++i2) {
            arrayOfByte1[i2 + j] = this.keyBlob[i2];
        }
        return arrayOfByte1;
    }

    public int getAlgID() {
        return this.algID;
    }

    public BigInteger getKeyBlob() {
        return this.keyBlobBigInt;
    }

    public byte[] getKeyBlobByte() {
        return this.keyBlob;
    }

    public BigInteger getKeyX() {
        return this.keyX;
    }

    public BigInteger getKeyY() {
        return this.keyY;
    }

    public String keyToStr() {
        return this.keyString;
    }

    public void setKeyBlob(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) {
        int j;
        int i = paramArrayOfByte1.length + paramArrayOfByte2.length;
        this.bitlen = i * 8;
        this.keyBlob = new byte[i];
        for (j = 0; j < paramArrayOfByte1.length; ++j) {
            this.keyBlob[j] = paramArrayOfByte1[j];
        }
        for (j = 0; j < paramArrayOfByte2.length; ++j) {
            this.keyBlob[j + paramArrayOfByte1.length] = paramArrayOfByte2[j];
        }
        this.updateDependencies();
    }

    public byte[] getBlobByte(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) {
        int j;
        int i = 0;
        byte[] arrayOfByte = new byte[paramArrayOfByte1.length + paramArrayOfByte2.length - 2];
        for (j = 1; j < paramArrayOfByte1.length; ++j) {
            arrayOfByte[i] = paramArrayOfByte1[j];
            ++i;
        }
        for (j = 1; j < paramArrayOfByte2.length; ++j) {
            arrayOfByte[i] = paramArrayOfByte2[j];
            ++i;
        }
        return arrayOfByte;
    }

    public boolean checkOpenKeyBlob(byte[] paramArrayOfByte) {
        return paramArrayOfByte[0] == 6 && paramArrayOfByte[1] == 2;
    }

    public byte[] getKeyYAsByteArray() {
        return ByteUtils.inverseCopyByte(this.keyBlob, this.keyBlob.length / 2, this.keyBlob.length / 2);
    }

    public byte[] getKeyXAsByteArray() {
        return ByteUtils.inverseCopyByte(this.keyBlob, 0, this.keyBlob.length / 2);
    }

    private void updateDependencies() {
        byte[] arrayOfByte = this.getKeyXAsByteArray();
        this.keyX = new BigInteger(1, arrayOfByte);
        arrayOfByte = this.getKeyYAsByteArray();
        this.keyY = new BigInteger(1, arrayOfByte);
        this.keyBlobBigInt = new BigInteger(1, this.keyBlob);
        this.keyString = ByteUtils.array2hex(this.keyBlob);
    }
}

