/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.PBEParametersGenerator;
import kz.gov.pki.kalkan.crypto.digests.MD2Digest;
import kz.gov.pki.kalkan.crypto.digests.MD5Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA256Digest;
import kz.gov.pki.kalkan.crypto.generators.OpenSSLPBEParametersGenerator;
import kz.gov.pki.kalkan.crypto.generators.PKCS12ParametersGenerator;
import kz.gov.pki.kalkan.crypto.generators.PKCS5S1ParametersGenerator;
import kz.gov.pki.kalkan.crypto.generators.PKCS5S2ParametersGenerator;
import kz.gov.pki.kalkan.crypto.params.DESParameters;
import kz.gov.pki.kalkan.crypto.params.KeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithIV;
import kz.gov.pki.kalkan.jce.provider.JCEPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int MD2 = 5;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int type, int hash) {
            PBEParametersGenerator generator;
            block12: {
                block14: {
                    block13: {
                        block11: {
                            if (type != 0) break block11;
                            switch (hash) {
                                case 5: {
                                    generator = new PKCS5S1ParametersGenerator(new MD2Digest());
                                    break block12;
                                }
                                case 0: {
                                    generator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block12;
                                }
                                case 1: {
                                    generator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block12;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (type != 1 && type != 5) break block13;
                        generator = new PKCS5S2ParametersGenerator();
                        break block12;
                    }
                    if (type != 2) break block14;
                    switch (hash) {
                        case 5: {
                            generator = new PKCS12ParametersGenerator(new MD2Digest());
                            break block12;
                        }
                        case 0: {
                            generator = new PKCS12ParametersGenerator(new MD5Digest());
                            break block12;
                        }
                        case 1: {
                            generator = new PKCS12ParametersGenerator(new SHA1Digest());
                            break block12;
                        }
                        case 4: {
                            generator = new PKCS12ParametersGenerator(new SHA256Digest());
                            break block12;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                generator = new OpenSSLPBEParametersGenerator();
            }
            return generator;
        }

        static CipherParameters makePBEParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec, String targetAlgorithm) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = pbeKey.getIvSize() != 0 ? generator.generateDerivedParameters(pbeKey.getKeySize(), pbeKey.getIvSize()) : generator.generateDerivedParameters(pbeKey.getKeySize());
            if (targetAlgorithm.startsWith("DES")) {
                KeyParameter kParam;
                if (param instanceof ParametersWithIV) {
                    kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                    DESParameters.setOddParity(kParam.getKey());
                } else {
                    kParam = (KeyParameter)param;
                    DESParameters.setOddParity(kParam.getKey());
                }
            }
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(pbeKey.getKeySize());
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEParameters(PBEKeySpec keySpec, int type, int hash, int keySize, int ivSize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(keySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(keySpec.getPassword());
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(PBEKeySpec keySpec, int type, int hash, int keySize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(keySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(keySpec.getPassword());
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }
    }
}

