/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.pkcs.PBKDF2Params;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.PasswordConverter;
import kz.gov.pki.kalkan.jce.provider.JCEPBEKey;
import kz.gov.pki.kalkan.jce.provider.PBE;
import kz.gov.pki.kalkan.jce.provider.PBKDF2Key;
import kz.gov.pki.kalkan.jce.provider.symmetric.util.BaseAlgorithmParameters;
import kz.gov.pki.kalkan.jce.provider.symmetric.util.BaseSecretKeyFactory;
import kz.gov.pki.kalkan.jce.spec.PBKDF2KeySpec;

public class PBEPBKDF2 {
    private static final Map prfCodes = new HashMap();

    private PBEPBKDF2() {
    }

    static {
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA1, 1);
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA256, 4);
    }

    public static class PBKDF2withSHA256
    extends BasePBKDF2 {
        public PBKDF2withSHA256() {
            super("PBKDF2", 5, 4);
        }
    }

    public static class PBKDF2withUTF8
    extends BasePBKDF2 {
        public PBKDF2withUTF8() {
            super("PBKDF2", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;
        private int defaultDigest;

        public BasePBKDF2(String name, int scheme) {
            this(name, scheme, 1);
        }

        public BasePBKDF2(String name, int scheme, int defaultDigest) {
            super(name, PKCSObjectIdentifiers.id_PBKDF2);
            this.scheme = scheme;
            this.defaultDigest = defaultDigest;
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    return new PBKDF2Key(((PBEKeySpec)keySpec).getPassword(), this.scheme == 1 ? PasswordConverter.ASCII : PasswordConverter.UTF8);
                }
                if (pbeSpec.getIterationCount() <= 0) {
                    throw new InvalidKeySpecException("positive iteration count required: " + pbeSpec.getIterationCount());
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                if (pbeSpec instanceof PBKDF2KeySpec) {
                    PBKDF2KeySpec spec = (PBKDF2KeySpec)pbeSpec;
                    int digest = this.getDigestCode(spec.getPrf().getObjectId());
                    int keySize = pbeSpec.getKeyLength();
                    int ivSize = -1;
                    CipherParameters param = PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, digest, keySize);
                    return new JCEPBEKey(this.algName, this.algOid, this.scheme, digest, keySize, ivSize, pbeSpec, param);
                }
                int digest = this.defaultDigest;
                int keySize = pbeSpec.getKeyLength();
                int ivSize = -1;
                CipherParameters param = PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, digest, keySize);
                return new JCEPBEKey(this.algName, this.algOid, this.scheme, digest, keySize, ivSize, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }

        private int getDigestCode(DERObjectIdentifier algorithm) throws InvalidKeySpecException {
            Integer code = (Integer)prfCodes.get(algorithm);
            if (code != null) {
                return code;
            }
            throw new InvalidKeySpecException("Invalid KeySpec: unknown PRF algorithm " + algorithm);
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBKDF2Params params;

        protected byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Oooops! " + e.toString());
            }
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PBKDF2 PBE parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        protected void engineInit(byte[] params) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Object.fromByteArray(params));
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in PBKDF2 parameters object");
        }

        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }
}

