/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric;

import java.util.HashMap;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;

public class ECMappings
extends HashMap {
    public ECMappings() {
        this.put("KeyFactory.EC", "kz.gov.pki.kalkan.jce.provider.asymmetric.ec.KeyFactory$EC");
        this.put("Alg.Alias.KeyFactory." + X9ObjectIdentifiers.id_ecPublicKey, "EC");
        this.put("Alg.Alias.KeyFactory." + X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC");
        this.put("KeyFactory.ECGOST3410", "kz.gov.pki.kalkan.jce.provider.asymmetric.ec.KeyFactory$ECGOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410-2001", "ECGOST3410");
        this.put("Alg.Alias.KeyFactory.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_2001, "ECGOST3410");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR34310_2004, "ECGOST3410");
        this.put("KeyPairGenerator.EC", "kz.gov.pki.kalkan.jce.provider.asymmetric.ec.KeyPairGenerator$EC");
        this.put("Alg.Alias.KeyPairGenerator." + X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC");
    }

    private void addSignatureAlgorithm(String digest, String algorithm, String className, DERObjectIdentifier oid) {
        String mainName = digest + "WITH" + algorithm;
        String jdk11Variation1 = digest + "with" + algorithm;
        String jdk11Variation2 = digest + "With" + algorithm;
        String alias = digest + "/" + algorithm;
        this.put("Signature." + mainName, className);
        this.put("Alg.Alias.Signature." + jdk11Variation1, mainName);
        this.put("Alg.Alias.Signature." + jdk11Variation2, mainName);
        this.put("Alg.Alias.Signature." + alias, mainName);
        this.put("Alg.Alias.Signature." + oid, mainName);
        this.put("Alg.Alias.Signature.OID." + oid, mainName);
    }
}

