/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.crypto.AsymmetricCipherKeyPair;
import kz.gov.pki.kalkan.crypto.generators.ECKeyPairGenerator;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECKeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.ECPrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.EC5Util;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15.EcGost3410_2015PrivateKey;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15.EcGost3410_2015PublicKey;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveSpec;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECPoint;
import kz.gov.pki.kalkan.pcsc.AKGOST3410_2015PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKPublicKeyUtil;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.generators.AKAlgorithmParameterSpec;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ECKeyGenerationParameters param;
    int certainty = 50;
    SecureRandom random = new SecureRandom();
    ECKeyPairGenerator engine = new ECKeyPairGenerator();
    private static Map<Integer, ECGenParameterSpec> ecParameters = new HashMap<Integer, ECGenParameterSpec>();
    Object ecParams = null;
    int strength = 512;
    boolean initialised = false;
    String algorithm = "ECGOST3410-2015";
    private AKAlgorithmParameterSpec tokenSpec = null;

    public KeyPairGeneratorSpi() {
        super("ECGOST3410-2015");
    }

    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        this.ecParams = ecParameters.get(strength);
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof kz.gov.pki.kalkan.jce.spec.ECParameterSpec) {
            kz.gov.pki.kalkan.jce.spec.ECParameterSpec p = (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)params;
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof ECParameterSpec) {
            ECParameterSpec p = (ECParameterSpec)params;
            this.ecParams = params;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof ECGenParameterSpec) {
            String parameterSpecName = ((ECGenParameterSpec)params).getName();
            if (!parameterSpecName.equals("Gost3410-2015-256-ParamSetA") && !parameterSpecName.equals("Gost3410-2015-512-ParamSetA")) {
                throw new InvalidAlgorithmParameterException("inappropriate curve name: " + parameterSpecName);
            }
            ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(parameterSpecName);
            if (ecP == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + parameterSpecName);
            }
            this.ecParams = new ECNamedCurveSpec(parameterSpecName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof AKAlgorithmParameterSpec) {
            this.tokenSpec = (AKAlgorithmParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
        }
    }

    public KeyPair generateKeyPair() {
        EcGost3410_2015PublicKey pubKey;
        AlgorithmParameterSpec p;
        if (this.tokenSpec != null) {
            AKGOST3410_2015PrivateKey privateKey = null;
            PublicKey publicKey = null;
            try {
                AKToken token = TokenDispatcher.INSTANCE.instantiateToken(this.tokenSpec.getSmartcard(), this.tokenSpec.getPassword());
                byte keyId = token.generateKeyPair("GOST512", this.tokenSpec.getAlias(), false, 0);
                privateKey = new AKGOST3410_2015PrivateKey(token, keyId);
                publicKey = AKPublicKeyUtil.generatePublic("GOST512", token.getPublicKey("GOST512", keyId));
            }
            catch (KalkanException e) {
                throw new IllegalStateException(this.tokenSpec.getSmartcard().getTerminalName() + " Key Pair Generator failed");
            }
            return new KeyPair(publicKey, privateKey);
        }
        if (!this.initialised) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        int componentSize = this.param.getStrength() / 8 == 64 ? 64 : 32;
        ECPublicKeyParameters pub = null;
        ECPrivateKeyParameters priv = null;
        boolean isCorrectPublic = false;
        while (!isCorrectPublic) {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            pub = (ECPublicKeyParameters)pair.getPublic();
            priv = (ECPrivateKeyParameters)pair.getPrivate();
            byte[] y = pub.getQ().getY().toBigInteger().toByteArray();
            byte[] x = pub.getQ().getX().toBigInteger().toByteArray();
            if (x.length < componentSize || y.length < componentSize) {
                System.err.println("we want longer value!");
                continue;
            }
            if (x.length == componentSize && x[0] == 0 || y.length == componentSize && y[0] == 0) {
                System.err.println("first byte is 0!");
                continue;
            }
            if (x[x.length - 1] == 0 || y[y.length - 1] == 0) {
                System.err.println("last byte is 0!");
                continue;
            }
            isCorrectPublic = true;
        }
        if (this.ecParams instanceof kz.gov.pki.kalkan.jce.spec.ECParameterSpec) {
            p = (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)this.ecParams;
            pubKey = new EcGost3410_2015PublicKey(this.algorithm, pub, (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)p);
            return new KeyPair(pubKey, new EcGost3410_2015PrivateKey(this.algorithm, priv, pubKey, (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)p));
        }
        if (this.ecParams == null) {
            return new KeyPair(new EcGost3410_2015PublicKey(this.algorithm, pub), new EcGost3410_2015PrivateKey(this.algorithm, priv));
        }
        p = (ECParameterSpec)this.ecParams;
        pubKey = new EcGost3410_2015PublicKey(this.algorithm, pub, (ECParameterSpec)p);
        return new KeyPair(pubKey, new EcGost3410_2015PrivateKey(this.algorithm, priv, pubKey, (ECParameterSpec)p));
    }

    static {
        ecParameters.put(256, new ECGenParameterSpec("Gost3410-2015-256-ParamSetA"));
        ecParameters.put(512, new ECGenParameterSpec("Gost3410-2015-512-ParamSetA"));
    }
}

