/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DEROutputStream;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cms.ContentInfo;
import kz.gov.pki.kalkan.asn1.cms.IssuerAndSerialNumber;
import kz.gov.pki.kalkan.asn1.cms.SignedData;
import kz.gov.pki.kalkan.asn1.cms.SignerIdentifier;
import kz.gov.pki.kalkan.asn1.cms.SignerInfo;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.TBSCertificateStructure;
import kz.gov.pki.kalkan.jce.provider.cms.CMSAttributeTableGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.CMSUtils;
import kz.gov.pki.kalkan.jce.provider.cms.DefaultSignedAttributeTableGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        String encOID = cert.getSigAlgOID();
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = cert.getSigAlgOID();
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        String encOID = cert.getSigAlgOID();
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, signedAttrGen, unsignedAttrGen, null));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(signedContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ContentInfo encInfo;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        this._digests.clear();
        for (Object signer : this._signers) {
            AlgorithmIdentifier digAlgId;
            try {
                digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(((SignerInformation)signer).toSignerInfo());
        }
        for (Object signer : this.signerInfs) {
            String digAlgOid = ((SignerInf)signer).getDigestAlgOID();
            if (digAlgOid.equals("1.2.398.3.10.1.3")) {
                if (((SignerInf)signer).encOID.equals(CMSSignedGenerator.ENCRYPTION_ECGOST3410_2015_512)) {
                    digAlgOid = CMSSignedGenerator.DIGEST_GOST3411_2015_512;
                } else if (((SignerInf)signer).encOID.equals(CMSSignedGenerator.ENCRYPTION_GOST3411)) {
                    digAlgOid = CMSSignedGenerator.DIGEST_GOST3411_GT;
                } else if (((SignerInf)signer).encOID.equals(CMSSignedGenerator.ENCRYPTION_ECGOST34310_2004_WITH_GOST34311_95_TEST)) {
                    digAlgOid = CMSSignedGenerator.DIGEST_GOST34311_95;
                } else if (((SignerInf)signer).encOID.equals(CMSSignedGenerator.ENCRYPTION_RSA_WITH_SHA1)) {
                    digAlgOid = CMSSignedGenerator.DIGEST_SHA1;
                } else if (((SignerInf)signer).encOID.equals(CMSSignedGenerator.ENCRYPTION_RSA_WITH_SHA256)) {
                    digAlgOid = CMSSignedGenerator.DIGEST_SHA256;
                } else {
                    throw new CMSException("Unknown signature algorithm: " + ((SignerInf)signer).encOID);
                }
            }
            try {
                AlgorithmIdentifier digAlgId = this.makeAlgId(digAlgOid, ((SignerInf)signer).getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(((SignerInf)signer).toSignerInfo(contentTypeOID, content, sigProvider, addDefaultAttributes));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = CMSUtils.createDerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = CMSUtils.createDerSetFromList(this._crls);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            DEROctetString octs = new DEROctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    private class SignerInf {
        PrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
        }

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSigneTable;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, String sigProvider, boolean addDefaultAttributes) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            AttributeTable signed;
            AlgorithmIdentifier encAlgId = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = null;
            if (this.digestOID.equals("1.2.398.3.10.1.3")) {
                if (this.encOID.equals(CMSSignedGenerator.ENCRYPTION_GOST3411)) {
                    this.digestOID = CMSSignedGenerator.DIGEST_GOST3411_GT;
                    signatureName = "ECGOST34310";
                }
                if (this.encOID.equals(CMSSignedGenerator.ENCRYPTION_ECGOST34310_2004_WITH_GOST34311_95_TEST)) {
                    this.digestOID = CMSSignedGenerator.DIGEST_GOST34311_95;
                    signatureName = "ECGOST34310";
                }
                if (this.encOID.equals(CMSSignedGenerator.ENCRYPTION_ECGOST3410_2015_512)) {
                    this.digestOID = CMSSignedGenerator.DIGEST_GOST3411_2015_512;
                    signatureName = "ECGOST3410-2015-512";
                }
                if (this.encOID.equals(CMSSignedGenerator.ENCRYPTION_RSA_WITH_SHA1)) {
                    this.digestOID = CMSSignedGenerator.DIGEST_SHA1;
                    signatureName = "RSA";
                }
                if (this.encOID.equals(CMSSignedGenerator.ENCRYPTION_RSA_WITH_SHA256)) {
                    this.digestOID = CMSSignedGenerator.DIGEST_SHA256;
                    signatureName = "SHA256withRSA";
                }
            } else {
                signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            }
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
            byte[] hash = null;
            if (content != null) {
                content.write(new DigOutputStream(dig));
                hash = dig.digest();
                CMSSignedDataGenerator.this._digests.put(this.digestOID, hash.clone());
            }
            if (addDefaultAttributes) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            ASN1Set signedAttr = CMSSignedDataGenerator.this.getAttributeSet(signed);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
            } else {
                content.write(bOut);
            }
            sig.initSign(this.key);
            sig.update(bOut.toByteArray());
            DEROctetString encDigest = new DEROctetString(sig.sign());
            Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = CMSSignedDataGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature sig) {
            this.sig = sig;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.sig.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }

        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

