/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;

public class CMSTypedStream {
    private static final int BUF_SIZ = 32768;
    private final String _oid;
    private final InputStream _in;
    private final int _bufSize;

    public CMSTypedStream(InputStream in) {
        this(PKCSObjectIdentifiers.data.getId(), in, 32768);
    }

    public CMSTypedStream(String oid, InputStream in) {
        this(oid, in, 32768);
    }

    public CMSTypedStream(String oid, InputStream in, int bufSize) {
        this._oid = oid;
        this._bufSize = bufSize;
        this._in = new FullReaderStream(in, bufSize);
    }

    public String getContentType() {
        return this._oid;
    }

    public InputStream getContentStream() {
        return this._in;
    }

    public void drain() throws IOException {
        byte[] buf = new byte[this._bufSize];
        while (this._in.read(buf, 0, buf.length) > 0) {
        }
        this._in.close();
    }

    private class FullReaderStream
    extends InputStream {
        InputStream _stream;

        FullReaderStream(InputStream in, int bufSize) {
            this._stream = new BufferedInputStream(in, bufSize);
        }

        public int read() throws IOException {
            return this._stream.read();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int rd = 0;
            int total = 0;
            while (len != 0 && (rd = this._stream.read(buf, off, len)) > 0) {
                off += rd;
                len -= rd;
                total += rd;
            }
            if (total > 0) {
                return total;
            }
            return -1;
        }

        public void close() throws IOException {
            this._stream.close();
        }
    }
}

