/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequenceGenerator;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;

public class AKPublicKeyUtil {
    public static PublicKey generatePublic(String algorithm, byte[] keyData) {
        DERObject params;
        if (keyData == null) {
            throw new NullPointerException("keyData is null");
        }
        PublicKey ret = null;
        byte[] encodedKeyInfo = null;
        if ("RSA".equals(algorithm)) {
            byte[] modulus;
            if ((keyData[0] & 0xFF) > 127) {
                modulus = new byte[keyData.length + 1];
                System.arraycopy(keyData, 0, modulus, 1, keyData.length);
            } else {
                modulus = keyData;
            }
            BigInteger publicExponent = BigInteger.valueOf(65537L);
            try {
                ByteArrayOutputStream pkSeqOut = new ByteArrayOutputStream();
                DERSequenceGenerator pkSeqGen = new DERSequenceGenerator(pkSeqOut);
                DERInteger pkModulus = new DERInteger(modulus);
                DERInteger pkPubExp = new DERInteger(publicExponent);
                pkSeqGen.addObject(pkModulus);
                pkSeqGen.addObject(pkPubExp);
                pkSeqGen.close();
                pkSeqOut.close();
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), pkSeqOut.toByteArray());
                encodedKeyInfo = pkInfo.getDEREncoded();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } else if ("GOST".equals(algorithm)) {
            params = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DERSequenceGenerator seqGen = new DERSequenceGenerator(baos);
                seqGen.addObject(KNCAObjectIdentifiers.gost34310_2004_PKIGOVKZ_A);
                seqGen.addObject(KNCAObjectIdentifiers.gost34311_95_TestParamSet);
                seqGen.close();
                baos.close();
                ASN1InputStream asn1is = new ASN1InputStream(baos.toByteArray());
                params = asn1is.readObject();
                asn1is.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(KNCAObjectIdentifiers.gost34310_2004, params), new DEROctetString(keyData));
            encodedKeyInfo = pkInfo.getDEREncoded();
        } else if ("GOST512".equals(algorithm)) {
            params = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DERSequenceGenerator seqGen = new DERSequenceGenerator(baos);
                seqGen.addObject(KNCAObjectIdentifiers.gost3410_2015_512_ParamSetA);
                seqGen.addObject(KNCAObjectIdentifiers.gost3411_2015_512);
                seqGen.close();
                baos.close();
                ASN1InputStream asn1is = new ASN1InputStream(baos.toByteArray());
                params = asn1is.readObject();
                asn1is.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(KNCAObjectIdentifiers.gost3410_2015_512, params), new DEROctetString(keyData));
            encodedKeyInfo = pkInfo.getDEREncoded();
        } else {
            throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
        }
        try {
            ret = KeyFactory.getInstance("X.509", "KALKAN").generatePublic(new X509EncodedKeySpec(encodedKeyInfo));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return ret;
    }
}

