/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.keystores;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.pcsc.AKPublicKeyUtil;
import kz.gov.pki.kalkan.pcsc.Smartcard;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.keystores.AbstractTokenKeyStore;
import kz.gov.pki.kalkan.util.io.Streams;

public class AKKZIDCardStore
extends AbstractTokenKeyStore {
    public Certificate engineGetCertificate(String alias) {
        Certificate ret = null;
        try {
            byte[] cert = this.token.getCertificate(alias);
            if (cert != null) {
                ret = CertificateFactory.getInstance("X509", "KALKAN").generateCertificate(new ByteArrayInputStream(cert));
                byte[] pubKey = this.token.getPublicKey("RSA", this.token.getAliases().get(alias));
                PublicKey publicKey = AKPublicKeyUtil.generatePublic("RSA", pubKey);
                if (!publicKey.equals(ret.getPublicKey())) {
                    ret = null;
                }
            }
        }
        catch (CertificateException e) {
            System.err.println(e.getMessage());
        }
        catch (KalkanException e) {
            System.err.println(e);
        }
        catch (NoSuchProviderException e) {
            System.err.println(e.getMessage());
        }
        return ret;
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        TokenDispatcher.INSTANCE.removeToken(this.token);
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            throw new IOException("Terminal name is null");
        }
        String tName = new String(Streams.readAll(stream));
        try {
            Smartcard smartcard = new Smartcard("AKKZIDCardStore", tName);
            this.token = TokenDispatcher.INSTANCE.instantiateToken(smartcard, password);
        }
        catch (KalkanException e) {
            throw new IOException(e);
        }
    }
}

