/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.tsp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import kz.gov.pki.kalkan.asn1.DERBoolean;
import kz.gov.pki.kalkan.asn1.DERGeneralizedTime;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.ess.ESSCertID;
import kz.gov.pki.kalkan.asn1.ess.SigningCertificate;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.tsp.Accuracy;
import kz.gov.pki.kalkan.tsp.MessageImprint;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TSPUtil;
import kz.gov.pki.kalkan.tsp.TSTInfo;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampToken;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private String tsaPolicyOID;
    PrivateKey key;
    X509Certificate cert;
    String digestOID;
    AttributeTable signedAttr;
    AttributeTable unsignedAttr;
    CertStore certsAndCrls;

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID) throws IllegalArgumentException, TSPException {
        this(key, cert, digestOID, tsaPolicyOID, null, null);
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException, TSPException {
        this.key = key;
        this.cert = cert;
        this.digestOID = digestOID;
        this.tsaPolicyOID = tsaPolicyOID;
        this.unsignedAttr = unsignedAttr;
        TSPUtil.validateCertificate(cert);
        Hashtable<DERObjectIdentifier, Attribute> signedAttrs = null;
        signedAttrs = signedAttr != null ? signedAttr.toHashtable() : new Hashtable<DERObjectIdentifier, Attribute>();
        try {
            ESSCertID essCertid = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(cert.getEncoded()));
            signedAttrs.put(PKCSObjectIdentifiers.id_aa_signingCertificate, new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(new SigningCertificate(essCertid))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSPException("Can't find a SHA-1 implementation.", e);
        }
        catch (CertificateEncodingException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
        this.signedAttr = new AttributeTable(signedAttrs);
    }

    public void setCertificatesAndCRLs(CertStore certificates) throws CertStoreException, TSPException {
        this.certsAndCrls = certificates;
    }

    public void setAccuracySeconds(int accuracySeconds) {
        this.accuracySeconds = accuracySeconds;
    }

    public void setAccuracyMillis(int accuracyMillis) {
        this.accuracyMillis = accuracyMillis;
    }

    public void setAccuracyMicros(int accuracyMicros) {
        this.accuracyMicros = accuracyMicros;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setTSA(GeneralName tsa) {
        this.tsa = tsa;
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        DERObjectIdentifier digestAlgOID = new DERObjectIdentifier(request.getMessageImprintAlgOID());
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algID, request.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            DERInteger seconds = null;
            if (this.accuracySeconds > 0) {
                seconds = new DERInteger(this.accuracySeconds);
            }
            DERInteger millis = null;
            if (this.accuracyMillis > 0) {
                millis = new DERInteger(this.accuracyMillis);
            }
            DERInteger micros = null;
            if (this.accuracyMicros > 0) {
                micros = new DERInteger(this.accuracyMicros);
            }
            accuracy = new Accuracy(seconds, millis, micros);
        }
        DERBoolean derOrdering = null;
        if (this.ordering) {
            derOrdering = new DERBoolean(this.ordering);
        }
        DERInteger nonce = null;
        if (request.getNonce() != null) {
            nonce = new DERInteger(request.getNonce());
        }
        DERObjectIdentifier tsaPolicy = null;
        tsaPolicy = request.getReqPolicy() != null ? new DERObjectIdentifier(request.getReqPolicy()) : new DERObjectIdentifier(this.tsaPolicyOID);
        TSTInfo tstInfo = new TSTInfo(tsaPolicy, messageImprint, new DERInteger(serialNumber), new DERGeneralizedTime(genTime), accuracy, derOrdering, nonce, this.tsa, request.getExtensions());
        try {
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            byte[] derEncodedTSTInfo = tstInfo.getEncoded("DER");
            CertStore genCertStore = request.getCertReq() ? this.certsAndCrls : CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.certsAndCrls.getCRLs(null)));
            signedDataGenerator.addCertificatesAndCRLs(genCertStore);
            signedDataGenerator.addSigner(this.key, this.cert, this.digestOID, this.signedAttr, this.unsignedAttr);
            CMSSignedData signedData = signedDataGenerator.generate(PKCSObjectIdentifiers.id_ct_TSTInfo.getId(), new CMSProcessableByteArray(derEncodedTSTInfo), true, provider);
            return new TimeStampToken(signedData);
        }
        catch (CMSException cmsEx) {
            throw new TSPException("Error generating time-stamp token", cmsEx);
        }
        catch (IOException e) {
            throw new TSPException("Exception encoding info", e);
        }
        catch (CertStoreException e) {
            throw new TSPException("Exception handling CertStore", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new TSPException("Exception handling CertStore CRLs", e);
        }
    }
}

