/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathParameters;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import kz.gov.pki.kalkan.pkix.checker.KNCAOCSPChecker;
import kz.gov.pki.kalkan.util.Selector;
import kz.gov.pki.kalkan.x509.ExtendedPKIXBuilderParameters;
import kz.gov.pki.kalkan.x509.X509CertStoreSelector;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;

public class PKIXUtil {
    private Map<X500Principal, X509Certificate> caCertsMap = new HashMap<X500Principal, X509Certificate>();
    private KNCAOCSPChecker ocspChecker;
    private X509Certificate targetCert;
    private Collection<X509Certificate> caCertList;
    private List<PKIXCertPathChecker> checkerList;
    private List<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
    private Collection<X509CRL> crlList;
    private Date checkDate;
    private boolean allowExpired = false;

    public PKIXUtil(X509Certificate targetCert, Collection<X509Certificate> caCertList) {
        this.targetCert = targetCert;
        this.caCertList = caCertList == null ? new ArrayList() : caCertList;
        for (X509Certificate cert : this.caCertList) {
            this.caCertsMap.put(cert.getSubjectX500Principal(), cert);
        }
    }

    public PKIXUtil withDate(Date checkDate) {
        this.checkDate = checkDate;
        return this;
    }

    public PKIXUtil withOCSP() {
        this.ocspChecker = new KNCAOCSPChecker(this.caCertsMap);
        return this;
    }

    public PKIXUtil withExtraCheckers(List<PKIXCertPathChecker> checkerList) {
        this.checkerList = checkerList;
        return this;
    }

    public PKIXUtil withCRL(Collection<X509CRL> crlList) {
        this.crlList = crlList == null ? new ArrayList() : crlList;
        return this;
    }

    public PKIXUtil allowExpired() {
        this.allowExpired = true;
        return this;
    }

    public CertPathBuilderResult validate() throws ProviderUtilException {
        ExtendedPKIXBuilderParameters builderParams;
        X509Certificate topTrustedCert;
        X509Certificate cert;
        if (this.caCertList.size() == 0) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.NO_CACERT_LIST);
        }
        LinkedList<X509Extension> chainList = new LinkedList<X509Extension>();
        chainList.add(this.targetCert);
        X509Certificate trustedCert = this.caCertsMap.get(this.targetCert.getIssuerX500Principal());
        if (trustedCert == null) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND);
        }
        chainList.add(trustedCert);
        for (int i = 0; i < this.caCertsMap.size() && !(cert = (X509Certificate)chainList.peekLast()).getIssuerX500Principal().equals(cert.getSubjectX500Principal()) && (topTrustedCert = this.caCertsMap.get(cert.getIssuerX500Principal())) != null; ++i) {
            chainList.add(topTrustedCert);
        }
        this.certificateChain = chainList.stream().map(c -> (X509Certificate)c).collect(Collectors.toList());
        Collections.reverse(chainList);
        HashSet<TrustAnchor> trustedAnchors = new HashSet<TrustAnchor>();
        trustedAnchors.add(new TrustAnchor((X509Certificate)chainList.getFirst(), null));
        X509CertStoreSelector selector = new X509CertStoreSelector();
        selector.setCertificate(this.targetCert);
        try {
            builderParams = new ExtendedPKIXBuilderParameters(trustedAnchors, (Selector)selector);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.PROVIDER_INVOCATION_FAILURE, (Throwable)e);
        }
        builderParams.setSigProvider("KALKAN");
        builderParams.setUseDeltasEnabled(true);
        if (this.allowExpired && this.targetCert.getNotAfter().before(new Date())) {
            builderParams.setDate(this.targetCert.getNotAfter());
        }
        if (this.checkDate != null) {
            builderParams.setDate(this.checkDate);
        }
        if (this.crlList == null) {
            builderParams.setRevocationEnabled(false);
        } else {
            if (this.crlList.size() == 0) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.NO_CRL_LIST);
            }
            Date validDate = this.checkDate == null ? new Date() : this.checkDate;
            for (X509CRL crl : this.crlList) {
                if (!validDate.after(crl.getNextUpdate())) continue;
                throw new ProviderUtilException(ProviderUtilExceptionCode.OUTDATED_CRL);
            }
            chainList.addAll(this.crlList);
        }
        CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(chainList);
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, "KALKAN");
            builderParams.addCertStore(certStore);
            builderParams.setCertPathCheckers(this.checkerList);
            builderParams.addCertPathChecker((PKIXCertPathChecker)this.ocspChecker);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", "KALKAN");
            return certPathBuilder.build((CertPathParameters)builderParams);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.PROVIDER_INVOCATION_FAILURE, (Throwable)e);
        }
        catch (CertPathBuilderException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CERTPATH_BUILDING_FAILURE, (Throwable)e);
        }
    }

    @Deprecated
    public static CertPathBuilderResult validate(X509Certificate targetCert, Collection<X509Certificate> caCertList, boolean useOCSP) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertPathBuilderException, ProviderUtilException {
        return PKIXUtil.validate(targetCert, caCertList, new ArrayList<X509CRL>(), null, useOCSP);
    }

    @Deprecated
    public static CertPathBuilderResult validate(X509Certificate targetCert, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, boolean useOCSP) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertPathBuilderException, ProviderUtilException {
        return PKIXUtil.validate(targetCert, caCertList, crlList, null, useOCSP);
    }

    @Deprecated
    public static CertPathBuilderResult validate(X509Certificate targetCert, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, Date checkDate, boolean useOCSP) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertPathBuilderException, ProviderUtilException {
        X509Certificate topTrustedCert;
        X509Certificate cert;
        if (caCertList == null) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.NO_CACERT_LIST);
        }
        HashMap<X500Principal, X509Certificate> caCertsMap = new HashMap<X500Principal, X509Certificate>();
        LinkedList<X509Extension> chainList = new LinkedList<X509Extension>();
        chainList.add(targetCert);
        for (X509Certificate cert2 : caCertList) {
            caCertsMap.put(cert2.getSubjectX500Principal(), cert2);
        }
        X509Certificate trustedCert = (X509Certificate)caCertsMap.get(targetCert.getIssuerX500Principal());
        if (trustedCert == null) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND);
        }
        chainList.add(trustedCert);
        for (int i = 0; i < caCertsMap.size() && !(cert = (X509Certificate)chainList.peekLast()).getIssuerX500Principal().equals(cert.getSubjectX500Principal()) && (topTrustedCert = (X509Certificate)caCertsMap.get(cert.getIssuerX500Principal())) != null; ++i) {
            chainList.add(topTrustedCert);
        }
        Collections.reverse(chainList);
        HashSet<TrustAnchor> trustedAnchors = new HashSet<TrustAnchor>();
        trustedAnchors.add(new TrustAnchor((X509Certificate)chainList.getFirst(), null));
        CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(chainList);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, "KALKAN");
        X509CertStoreSelector selector = new X509CertStoreSelector();
        selector.setCertificate(targetCert);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", "KALKAN");
        ExtendedPKIXBuilderParameters builderParams = new ExtendedPKIXBuilderParameters(trustedAnchors, (Selector)selector);
        builderParams.setSigProvider("KALKAN");
        builderParams.addCertStore(certStore);
        builderParams.setUseDeltasEnabled(true);
        builderParams.setDate(checkDate);
        if (useOCSP) {
            KNCAOCSPChecker checker = new KNCAOCSPChecker(caCertsMap);
            builderParams.addCertPathChecker((PKIXCertPathChecker)checker);
        }
        if (crlList == null) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.NO_CRL_LIST);
        }
        if (crlList.size() == 0) {
            builderParams.setRevocationEnabled(false);
        } else {
            Date validDate = checkDate == null ? new Date() : checkDate;
            for (X509CRL crl : crlList) {
                if (!validDate.after(crl.getNextUpdate())) continue;
                throw new ProviderUtilException(ProviderUtilExceptionCode.OUTDATED_CRL);
            }
            chainList.addAll(crlList);
        }
        return certPathBuilder.build((CertPathParameters)builderParams);
    }

    public List<X509Certificate> getCertificateChain() {
        return Collections.unmodifiableList(this.certificateChain);
    }
}

