/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.reference;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.utils.X509Util;

public class KeyStoreEntry {
    private String keyId;
    private String algorithm;
    private String subjectCn;
    private String issuerCn;
    private String serialNumber;
    private X509Certificate x509Certificate;

    public KeyStoreEntry(String keyId, String algorithm, X509Certificate x509Certificate) throws CertificateException {
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.x509Certificate = x509Certificate;
        if (x509Certificate != null) {
            this.subjectCn = X509Util.getRdn(X509Util.getSubjectDN(x509Certificate), X509Name.CN, 0);
            this.issuerCn = X509Util.getRdn(X509Util.getIssuerDN(x509Certificate), X509Name.CN, 0);
            this.serialNumber = Hex.encodeStr((byte[])x509Certificate.getSerialNumber().toByteArray());
        }
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getSubjectCn() {
        return this.subjectCn;
    }

    public void setSubjectCn(String subjectCn) {
        this.subjectCn = subjectCn;
    }

    public String getIssuerCn() {
        return this.issuerCn;
    }

    public void setIssuerCn(String issuerCn) {
        this.issuerCn = issuerCn;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String toString() {
        return "KeyStoreEntry(keyId=" + this.getKeyId() + ", algorithm=" + this.getAlgorithm() + ", subjectCn=" + this.getSubjectCn() + ", issuerCn=" + this.getIssuerCn() + ", serialNumber=" + this.getSerialNumber() + ", x509Certificate=" + this.getX509Certificate() + ")";
    }
}

