/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.xmldsig.algorithms.implementations;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureBaseGost
extends SignatureAlgorithmSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureBaseGost.class);
    private final Signature signature;

    public SignatureBaseGost() throws XMLSignatureException {
        String algorithmID = JCEMapper.translateURItoJCEID((String)this.engineGetURI());
        this.signature = this.getSignature(algorithmID);
        LOG.debug("Created SignatureGOST using {} and provider {}", (Object)algorithmID, (Object)this.signature.getProvider());
    }

    Signature getSignature(String algorithmID) throws XMLSignatureException {
        try {
            String providerId = JCEMapper.getProviderId();
            return Signature.getInstance(algorithmID, providerId);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            Object[] exArgs = new Object[]{algorithmID, ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this.signature.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this.signature.getProvider().getName();
    }

    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this.signature.update(input);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this.signature.update(input);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this.signature.update(buf, offset, len);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        try {
            this.signature.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineInitSign(Key key, SecureRandom sr) throws XMLSignatureException {
        try {
            this.signature.initSign((PrivateKey)key, sr);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec params) throws XMLSignatureException {
        this.engineInitSign(key);
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.signature.sign();
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        SignatureBaseGost.engineInitVerify((Key)key, (Signature)this.signature);
    }

    protected boolean engineVerify(byte[] bytes) throws XMLSignatureException {
        try {
            return this.signature.verify(bytes);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSignatureException((Exception)ex);
        }
    }

    protected void engineSetHMACOutputLength(int i) throws XMLSignatureException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class GostR34102015GostR34112015_512
    extends SignatureBaseGost {
        public String engineGetURI() {
            return "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34102015-gostr34112015-512";
        }
    }

    public static class Gost34310Gost34311
    extends SignatureBaseGost {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#gost34310-gost34311";
        }
    }
}

