package kz.arta.nca_iiscon.service;

import kz.arta.nca_iiscon.data.search.SearchOrderByReferenceNumberRequest;
import kz.arta.nca_iiscon.shep.*;
import kz.arta.nca_iiscon.util.XmlTemplateBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.xml.bind.*;

@Slf4j
@Service
public class NcaIISConService {
    @Value("${login}")
    private String senderIdSHEP;
    @Value("${password}")
    private String senderPassSHEP;
    @Value("${service_id}")
    private String serviceIdSHEP;
    @Value("${service_url}")
    private String urlSHEP;

    @Autowired
    private RestService restService;

    public Object sendRequestByTemplate(SearchOrderByReferenceNumberRequest referenceNumberRequest) throws Exception {
        String request;
        try {

            request = XmlTemplateBuilder.buildXMLReference(referenceNumberRequest, serviceIdSHEP, senderIdSHEP, senderPassSHEP);

            log.info("Request: {}\n", request);
            Object response =  restService.getPostWithsSoapHeaders(urlSHEP, request);
            log.info("Response: {}\n", response);

            return response;
        } catch (Exception e) {
            log.error("Ошибка: {}", e.getMessage(), e);
            e.printStackTrace();
            return e.getMessage();
        }
    }

}