/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1;

import java.io.IOException;
import java.util.Enumeration;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1OutputStream;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.BERConstructedOctetString;
import kz.gov.pki.kalkan.asn1.BEROutputStream;
import kz.gov.pki.kalkan.asn1.BERSequence;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DEROutputStream;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int tagNo, DEREncodable obj) {
        super(tagNo, obj);
    }

    public BERTaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        super(explicit, tagNo, obj);
    }

    public BERTaggedObject(int tagNo) {
        super(false, tagNo, new BERSequence());
    }

    void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.writeTag(160, this.tagNo);
            out.write(128);
            if (!this.empty) {
                if (!this.explicit) {
                    Enumeration e;
                    if (this.obj instanceof ASN1OctetString) {
                        if (this.obj instanceof BERConstructedOctetString) {
                            e = ((BERConstructedOctetString)this.obj).getObjects();
                        } else {
                            ASN1OctetString octs = (ASN1OctetString)this.obj;
                            BERConstructedOctetString berO = new BERConstructedOctetString(octs.getOctets());
                            e = berO.getObjects();
                        }
                    } else if (this.obj instanceof ASN1Sequence) {
                        e = ((ASN1Sequence)this.obj).getObjects();
                    } else if (this.obj instanceof ASN1Set) {
                        e = ((ASN1Set)this.obj).getObjects();
                    } else {
                        throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                    }
                    while (e.hasMoreElements()) {
                        out.writeObject(e.nextElement());
                    }
                } else {
                    out.writeObject(this.obj);
                }
            }
            out.write(0);
            out.write(0);
        } else {
            super.encode(out);
        }
    }
}

