/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.modes.gcm;

import kz.gov.pki.kalkan.crypto.util.Pack;

abstract class GCMUtil {
    GCMUtil() {
    }

    static int[] asInts(byte[] bs) {
        int[] us = new int[]{Pack.bigEndianToInt(bs, 0), Pack.bigEndianToInt(bs, 4), Pack.bigEndianToInt(bs, 8), Pack.bigEndianToInt(bs, 12)};
        return us;
    }

    static void multiplyP(int[] x) {
        boolean lsb = (x[3] & 1) != 0;
        GCMUtil.shiftRight(x);
        if (lsb) {
            x[0] = x[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] x) {
        for (int i = 8; i != 0; --i) {
            GCMUtil.multiplyP(x);
        }
    }

    static void shiftRight(byte[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i] & 0xFF;
            block[i] = (byte)(b >>> 1 | bit);
            if (++i == 16) break;
            bit = (b & 1) << 7;
        }
    }

    static void shiftRight(int[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i];
            block[i] = b >>> 1 | bit;
            if (++i == 4) break;
            bit = b << 31;
        }
    }

    static void xor(byte[] block, byte[] val) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            block[n] = (byte)(block[n] ^ val[i]);
        }
    }

    static void xor(int[] block, int[] val) {
        for (int i = 3; i >= 0; --i) {
            int n = i;
            block[n] = block[n] ^ val[i];
        }
    }
}

