/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.nist.NISTNamedCurves;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.sec.SECNamedCurves;
import kz.gov.pki.kalkan.asn1.teletrust.TeleTrusTNamedCurves;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.RSAPublicKeyStructure;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x9.X962NamedCurves;
import kz.gov.pki.kalkan.asn1.x9.X962Parameters;
import kz.gov.pki.kalkan.asn1.x9.X9ECParameters;
import kz.gov.pki.kalkan.asn1.x9.X9ECPoint;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.params.AsymmetricKeyParameter;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.crypto.params.RSAKeyParameters;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKeyStructure pubKey = new RSAPublicKeyStructure((ASN1Sequence)keyInfo.getPublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            DERBitString bits = keyInfo.getPublicKeyData();
            byte[] data = bits.getBytes();
            DEROctetString key = new DEROctetString(data);
            X9ECPoint derQ = new X9ECPoint(dParams.getCurve(), key);
            return new ECPublicKeyParameters(derQ.getPoint(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

