/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kz.gov.pki.kalkan.jce.provider.JCEKalkanECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JDKKalkanRSAPrivateKey;
import kz.gov.pki.kalkan.jce.provider.X509CertificateObject;
import kz.gov.pki.kalkan.jce.spec.ECKalkanPrivateKeySpec;
import kz.gov.pki.kalkan.jce.spec.KalkanRSAPrivateKeySpec;
import kz.gov.pki.kalkan.util.BigIntegers;
import kz.gov.pki.kalkan.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKKalkanFileKeyStore
extends KeyStoreSpi {
    private static final byte PRIVATEKEYBLOB = 7;
    private static final byte BLOBHEADERSIZE = 8;
    private Hashtable<String, StoreEntry> entries = new Hashtable();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        Key key = entry == null ? null : entry.privKey;
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        Certificate[] certs = entry == null ? null : entry.certChain;
        return certs;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        Certificate cert = entry == null ? null : entry.cert;
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        Date creationDate = entry == null ? null : entry.date;
        return creationDate;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key == null || chain == null) {
            throw new KeyStoreException("Invalid arguments");
        }
        try {
            StoreEntry entry = this.entries.get(alias.toUpperCase());
            boolean newEntry = false;
            if (entry == null) {
                newEntry = true;
                entry = new StoreEntry();
                entry.alias = alias.toUpperCase();
            }
            entry.cert = chain[0];
            entry.certChain = chain;
            entry.privKey = key;
            entry.date = ((X509CertificateObject)entry.cert).getNotBefore();
            if (newEntry) {
                this.entries.put(alias.toUpperCase(), entry);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e.getMessage());
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        boolean newEntry = false;
        if (entry == null) {
            newEntry = true;
            entry = new StoreEntry();
            entry.alias = alias.toUpperCase();
        }
        entry.cert = cert;
        entry.date = ((X509CertificateObject)entry.cert).getNotBefore();
        if (newEntry) {
            this.entries.put(alias.toUpperCase(), entry);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.entries.remove(alias.toUpperCase());
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.get(alias.toUpperCase()) == null;
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        if (entry == null) {
            return false;
        }
        return entry.privKey != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        StoreEntry entry = this.entries.get(alias.toUpperCase());
        if (entry == null) {
            return false;
        }
        return entry.privKey == null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration<StoreEntry> ent = this.entries.elements();
        while (ent.hasMoreElements()) {
            StoreEntry entry = ent.nextElement();
            if (!entry.cert.equals(cert)) continue;
            return entry.alias.toUpperCase();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        byte[] streamData = Streams.readAll(stream);
        String storePath = new String(streamData);
        File dir = new File(storePath);
        if (!dir.exists()) {
            throw new IOException("Specified directory not found");
        }
        this.entries.clear();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            StoreEntry entry = null;
            try {
                entry = this.readEntry(storePath, files[i].getName());
            }
            catch (NoSuchProviderException e) {
                throw new CertificateException(e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                throw new CertificateException(e.getMessage());
            }
            if (entry.cert == null && (entry.privKey == null || entry.cert == null || entry.certChain == null)) continue;
            this.entries.put(entry.alias.toUpperCase(), entry);
        }
    }

    private StoreEntry readEntry(String path, String alias) throws FileNotFoundException, IOException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        StoreEntry entry = new StoreEntry();
        entry.alias = alias.toUpperCase();
        entry.cert = JDKKalkanFileKeyStore.getCertificateFromFile(path, alias);
        entry.certChain = JDKKalkanFileKeyStore.getCertificateChainFromFile(path, alias);
        entry.privKey = JDKKalkanFileKeyStore.getPrivateKeyFromFile(path, alias, entry.cert);
        if (entry.cert != null) {
            entry.date = ((X509CertificateObject)entry.cert).getNotBefore();
        }
        return entry;
    }

    private static PrivateKey getPrivateKeyFromFile(String path, String alias, Certificate cert) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        byte[] keyBytes = null;
        try {
            FileInputStream fs = new FileInputStream(path + File.separator + alias + File.separator + alias + ".blob");
            keyBytes = Streams.readAll(fs);
            fs.close();
        }
        catch (FileNotFoundException e) {
            e.toString();
            return null;
        }
        catch (IOException e) {
            e.toString();
            return null;
        }
        PrivateKey key = null;
        String alg = ((X509CertificateObject)cert).getPublicKey().getAlgorithm();
        if (alg.compareTo("ECGOST3410") == 0) {
            ECKalkanPrivateKeySpec keySpec = new ECKalkanPrivateKeySpec(keyBytes);
            key = new JCEKalkanECPrivateKey(keySpec);
        } else if (alg.compareTo("RSA") == 0) {
            KalkanRSAPrivateKeySpec keySpec = new KalkanRSAPrivateKeySpec(keyBytes);
            key = new JDKKalkanRSAPrivateKey(keySpec);
        } else {
            throw new NoSuchAlgorithmException("Unsupported algorithm");
        }
        return key;
    }

    private static Certificate getCertificateFromFile(String path, String alias) throws CertificateException, NoSuchProviderException {
        return JDKKalkanFileKeyStore.getCertificateFromFile(path + File.separator + alias + File.separator + "MY" + File.separator + alias + ".cer");
    }

    private static Certificate getCertificateFromFile(String fullCertName) throws CertificateException, NoSuchProviderException {
        Certificate cert = null;
        try {
            FileInputStream fs = new FileInputStream(fullCertName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "KALKAN");
            cert = cf.generateCertificate(fs);
            fs.close();
        }
        catch (FileNotFoundException e) {
            e.toString();
            return null;
        }
        catch (IOException e) {
            e.toString();
            return null;
        }
        return cert;
    }

    private static Certificate[] getCertificateChainFromFile(String path, String alias) throws CertificateException, NoSuchProviderException {
        Vector<Certificate> certs = new Vector<Certificate>();
        Certificate userCert = JDKKalkanFileKeyStore.getCertificateFromFile(path, alias);
        if (userCert == null) {
            return null;
        }
        certs.add(userCert);
        JDKKalkanFileKeyStore.addIssuerCertToChain(path, userCert, certs);
        Certificate[] certsArray = new Certificate[certs.size()];
        for (int i = 0; i < certs.size(); ++i) {
            certsArray[i] = certs.elementAt(i);
        }
        return certsArray;
    }

    private static void addIssuerCertToChain(String path, Certificate cert, Vector<Certificate> chain) throws CertificateException, NoSuchProviderException {
        Principal issuerDn = ((X509CertificateObject)cert).getIssuerDN();
        File dir = new File(path);
        if (!dir.exists()) {
            throw new CertificateException("Specified directory not found");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || files[i].getName().indexOf(".cer") != files[i].getName().length() - 4) continue;
            try {
                Certificate tmpCert = JDKKalkanFileKeyStore.getCertificateFromFile(files[i].getPath());
                Principal dn = ((X509CertificateObject)tmpCert).getSubjectDN();
                if (!issuerDn.equals(dn)) continue;
                chain.add(tmpCert);
                if (dn.equals(((X509CertificateObject)tmpCert).getIssuerDN())) break;
                JDKKalkanFileKeyStore.addIssuerCertToChain(path, tmpCert, chain);
                break;
            }
            catch (CertificateException e) {
                e.toString();
            }
        }
    }

    private static RSAPrivateCrtKeySpec getRSAPrivateKeySpecFromBytes(byte[] bytes) throws InvalidKeySpecException, IOException {
        int offset = 0;
        if (bytes[offset] != 7) {
            throw new InvalidKeySpecException("Data is not a private key");
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes, offset += 12, bytes.length - offset);
        BigInteger bigBitLen = BigIntegers.getFromByteStream(bs, 4, true);
        int bitLen = bigBitLen.intValue();
        offset = 4;
        int len = 4;
        BigInteger publicExponent = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 8;
        BigInteger modulus = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 16;
        BigInteger primeP = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 16;
        BigInteger primeQ = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 16;
        BigInteger exponentP = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 16;
        BigInteger exponentQ = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 16;
        BigInteger coefficient = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        len = bitLen / 8;
        BigInteger privateExponent = BigIntegers.getFromByteStream(bs, len, true);
        offset += len;
        bs.close();
        return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, exponentP, exponentQ, coefficient);
    }

    private class StoreEntry {
        public String alias = "";
        public Date date = new Date();
        public Certificate[] certChain = null;
        public Certificate cert = null;
        public Key privKey = null;

        private StoreEntry() {
        }
    }
}

