/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.asn1.nist.NISTNamedCurves;
import kz.gov.pki.kalkan.asn1.sec.SECNamedCurves;
import kz.gov.pki.kalkan.asn1.teletrust.TeleTrusTNamedCurves;
import kz.gov.pki.kalkan.asn1.x9.X962NamedCurves;
import kz.gov.pki.kalkan.asn1.x9.X9ECParameters;
import kz.gov.pki.kalkan.crypto.AsymmetricCipherKeyPair;
import kz.gov.pki.kalkan.crypto.generators.ECKeyPairGenerator;
import kz.gov.pki.kalkan.crypto.generators.GOST3410KeyPairGenerator;
import kz.gov.pki.kalkan.crypto.generators.RSAKeyPairGenerator;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECKeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.ECPrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.crypto.params.GOST3410KeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.GOST3410Parameters;
import kz.gov.pki.kalkan.crypto.params.GOST3410PrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.GOST3410PublicKeyParameters;
import kz.gov.pki.kalkan.crypto.params.RSAKeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.RSAKeyParameters;
import kz.gov.pki.kalkan.crypto.params.RSAPrivateCrtKeyParameters;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.jce.provider.JCEECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCEECPublicKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPrivateCrtKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPublicKey;
import kz.gov.pki.kalkan.jce.provider.JDKGOST3410PrivateKey;
import kz.gov.pki.kalkan.jce.provider.JDKGOST3410PublicKey;
import kz.gov.pki.kalkan.jce.provider.ProviderUtil;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.EC5Util;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveSpec;
import kz.gov.pki.kalkan.jce.spec.GOST3410ParameterSpec;
import kz.gov.pki.kalkan.jce.spec.GOST3410PublicKeyParameterSetSpec;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECPoint;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKPublicKeyUtil;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.generators.AKAlgorithmParameterSpec;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();

    public static class ECGOST34310
    extends EC {
        public ECGOST34310() {
            super("ECGOST34310");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class EC
    extends JDKKeyPairGenerator {
        ECKeyGenerationParameters param;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 256;
        boolean initialised = false;
        String algorithm;
        private static Map<Integer, ECGenParameterSpec> ecParameters = new HashMap<Integer, ECGenParameterSpec>();
        private AKAlgorithmParameterSpec tokenSpec;

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String algorithm) {
            super(algorithm);
            this.algorithm = algorithm;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = ecParameters.get(strength);
            if (this.ecParams != null) {
                try {
                    this.initialize((ECGenParameterSpec)this.ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            }
            try {
                this.initialize(null, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof kz.gov.pki.kalkan.jce.spec.ECParameterSpec) {
                kz.gov.pki.kalkan.jce.spec.ECParameterSpec p = (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec) {
                Object ecP;
                if (this.algorithm.equals("ECGOST34310")) {
                    ecP = ECGOST3410NamedCurves.getByName(((ECGenParameterSpec)params).getName());
                    if (ecP == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)params).getName());
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)params).getName(), ((ECDomainParameters)ecP).getCurve(), ((ECDomainParameters)ecP).getG(), ((ECDomainParameters)ecP).getN(), ((ECDomainParameters)ecP).getH(), ((ECDomainParameters)ecP).getSeed());
                } else {
                    ecP = X962NamedCurves.getByName(((ECGenParameterSpec)params).getName());
                    if (ecP == null) {
                        ecP = SECNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        if (ecP == null) {
                            ecP = NISTNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        }
                        if (ecP == null) {
                            ecP = TeleTrusTNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        }
                        if (ecP == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)params).getName());
                        }
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)params).getName(), ((X9ECParameters)ecP).getCurve(), ((X9ECParameters)ecP).getG(), ((X9ECParameters)ecP).getN(), ((X9ECParameters)ecP).getH(), ((X9ECParameters)ecP).getSeed());
                }
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && ProviderUtil.getEcImplicitlyCa() != null) {
                kz.gov.pki.kalkan.jce.spec.ECParameterSpec p = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && ProviderUtil.getEcImplicitlyCa() == null) {
                ECDomainParameters ecP = ECGOST3410NamedCurves.getByName("GostR34310_2004");
                if (ecP == null) {
                    throw new InvalidAlgorithmParameterException("unknown curve name GostR34310_2004");
                }
                ECNamedCurveSpec localEcParams = new ECNamedCurveSpec("GostR34310_2004", ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                this.ecParams = null;
                ECParameterSpec p = localEcParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof AKAlgorithmParameterSpec) {
                this.tokenSpec = (AKAlgorithmParameterSpec)params;
            } else {
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            AlgorithmParameterSpec p;
            if (this.tokenSpec != null) {
                AKGOST34310PrivateKey privateKey = null;
                PublicKey publicKey = null;
                try {
                    AKToken token = TokenDispatcher.INSTANCE.instantiateToken(this.tokenSpec.getSmartcard(), this.tokenSpec.getPassword());
                    byte keyId = token.generateKeyPair("GOST", this.tokenSpec.getAlias(), false, 0);
                    privateKey = new AKGOST34310PrivateKey(token, keyId);
                    publicKey = AKPublicKeyUtil.generatePublic("GOST", token.getPublicKey("GOST", keyId));
                }
                catch (KalkanException e) {
                    throw new IllegalStateException(this.tokenSpec.getSmartcard().getTerminalName() + " Key Pair Generator failed");
                }
                return new KeyPair(publicKey, privateKey);
            }
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            ECPublicKeyParameters pub = null;
            ECPrivateKeyParameters priv = null;
            boolean isCorrectPublic = false;
            while (!isCorrectPublic) {
                AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
                pub = (ECPublicKeyParameters)pair.getPublic();
                priv = (ECPrivateKeyParameters)pair.getPrivate();
                byte[] y = pub.getQ().getY().toBigInteger().toByteArray();
                byte[] x = pub.getQ().getX().toBigInteger().toByteArray();
                if (x.length < 32 || y.length < 32) {
                    System.err.println("we want longer value!");
                    continue;
                }
                if (x.length == 32 && x[0] == 0 || y.length == 32 && y[0] == 0) {
                    System.err.println("first byte is 0!");
                    continue;
                }
                if (x[x.length - 1] == 0 || y[y.length - 1] == 0) {
                    System.err.println("last byte is 0!");
                    continue;
                }
                isCorrectPublic = true;
            }
            if (this.ecParams instanceof kz.gov.pki.kalkan.jce.spec.ECParameterSpec) {
                p = (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)this.ecParams;
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub, (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)p), new JCEECPrivateKey(this.algorithm, priv, null, (kz.gov.pki.kalkan.jce.spec.ECParameterSpec)p));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub), new JCEECPrivateKey(this.algorithm, priv));
            }
            p = (ECParameterSpec)this.ecParams;
            return new KeyPair(new JCEECPublicKey(this.algorithm, pub, (ECParameterSpec)p), new JCEECPrivateKey(this.algorithm, priv, null, (ECParameterSpec)p));
        }

        static {
            ecParameters.put(256, new ECGenParameterSpec("Gost34310-2004-PKIGOVKZ-A"));
        }
    }

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            GOST3410PublicKeyParameterSetSpec spec = gParams.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(random, new GOST3410Parameters(spec.getP(), spec.getQ(), spec.getA()));
            this.engine.init(this.param);
            this.initialised = true;
            this.gost3410Params = gParams;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)params, random);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters pub = (GOST3410PublicKeyParameters)pair.getPublic();
            GOST3410PrivateKeyParameters priv = (GOST3410PrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(pub, this.gost3410Params), new JDKGOST3410PrivateKey(priv, this.gost3410Params));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();
        private AKAlgorithmParameterSpec tokenSpec = null;

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        public void initialize(int strength, SecureRandom random) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 12);
            this.engine.init(this.param);
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof AKAlgorithmParameterSpec) {
                this.tokenSpec = (AKAlgorithmParameterSpec)params;
            } else {
                if (!(params instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
                }
                RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
                this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 12);
                this.engine.init(this.param);
            }
        }

        public KeyPair generateKeyPair() {
            if (this.tokenSpec == null) {
                AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
                RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
                RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
                return new KeyPair(new JCERSAPublicKey(pub), new JCERSAPrivateCrtKey(priv));
            }
            AKRSAPrivateKey privateKey = null;
            PublicKey publicKey = null;
            try {
                AKToken token = TokenDispatcher.INSTANCE.instantiateToken(this.tokenSpec.getSmartcard(), this.tokenSpec.getPassword());
                byte keyId = token.generateKeyPair("RSA", this.tokenSpec.getAlias(), this.tokenSpec.isXch(), this.tokenSpec.getKeyLength());
                privateKey = new AKRSAPrivateKey(token, keyId);
                publicKey = AKPublicKeyUtil.generatePublic("RSA", token.getPublicKey("RSA", keyId));
            }
            catch (KalkanException e) {
                throw new IllegalStateException(this.tokenSpec.getSmartcard().getTerminalName() + " Key Pair Generator failed", e);
            }
            return new KeyPair(publicKey, privateKey);
        }
    }
}

