/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.dsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.oiw.OIWObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.params.AsymmetricKeyParameter;
import kz.gov.pki.kalkan.crypto.params.DSAParameters;
import kz.gov.pki.kalkan.crypto.params.DSAPrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.DSAPublicKeyParameters;

public class DSAUtil {
    public static final DERObjectIdentifier[] dsaOids = new DERObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};

    public static boolean isDsaOid(DERObjectIdentifier algOid) {
        for (int i = 0; i != dsaOids.length; ++i) {
            if (!algOid.equals(dsaOids[i])) continue;
            return true;
        }
        return false;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof DSAPublicKey) {
            DSAPublicKey k = (DSAPublicKey)key;
            return new DSAPublicKeyParameters(k.getY(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey k = (DSAPrivateKey)key;
            return new DSAPrivateKeyParameters(k.getX(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA private key.");
    }
}

