/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.asn1.nist.NISTNamedCurves;
import kz.gov.pki.kalkan.asn1.sec.SECNamedCurves;
import kz.gov.pki.kalkan.asn1.teletrust.TeleTrusTNamedCurves;
import kz.gov.pki.kalkan.asn1.x9.X962NamedCurves;
import kz.gov.pki.kalkan.asn1.x9.X9ECParameters;
import kz.gov.pki.kalkan.crypto.params.AsymmetricKeyParameter;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECPrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.jce.interfaces.ECPrivateKey;
import kz.gov.pki.kalkan.jce.interfaces.ECPublicKey;
import kz.gov.pki.kalkan.jce.provider.JCEECPublicKey;
import kz.gov.pki.kalkan.jce.provider.ProviderUtil;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.EC5Util;
import kz.gov.pki.kalkan.jce.spec.ECParameterSpec;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECFieldElement;
import kz.gov.pki.kalkan.math.ec.ECPoint;

public class ECUtil {
    static int[] convertMidTerms(int[] k) {
        int[] res = new int[3];
        if (k.length == 1) {
            res[0] = k[0];
        } else {
            if (k.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (k[0] < k[1] && k[0] < k[2]) {
                res[0] = k[0];
                if (k[1] < k[2]) {
                    res[1] = k[1];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[1];
                }
            } else if (k[1] < k[2]) {
                res[0] = k[1];
                if (k[0] < k[2]) {
                    res[1] = k[0];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[0];
                }
            } else {
                res[0] = k[2];
                if (k[0] < k[1]) {
                    res[1] = k[0];
                    res[2] = k[1];
                } else {
                    res[1] = k[1];
                    res[2] = k[0];
                }
            }
        }
        return res;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            ECParameterSpec s = k.getParameters();
            if (s == null) {
                s = ProviderUtil.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((JCEECPublicKey)k).engineGetQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
            }
            return new ECPublicKeyParameters(k.getQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        if (key instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey pubKey = (java.security.interfaces.ECPublicKey)key;
            ECParameterSpec s = EC5Util.convertSpec(pubKey.getParams(), false);
            return new ECPublicKeyParameters(EC5Util.convertPoint(pubKey.getParams(), pubKey.getW(), false), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        throw new InvalidKeyException("cannot identify EC public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            ECParameterSpec s = k.getParameters();
            if (s == null && (s = ProviderUtil.getEcImplicitlyCa()) == null) {
                BigInteger gtParam1 = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
                BigInteger gtParam2 = new BigInteger("115792089237316195423570985008687907853073762908499243225378155805079068850323");
                ECCurve.Fp localFp = new ECCurve.Fp(gtParam1, new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316"), new BigInteger("166"));
                s = new ECParameterSpec(localFp, new ECPoint.Fp(localFp, new ECFieldElement.Fp(localFp.getQ(), new BigInteger("1")), new ECFieldElement.Fp(localFp.getQ(), new BigInteger("64033881142927202683649881450433473985931760268884941288852745803908878638612"))), gtParam2);
            }
            return new ECPrivateKeyParameters(k.getD(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        throw new InvalidKeyException("can't identify EC private key.");
    }

    public static DERObjectIdentifier getNamedCurveOid(String name) {
        DERObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
            if (oid == null) {
                oid = NISTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = TeleTrusTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = ECGOST3410NamedCurves.getOID(name);
            }
        }
        return oid;
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier oid) {
        X9ECParameters params = X962NamedCurves.getByOID(oid);
        if (params == null) {
            params = SECNamedCurves.getByOID(oid);
            if (params == null) {
                params = NISTNamedCurves.getByOID(oid);
            }
            if (params == null) {
                params = TeleTrusTNamedCurves.getByOID(oid);
            }
        }
        return params;
    }

    public static String getCurveName(DERObjectIdentifier oid) {
        String name = X962NamedCurves.getName(oid);
        if (name == null) {
            name = SECNamedCurves.getName(oid);
            if (name == null) {
                name = NISTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = TeleTrusTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = ECGOST3410NamedCurves.getName(oid);
            }
        }
        return name;
    }
}

