/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.DSA;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.GOST3411_2015_256Digest;
import kz.gov.pki.kalkan.crypto.digests.GOST3411_2015_512Digest;
import kz.gov.pki.kalkan.crypto.digests.NullDigest;
import kz.gov.pki.kalkan.crypto.params.ECKeyParameters;
import kz.gov.pki.kalkan.crypto.params.ParametersWithRandom;
import kz.gov.pki.kalkan.crypto.signers.ECGOST3410Signer;
import kz.gov.pki.kalkan.jce.interfaces.ECKey;
import kz.gov.pki.kalkan.jce.interfaces.ECPublicKey;
import kz.gov.pki.kalkan.jce.provider.JDKKeyFactory;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.ECUtil;
import kz.gov.pki.kalkan.pcsc.AKGOST3410_2015PrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.ByteUtils;

public class EcGost2015SignatureSpi
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    protected Digest digest;
    private DSA signer;
    protected SecureRandom random;
    private int size;
    private int halfSize;
    private byte keyId;
    private AKToken token = null;
    private String sigAlg;

    protected EcGost2015SignatureSpi(Digest digest, DSA signer, int size) {
        this.digest = digest;
        this.signer = signer;
        this.size = size;
        this.halfSize = size / 2;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECKeyParameters param;
        if (publicKey instanceof ECPublicKey) {
            param = (ECKeyParameters)ECUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = JDKKeyFactory.createPublicKeyFromDERStream(bytes);
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = (ECKeyParameters)ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        if (this.size == 64) {
            if (param.getParameters().getN().bitLength() > 256) {
                throw new InvalidKeyException("key out of range for ECGOST3410-2015-256");
            }
        } else if (this.size == 128) {
            if (param.getParameters().getN().bitLength() < 505) {
                throw new InvalidKeyException("key too weak for ECGOST3410-2015-512");
            }
        } else {
            throw new InvalidKeyException("unsupported key size");
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.digest.reset();
        if (!(privateKey instanceof ECKey)) {
            AKGOST3410_2015PrivateKey key = (AKGOST3410_2015PrivateKey)privateKey;
            this.keyId = key.getKeyId();
            this.token = key.getToken();
            this.sigAlg = "GOST512";
            return;
        }
        ECKeyParameters param = (ECKeyParameters)ECUtil.generatePrivateKeyParameter(privateKey);
        if (this.size == 64) {
            if (param.getParameters().getN().bitLength() > 256) {
                throw new InvalidKeyException("key out of range for ECGOST3410-2015-256");
            }
        } else if (this.size == 128) {
            if (param.getParameters().getN().bitLength() < 505) {
                throw new InvalidKeyException("key too weak for ECGOST3410-2015-512");
            }
        } else {
            throw new InvalidKeyException("unsupported key size");
        }
        if (this.random != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.random));
        } else {
            this.signer.init(true, param);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            if (this.token == null) {
                byte[] sigBytes = new byte[this.size];
                BigInteger[] sig = this.signer.generateSignature(hash);
                byte[] r = sig[0].toByteArray();
                byte[] s = sig[1].toByteArray();
                if (s[0] != 0) {
                    System.arraycopy(s, 0, sigBytes, this.halfSize - s.length, s.length);
                } else {
                    System.arraycopy(s, 1, sigBytes, this.halfSize - (s.length - 1), s.length - 1);
                }
                if (r[0] != 0) {
                    System.arraycopy(r, 0, sigBytes, this.size - r.length, r.length);
                } else {
                    System.arraycopy(r, 1, sigBytes, this.size - (r.length - 1), r.length - 1);
                }
                return ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
            }
            return this.token.sign(this.sigAlg, hash, this.keyId);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        BigInteger[] sig = null;
        boolean result = false;
        int half = sigBytes.length / 2;
        try {
            byte[] r = new byte[half];
            byte[] s = new byte[half];
            byte[] reversedSigBytes = ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
            System.arraycopy(reversedSigBytes, 0, s, 0, half);
            System.arraycopy(reversedSigBytes, half, r, 0, half);
            sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("error decoding signature bytes.");
        }
        result = this.signer.verifySignature(hash, sig[0], sig[1]);
        return result;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class RawEcGost3410_2015_512
    extends EcGost2015SignatureSpi {
        public RawEcGost3410_2015_512() {
            super(new NullDigest(), new ECGOST3410Signer(), 128);
        }
    }

    public static class EcGost3410_2015_512
    extends EcGost2015SignatureSpi {
        public EcGost3410_2015_512() {
            super(new GOST3411_2015_512Digest(), new ECGOST3410Signer(), 128);
        }
    }

    public static class EcGost3410_2015_256
    extends EcGost2015SignatureSpi {
        public EcGost3410_2015_256() {
            super(new GOST3411_2015_256Digest(), new ECGOST3410Signer(), 64);
        }
    }
}

