/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cms.CMSAttributes;
import kz.gov.pki.kalkan.asn1.cms.Time;
import kz.gov.pki.kalkan.jce.provider.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = (Hashtable)this.table.clone();
        if (this.table.containsKey(CMSAttributes.contentType)) {
            std.put(CMSAttributes.contentType, this.table.get(CMSAttributes.contentType));
        } else {
            attr = new Attribute(CMSAttributes.contentType, new DERSet((DERObjectIdentifier)parameters.get("contentType")));
            std.put(attr.getAttrType(), attr);
        }
        if (this.table.containsKey(CMSAttributes.signingTime)) {
            std.put(CMSAttributes.signingTime, this.table.get(CMSAttributes.signingTime));
        } else {
            attr = new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date())));
            std.put(attr.getAttrType(), attr);
        }
        if (this.table.containsKey(CMSAttributes.messageDigest)) {
            std.put(CMSAttributes.messageDigest, this.table.get(CMSAttributes.messageDigest));
        } else {
            byte[] hash = (byte[])parameters.get("digest");
            Attribute attr2 = hash != null ? new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))) : new Attribute(CMSAttributes.messageDigest, new DERSet(new DERNull()));
            std.put(attr2.getAttrType(), attr2);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

