/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cms.PasswordRecipientInfo;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.provider.cms.CMSEnvelopedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSPBEKey;
import kz.gov.pki.kalkan.jce.provider.cms.CMSTypedStream;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientId;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientInformation;

public class PasswordRecipientInformation
extends RecipientInformation {
    private PasswordRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public PasswordRecipientInformation(PasswordRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data) {
        super(encAlg, AlgorithmIdentifier.getInstance(info.getKeyEncryptionAlgorithm()), data);
        this._info = info;
        this._encAlg = encAlg;
        this._rid = new RecipientId();
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        try {
            AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance(this._info.getKeyEncryptionAlgorithm());
            ASN1Sequence kekAlgParams = (ASN1Sequence)kekAlg.getParameters();
            byte[] encryptedKey = this._info.getEncryptedKey().getOctets();
            String kekAlgName = DERObjectIdentifier.getInstance(kekAlgParams.getObjectAt(0)).getId();
            Cipher keyCipher = Cipher.getInstance(CMSEnvelopedHelper.INSTANCE.getRFC3211WrapperName(kekAlgName), prov);
            IvParameterSpec ivSpec = new IvParameterSpec(ASN1OctetString.getInstance(kekAlgParams.getObjectAt(1)).getOctets());
            keyCipher.init(4, (Key)new SecretKeySpec(((CMSPBEKey)key).getEncoded(kekAlgName), kekAlgName), ivSpec);
            AlgorithmIdentifier aid = this._encAlg;
            String alg = aid.getObjectId().getId();
            Key sKey = keyCipher.unwrap(encryptedKey, alg, 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("invalid iv.", e);
        }
    }
}

