/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.pcsc.Smartcard;
import kz.gov.pki.kalkan.util.encoders.Hex;
import lombok.NonNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCSCUtils {
    private static final Map<String, String> ATR_TO_STORAGE = new HashMap<String, String>();

    private static List<Smartcard> loadSlotList(String storageName) {
        ArrayList<Smartcard> smartcards = new ArrayList<Smartcard>();
        try {
            PCSCUtils.establishNewContext();
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> lReaders = factory.terminals().list();
            for (CardTerminal terminal : lReaders) {
                Card card;
                String tName = terminal.getName();
                System.out.println(tName + " is present: " + terminal.isCardPresent());
                if (!terminal.isCardPresent()) continue;
                try {
                    card = terminal.connect("T=0");
                }
                catch (CardException ce) {
                    card = terminal.connect("T=1");
                }
                byte[] atrBytes = card.getATR().getBytes();
                String atrString = Hex.encodeStr(atrBytes);
                System.out.println(card.getProtocol() + ", ATR: " + atrString);
                String storage = ATR_TO_STORAGE.get(atrString);
                if (storage != null) {
                    Smartcard smartcard = new Smartcard(storage, tName);
                    if (storageName != null) {
                        if (storageName.equals(storage)) {
                            smartcards.add(smartcard);
                        }
                    } else {
                        smartcards.add(smartcard);
                    }
                }
                card.disconnect(false);
            }
        }
        catch (Exception e) {
            System.err.println("Could not load slot list.\n\t" + e);
        }
        return smartcards;
    }

    public static List<Smartcard> loadSlotListByStorage(@NonNull String storageName) {
        if (storageName == null) {
            throw new NullPointerException("storageName is marked non-null but is null");
        }
        return PCSCUtils.loadSlotList(storageName);
    }

    public static List<Smartcard> loadSlotList() {
        return PCSCUtils.loadSlotList(null);
    }

    public static void establishNewContext() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("windows")) {
            try {
                Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
                Field contextId = pcscterminal.getDeclaredField("contextId");
                contextId.setAccessible(true);
                if (contextId.getLong(pcscterminal) != 0L) {
                    Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                    Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                    SCardEstablishContext.setAccessible(true);
                    Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                    SCARD_SCOPE_USER.setAccessible(true);
                    long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
                    contextId.setLong(pcscterminal, newId);
                    TerminalFactory factory = TerminalFactory.getDefault();
                    CardTerminals terminals = factory.terminals();
                    Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
                    fieldTerminals.setAccessible(true);
                    Class<?> classMap = Class.forName("java.util.Map");
                    Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
                    clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
                    Field fieldStateMap = pcscterminal.getDeclaredField("stateMap");
                    fieldStateMap.setAccessible(true);
                    Object fieldStateMapObj = fieldStateMap.get(terminals);
                    if (fieldStateMapObj != null) {
                        clearMap.invoke(fieldStateMapObj, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Could not establish new context.\n\t" + e);
            }
        }
    }

    static {
        ATR_TO_STORAGE.put("3b771800004b4153414b4944", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3b391900534f4d414453333031", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3b391900534f4d414453333033", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3b3e9500534f4d412d633030372d44533161", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3b3e9500534f4d412d633030372d44533162", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3bfa130000900131fe450031807394410000900075", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3bfa1800ff8031fe450031807394410000900090", Storage.KZIDCARD.getName());
        ATR_TO_STORAGE.put("3b88014b415a544f4b454e82", Storage.KAZTOKEN.getName());
        ATR_TO_STORAGE.put("3b9896004b415a544f4b454e", Storage.KAZTOKEN.getName());
        ATR_TO_STORAGE.put("3bd518008131fe7d8073c82110f4", Storage.ETOKEN_72K.getName());
        ATR_TO_STORAGE.put("3bdc18ff8191fe1fc38073c821136601061159000128", Storage.JACARTA.getName());
        ATR_TO_STORAGE.put("3bfc180000813180459067464a00643170c172fee0e2", Storage.AKEY.getName());
        ATR_TO_STORAGE.put("3bfc180000813180459067464a01037206000000001c", Storage.AKEY.getName());
        ATR_TO_STORAGE.put("3bfc180000813180459067464a010359040000000035", Storage.AKEY.getName());
        ATR_TO_STORAGE.put("3b9095801f0399", Storage.AKEY.getName());
        ATR_TO_STORAGE.put("3bd5180081313a7d8073c8211030", Storage.ETOKEN_5110.getName());
        ATR_TO_STORAGE.put("3b7f96000080318065b0844150f6120ffe829000", Storage.ETOKEN_5110.getName());
    }
}

