/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.AKGOST3410_2015PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AKey
extends AKToken {
    private static final byte INS_CREATE_HOST_SESSION = 3;
    private static final byte INS_CLOSE_HOST_SESSION = 6;
    private static final byte INS_LOGIN = 7;
    private static final byte INS_GET_INFO = 10;
    private static final byte INS_GET_RANDOM = 12;
    private static final byte INS_CREATE_OBJECT = 13;
    private static final byte INS_DELETE_OBJECT = 14;
    private static final byte INS_GET_OBJECT_VALUE = 15;
    private static final byte INS_GET_OBJECTS_DESCR = 16;
    private static final byte INS_GENERATE_KEY_PAIR = 17;
    private static final byte INS_GENERATE_SIGN = 18;
    private static final byte INS_REWRITE_OBJECT = 20;
    private static final byte INS_CHANGEPIN = 9;
    private static final short ENTRY_OBJECT = 1;
    private static final short ENTRY_PUBLIC_KEY = 2;
    private static final short ENTRY_PRIVATE_KEY = 3;
    private int allLogonTries;
    private int logonTries;
    private Map<String, Byte> aliasToNcaIdMap = new LinkedHashMap<String, Byte>();
    private Map<Byte, Short> priKeysIds = new HashMap<Byte, Short>();
    private Map<Byte, Short> pubKeysIds = new HashMap<Byte, Short>();
    private Map<Byte, Short> certsIds = new HashMap<Byte, Short>();
    private Map<Byte, String> priKeyAlg = new HashMap<Byte, String>();
    private static final short ACL_GUEST_READ = 1;
    private static final short ACL_GUEST_WRITE = 2;
    private static final short ACL_GUEST_COPY = 4;
    private static final short ACL_GUEST_DELETE = 8;
    private static final short ACL_GUEST_ALL = 15;
    private static final short ACL_USER_READ = 16;
    private static final short ACL_USER_WRITE = 32;
    private static final short ACL_USER_COPY = 64;
    private static final short ACL_USER_DELETE = 128;
    private static final short ACL_USER_ALL = 240;
    private static final short ACL_OF_PUBLIC_KEY = 255;
    private static final short ACL_OF_PRIVATE_KEY = 240;
    private static final byte ALG_RSA = 0;
    private static final byte ALG_ECGOST_32 = 1;
    private static final byte ALG_ECGOST_64 = 2;
    private boolean sessionOpened = false;
    private static byte[] FT_DP_34102012_32_A = new byte[]{0, 0, 0, 8, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -115, -111, -28, 113, -32, -104, -100, -38, 39, -33, 80, 90, 69, 63, 43, 118, 53, 41, 79, 45, -33, 35, -29, -79, 34, -84, -55, -100, -98, -97, 30, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, 97, 16, 112, -103, 90, -47, 0, 69, -124, 27, 9, -73, 97, -72, -109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, -49, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -109, -98, -17, -113, 102, -91, 46, -1, -70, 123, -28, -10, 72, -98, 71, 109, 0, 0, 69, 17, 121, -37, -9, 72, -123, -48, -118, 55, 20, -57, 44, 30, 36, -68, -124, -6, -97, 16, -15, 104, -107, 15, -78, 11, -76, -82, 123, -73, -40, 111};
    private static byte[] FT_DP_34102012_64_A = new byte[]{0, 0, 0, 16, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -60, -24, -62, 80, 93, -19, -4, -122, -35, -63, -67, 11, 43, 102, 103, -15, -38, 52, -72, 37, 116, 118, 28, -80, -24, 121, -67, 8, 28, -3, 11, 98, 101, -18, 60, -80, -112, -13, 13, 39, 97, 76, -76, 87, 64, 16, -38, -112, -35, -122, 46, -7, -44, -21, -18, 71, 97, 80, 49, -112, 120, 90, 113, -57, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 117, 3, -49, -24, 122, -125, 106, -29, -90, 27, -120, 22, -30, 84, 80, -26, -50, 94, 28, -109, -84, -15, -85, -63, 119, -128, 100, -3, -53, -17, -87, 33, -33, 22, 38, -66, 79, -48, 54, -23, 61, 117, -26, -91, 14, 58, 65, -23, -128, 40, -2, 95, -62, 53, -11, -72, -119, -91, -119, -53, 82, 21, -14, -92, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39, -26, -107, 50, -12, -115, -119, 17, 111, -14, 43, -115, 78, 5, 96, 96, -101, 75, 56, -85, -6, -46, -72, 93, -54, -51, -79, 65, 31, 16, -78, 117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, -16, -79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -40, 25, 106, -51, 11, 114, 118, -18, -112, 13, -44, 114, -79, -6, -97, -97, 100, -76, -57, 84, 5, 45, 71, -94, 53, 50, 78, -66, -32, -17, 77, -117, 0, 0, 11, -21, -42, -61, -18, 2, -117, -7, -40, -19, 51, 20, -70, -72, -66, 93, -41, -79, 101, 29, -57, 67, 53, 121, -29, -126, -107, 112, 58, 103, -59, -33, -94, -11, 108, -118, -58, -107, -114, 67, -29, 18, -4, -11, -58, 85, -9, -50, 55, -50, 98, 61, -33, -76, -75, -4, -120, 116, -70, -17, -96, -77, 10, 64};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AKey(String tName, String pin) throws KalkanException {
        super(tName, pin);
        this.connect();
        try {
            byte[] aid = new byte[]{119, 17, -63, 50, 9, 0, 0, 0};
            CommandAPDU req = new CommandAPDU(0, 164, 4, 0, aid);
            ResponseAPDU resp = this.ch.transmit(req);
            if (resp.getSW() != 36864) {
                throw new KalkanException(PCSCCode.NOT_AKEY);
            }
            this.createSession();
            try {
                this.getTokenInfo();
                if (pin != null) {
                    this.auth(pin);
                }
                this.readNcaObjects();
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    @Override
    public void disconnect() {
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void verifyPin(String pin) throws KalkanException {
        try {
            this.createSession();
            try {
                this.auth(pin);
                this.readNcaObjects();
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPublicKey(String algName, byte keyId) throws KalkanException {
        try {
            this.createSessionAndLogin();
            try {
                Short objId = this.pubKeysIds.get(keyId);
                if (objId == null) {
                    throw new KalkanException(PCSCCode.INVALID_PUBKEY);
                }
                byte[] data = this.readObjectValue(objId);
                if (algName.equals("RSA")) {
                    byte[] modulus = new byte[256];
                    System.arraycopy(data, 258, modulus, 0, modulus.length);
                    byte[] byArray = modulus;
                    return byArray;
                }
                if (data.length > 400) {
                    byte[] x = new byte[64];
                    byte[] y = new byte[64];
                    System.arraycopy(data, FT_DP_34102012_64_A.length, x, 0, 64);
                    System.arraycopy(data, FT_DP_34102012_64_A.length + 64, y, 0, 64);
                    kz.gov.pki.kalkan.util.Arrays.reverse(x);
                    kz.gov.pki.kalkan.util.Arrays.reverse(y);
                    byte[] encKey = new byte[128];
                    System.arraycopy(x, 0, encKey, 0, 64);
                    System.arraycopy(y, 0, encKey, 64, 32);
                    System.arraycopy(y, 0, encKey, 64, 64);
                    byte[] byArray = encKey;
                    return byArray;
                }
                byte[] x = new byte[32];
                byte[] y = new byte[32];
                System.arraycopy(data, FT_DP_34102012_32_A.length, x, 0, 32);
                System.arraycopy(data, FT_DP_34102012_32_A.length + 32, y, 0, 32);
                kz.gov.pki.kalkan.util.Arrays.reverse(x);
                kz.gov.pki.kalkan.util.Arrays.reverse(y);
                byte[] encKey = new byte[64];
                System.arraycopy(x, 0, encKey, 0, 32);
                System.arraycopy(y, 0, encKey, 32, 32);
                byte[] byArray = encKey;
                return byArray;
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sign(String algName, byte[] data, byte keyId) throws KalkanException {
        byte[] ret;
        block8: {
            ret = null;
            try {
                try {
                    this.createSessionAndLogin();
                    if (algName.equals("GOST512")) {
                        ret = this.signGOST(data, keyId);
                        break block8;
                    }
                    if (algName.equals("RSA")) {
                        ret = this.signRSA(data, keyId);
                        break block8;
                    }
                    if (algName.equals("GOST")) {
                        ret = this.signGOST(data, keyId);
                        break block8;
                    }
                    throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
                }
                finally {
                    this.closeSession();
                }
            }
            catch (CardException ex) {
                throw new KalkanException(ex, (ErrorCode)PCSCCode.SIGN_FAILURE);
            }
        }
        return ret;
    }

    @Override
    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KalkanException {
        if (algName.equals("GOST512")) {
            return this.generateGost512KeyPair(alias);
        }
        if (algName.equals("GOST")) {
            return this.generateGostKeyPair(alias);
        }
        if (algName.equals("RSA")) {
            return this.generateRsaKeyPair(alias, isXch, keyLength);
        }
        throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCertificate(String alias, byte[] certBytes) throws KalkanException {
        block8: {
            try {
                byte[] certDescr = this.generateObjectDescForCert(alias);
                ByteBuffer cData = ByteBuffer.allocate(6 + certDescr.length + certBytes.length);
                cData.putShort((short)255);
                cData.putShort((short)certDescr.length).putShort((short)certBytes.length);
                cData.put(certDescr);
                cData.put(certBytes);
                byte[] commandData = cData.array();
                this.createSessionAndLogin();
                try {
                    Byte ncaId = this.aliasToNcaIdMap.get(alias);
                    if (ncaId != null && this.certsIds.get(ncaId) != null) {
                        short objId = this.certsIds.get(ncaId);
                        ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 20, objId >> 8 & 0xFF, objId & 0xFF, commandData);
                        if (resp.getSW() == 36864) {
                            this.readNcaObjects();
                            break block8;
                        }
                        throw new KalkanException(PCSCCode.SETCERT_FAILURE).set("SW", resp.getSW());
                    }
                    ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 13, 0, 0, commandData);
                    if (resp.getSW() == 36864) {
                        this.readNcaObjects();
                        break block8;
                    }
                    throw new KalkanException(PCSCCode.SETCERT_FAILURE).set("SW", resp.getSW());
                }
                finally {
                    this.closeSession();
                }
            }
            catch (CardException ce) {
                throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getCertificate(String alias) throws KalkanException {
        byte[] byArray;
        this.createSessionAndLogin();
        try {
            byte[] data;
            Byte ncaId = this.aliasToNcaIdMap.get(alias);
            Short objId = this.certsIds.get(ncaId);
            if (objId == null) {
                throw new KalkanException("no such certificate", (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
            byArray = data = this.readObjectValue(objId);
        }
        catch (Throwable throwable) {
            try {
                this.closeSession();
                throw throwable;
            }
            catch (CardException ce) {
                throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
        this.closeSession();
        return byArray;
    }

    @Override
    public Map<String, Byte> getAliases() throws KalkanException {
        return this.aliasToNcaIdMap;
    }

    @Override
    public PrivateKey getKey(String alias) throws KalkanException {
        Byte ncaId = this.aliasToNcaIdMap.get(alias);
        String alg = this.priKeyAlg.get(ncaId);
        if (alg.equals("GOST512")) {
            return new AKGOST3410_2015PrivateKey(this, ncaId);
        }
        if (alg.equals("GOST")) {
            return new AKGOST34310PrivateKey(this, ncaId);
        }
        if (alg.equals("RSA")) {
            return new AKRSAPrivateKey(this, ncaId);
        }
        throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getRandom(int i) {
        byte[] byArray;
        this.createSessionAndLogin();
        try {
            ResponseAPDU resp;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int left = i; left > 0; left -= resp.getData().length) {
                int toRead = Math.min(250, left);
                resp = this.ch.transmit(new CommandAPDU(128, 12, 0, 0, toRead));
                AKey.checkResponse(resp);
                baos.write(resp.getData());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                this.closeSession();
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        this.closeSession();
        return byArray;
    }

    @Override
    public void deleteEntry(String alias) throws KalkanException {
        try {
            this.createSessionAndLogin();
            try {
                Byte ncaId = this.aliasToNcaIdMap.get(alias);
                if (this.certsIds.containsKey(ncaId)) {
                    this.deleteTokenObject(this.certsIds.get(ncaId));
                }
                if (this.priKeysIds.containsKey(ncaId)) {
                    this.deleteTokenObject(this.priKeysIds.get(ncaId));
                }
                if (this.pubKeysIds.containsKey(ncaId)) {
                    this.deleteTokenObject(this.pubKeysIds.get(ncaId));
                }
            }
            finally {
                this.readNcaObjects();
                this.closeSession();
            }
        }
        catch (CardException ex) {
            throw new KalkanException(ex, (ErrorCode)PCSCCode.DELETE_FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePin(byte type, String new_pin) throws KalkanException {
        int new_pin_length = new_pin.getBytes().length;
        if (new_pin_length > 32 || new_pin_length < 6) {
            throw new KalkanException(PCSCCode.INVALID_PIN_VALUE).set("MaxLength", 32).set("MinLength", 6);
        }
        if (type > 1) {
            throw new KalkanException("unknown type", (ErrorCode)PCSCCode.CHANGEPIN_FAILURE);
        }
        try {
            this.createSessionAndLogin();
            try {
                ByteBuffer bb = ByteBuffer.allocate(2 + this.pin.getBytes().length + 2 + new_pin_length);
                bb.putShort((short)this.pin.getBytes().length);
                bb.put(this.pin.getBytes());
                bb.putShort((short)new_pin_length);
                bb.put(new_pin.getBytes());
                byte[] cmd = bb.array();
                ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 9, (int)type, 0, cmd));
                AKey.checkResponse(resp);
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CHANGEPIN_FAILURE);
        }
    }

    private void createSession() throws KalkanException, CardException {
        if (this.sessionOpened) {
            return;
        }
        ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 3, 0, 0, 5));
        AKey.checkResponse(resp);
        this.sessionOpened = true;
    }

    private static void checkResponse(ResponseAPDU resp) throws KalkanException {
        if (resp.getSW() != 36864) {
            throw new KalkanException(PCSCCode.CARD_EXCEPTION).set("SW", resp.getSW());
        }
    }

    private synchronized void getTokenInfo() throws KalkanException, CardException {
        ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 10, 0, 0, 176));
        AKey.checkResponse(resp);
        byte[] b = resp.getData();
        byte[] model = new byte[16];
        System.arraycopy(b, 0, model, 0, 16);
        byte[] serial = new byte[16];
        System.arraycopy(b, 16, serial, 0, 16);
        byte[] name = new byte[32];
        System.arraycopy(b, 32, name, 0, 32);
        this.tokenId = new String(Hex.encode(serial));
        this.allLogonTries = b[83];
        this.logonTries = b[85];
    }

    protected final void auth(String pin) throws KalkanException {
        try {
            if (pin == null || pin.getBytes().length < 6 || pin.getBytes().length > 32) {
                throw new KalkanException("Pin length not in (6, 32)", (ErrorCode)PCSCCode.WRONG_PIN);
            }
            ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 7, 0, 0, pin.getBytes()));
            if (resp.getSW() != 36864) {
                if (resp.getSW() == 39938) {
                    --this.logonTries;
                    throw new KalkanException(PCSCCode.WRONG_PIN).set("RetryCount", this.logonTries).set("SW", Integer.toHexString(resp.getSW()));
                }
                if (resp.getSW() == 39948) {
                    throw new KalkanException(PCSCCode.BLOCKED_PIN);
                }
                throw new KalkanException(PCSCCode.WRONG_PIN).set("SW", Integer.toHexString(resp.getSW()));
            }
            this.logonTries = this.allLogonTries;
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    private synchronized void readNcaObjects() throws CardException, KalkanException {
        int objectsLeft = -1;
        byte[] rest = new byte[]{};
        ArrayList<AKeyObjectIdentified> objList = new ArrayList<AKeyObjectIdentified>();
        block7: do {
            ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 16, 0, 0, 255));
            AKey.checkResponse(resp);
            byte[] fullBuff = new byte[rest.length + resp.getData().length];
            System.arraycopy(rest, 0, fullBuff, 0, rest.length);
            System.arraycopy(resp.getBytes(), 0, fullBuff, rest.length, resp.getData().length);
            ByteBuffer buff = ByteBuffer.wrap(fullBuff);
            if (objectsLeft == -1) {
                objectsLeft = buff.getShort();
            }
            while (objectsLeft > 0) {
                if (buff.remaining() < 8) {
                    rest = new byte[buff.remaining()];
                    buff.get(rest);
                    continue block7;
                }
                buff.mark();
                short objId = buff.getShort();
                short typeId = buff.getShort();
                buff.getShort();
                short descrlen = buff.getShort();
                if (buff.remaining() < descrlen) {
                    buff.reset();
                    rest = new byte[buff.remaining()];
                    buff.get(rest);
                    continue block7;
                }
                byte[] descr = new byte[descrlen];
                buff.get(descr);
                objectsLeft = (short)(objectsLeft - 1);
                String alias = AKey.findLabel(descr);
                if (alias == null) continue;
                String alg = null;
                if (typeId == 3) {
                    alg = AKey.getAlg(descr);
                }
                AKeyObjectIdentified ident = new AKeyObjectIdentified(objId, typeId, alias, alg);
                objList.add(ident);
            }
        } while (objectsLeft != 0);
        this.aliasToNcaIdMap.clear();
        this.priKeysIds.clear();
        this.pubKeysIds.clear();
        this.certsIds.clear();
        Pattern ncaDescrPatt = Pattern.compile("nca_([^_]+)_(.+)");
        for (AKeyObjectIdentified id : objList) {
            try {
                Matcher m = ncaDescrPatt.matcher(id.alias);
                if (!m.matches()) continue;
                Byte ncaId = Byte.parseByte(m.group(1));
                String ncaAlias = m.group(2);
                this.aliasToNcaIdMap.put(ncaAlias, ncaId);
                switch (id.type) {
                    case 1: {
                        this.certsIds.put(ncaId, id.id);
                        break;
                    }
                    case 3: {
                        this.priKeysIds.put(ncaId, id.id);
                        this.priKeyAlg.put(ncaId, id.alg);
                        break;
                    }
                    case 2: {
                        this.pubKeysIds.put(ncaId, id.id);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String findLabel(byte[] in) {
        int idx = AKey.findLastSubArr(in, new byte[]{0, 0, 1, 2});
        if (idx == -1) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(in);
        bb.position(idx);
        bb.getInt();
        int len = bb.getInt();
        byte[] label = new byte[len];
        bb.get(label);
        return new String(label);
    }

    private static int findLastSubArr(byte[] arr, byte[] subarr) {
        int lim = arr.length - subarr.length;
        byte[] tmpArr = new byte[subarr.length];
        for (int i = lim; i >= 0; --i) {
            System.arraycopy(arr, i, tmpArr, 0, subarr.length);
            if (!Arrays.equals(tmpArr, subarr)) continue;
            return i;
        }
        return -1;
    }

    private static String getAlg(byte[] in) {
        int idx = AKey.findLastSubArr(in, new byte[]{0, 0, 1, 0, 0, 0, 0, 4, 48, 0, 0, 0});
        if (idx != -1) {
            return "GOST";
        }
        idx = AKey.findLastSubArr(in, new byte[]{0, 0, 1, 0, 0, 0, 0, 4, 3, 16, 50, -44});
        if (idx != -1) {
            return "GOST512";
        }
        idx = AKey.findLastSubArr(in, new byte[]{0, 0, 1, 0, 0, 0, 0, 4, 0, 0, 0, 0});
        if (idx != -1) {
            return "RSA";
        }
        return null;
    }

    private void closeSession() throws KalkanException, CardException {
        if (!this.sessionOpened) {
            return;
        }
        AKey.checkResponse(this.ch.transmit(new CommandAPDU(128, 6, 0, 0)));
        this.sessionOpened = false;
    }

    private void createSessionAndLogin() throws CardException, KalkanException {
        if (!this.sessionOpened) {
            ResponseAPDU resp = this.ch.transmit(new CommandAPDU(128, 3, 0, 0, 5));
            AKey.checkResponse(resp);
            this.sessionOpened = true;
        }
        this.auth(this.pin);
    }

    private synchronized byte[] readObjectValue(short obj) throws KalkanException, CardException {
        int expectedLen = 0;
        int offset = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            CommandAPDU command;
            ResponseAPDU resp;
            if ((resp = this.ch.transmit(command = new CommandAPDU(128, 15, (obj & 0xFF00) >> 8, obj & 0xFF, 255))).getSW() != 36864) {
                throw new KalkanException(PCSCCode.CARD_EXCEPTION).set("SW", resp.getSW());
            }
            if (offset == 0 && expectedLen == 0) {
                expectedLen = ByteBuffer.wrap(resp.getData()).getShort();
                baos.write(resp.getData(), 2, resp.getData().length - 2);
                offset += resp.getData().length - 2;
                continue;
            }
            baos.write(resp.getData(), 0, resp.getData().length);
            offset += resp.getData().length;
        } while (offset != expectedLen);
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte generateRsaKeyPair(String alias, boolean isXch, int keyLength) throws KalkanException {
        ByteBuffer bb = ByteBuffer.allocate(258);
        bb.putShort((short)2048);
        bb.position(255);
        bb.put((byte)1).put((byte)0).put((byte)1);
        byte[] template = bb.array();
        if (this.aliasToNcaIdMap.containsKey(alias)) {
            throw new KalkanException("alias already exists: " + alias, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
        try {
            byte[] priDescr = this.generateObjectDescForRsaPri(alias);
            byte[] pubDescr = this.generateObjectDescForRsaPub(alias);
            ByteBuffer cData = ByteBuffer.allocate(8 + priDescr.length + pubDescr.length + template.length);
            cData.putShort((short)255).putShort((short)240);
            cData.putShort((short)pubDescr.length).putShort((short)priDescr.length);
            cData.put(pubDescr).put(priDescr);
            cData.put(template);
            byte[] commandData = cData.array();
            this.createSessionAndLogin();
            try {
                ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 17, 0, 0, commandData);
                if (resp.getSW() != 36864) throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", resp.getSW());
                this.readNcaObjects();
                byte by = this.aliasToNcaIdMap.get(alias);
                return by;
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte generateGostKeyPair(String alias) throws KalkanException {
        if (this.aliasToNcaIdMap.containsKey(alias)) {
            throw new KalkanException("alias already exists: " + alias, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
        try {
            byte[] pubDescr = this.generateObjectDescForEcGostPub(alias);
            byte[] priDescr = this.generateObjectDescForEcGostPri(alias);
            ByteBuffer cData = ByteBuffer.allocate(8 + pubDescr.length + priDescr.length + FT_DP_34102012_32_A.length);
            cData.putShort((short)255).putShort((short)240);
            cData.putShort((short)pubDescr.length).putShort((short)priDescr.length);
            cData.put(pubDescr).put(priDescr);
            cData.put(FT_DP_34102012_32_A);
            byte[] commandData = cData.array();
            this.createSessionAndLogin();
            try {
                ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 17, 1, 0, commandData);
                if (resp.getSW() != 36864) throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", resp.getSW());
                this.readNcaObjects();
                byte by = this.aliasToNcaIdMap.get(alias);
                return by;
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte generateGost512KeyPair(String alias) throws KalkanException {
        if (this.aliasToNcaIdMap.containsKey(alias)) {
            throw new KalkanException("alias already exists: " + alias, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
        try {
            byte[] pubDescr = this.generateObjectDescForEcGost512Pub(alias);
            byte[] priDescr = this.generateObjectDescForEcGost512Pri(alias);
            ByteBuffer cData = ByteBuffer.allocate(8 + pubDescr.length + priDescr.length + FT_DP_34102012_64_A.length);
            cData.putShort((short)255).putShort((short)240);
            cData.putShort((short)pubDescr.length).putShort((short)priDescr.length);
            cData.put(pubDescr).put(priDescr);
            cData.put(FT_DP_34102012_64_A);
            byte[] commandData = cData.array();
            this.createSessionAndLogin();
            try {
                ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 17, 2, 0, commandData);
                if (resp.getSW() != 36864) throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", resp.getSW());
                this.readNcaObjects();
                byte by = this.aliasToNcaIdMap.get(alias);
                return by;
            }
            finally {
                this.closeSession();
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
    }

    private byte[] generateObjectDescForCert(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("0000000000000004010000000000000100000001010000000200000001000000017000000001010000017100000001010000008000000004000000000000008600000001000000008700000004000000000000011000000000000001110000000000000101000000000000008100000000000000820000000000000089000000000000008a000000000000008b000000000000008800000004000000000000008c000000042002000000000090000000039f9d6d00000011fffffffe");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForEcGostPub(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("000000000000000402000000000000010000000101000000020000000100000001700000000100000001710000000101000001000000000430000000000001100000000000000111000000000000010c0000000100000001630000000101000001660000000400120000400006000000000000000101000000000000010400000001000000010a00000001010000010b00000001000000010600000001000000008600000001004000021100000000000002500000000906072a8503020223010000025200000000000002510000000906072a850302021e0100000011fffffffe");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForEcGost512Pub(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("0000000000000004020000000000000100000001010000000200000001000000017000000001000000017100000001010000010000000004031032d4000001100000000000000111000000000000010c0000000100000001630000000101000001660000000400120000400006000000000000000101000000000000010400000001000000010a00000001010000010b00000001000000010600000001000000008600000001004000021100000000000002500000000b06092a85030701020102010000025200000000000002510000000906072a850302021e0100000011fffffffe");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForRsaPub(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("000000000000000402000000000000010000000101000000020000000100000001700000000100000001710000000101000001000000000400000000000001100000000000000111000000000000010c0000000100000001630000000101000001660000000400000000400006000000000000000101000000000000010400000001000000010a00000001010000010b00000001000000010600000001000000008600000001004000021100000000000001210000000400080000000001220000000301000100000120fffffffe");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForRsaPri(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("000000000000000403000000000000010000000101000000020000000101000001700000000101000001710000000101000001000000000400000000000001100000000000000111000000000000010c000000010000000163000000010100000166000000040000000040000600000000000000010100000000000001030000000101000001050000000100000001080000000101000001090000000100000001070000000100000001620000000100000001650000000101000001640000000101000002100000000100400002120000000000000202000000010000000123ffffffff00000124ffffffff00000125ffffffff00000126ffffffff00000127ffffffff00000128ffffffff800010020000000400080000000001220000000301000100000120fffffffe");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForEcGostPri(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("000000000000000403000000000000010000000101000000020000000101000001700000000100000001710000000101000001000000000430000000000001100000000000000111000000000000010c000000010000000163000000010100000166000000040012000040000600000000000000010100000000000001030000000101000001050000000100000001080000000101000001090000000100000001070000000100000001620000000100000001650000000101000001640000000101000002100000000100400002120000000000000202000000010000000011ffffffff000002500000000906072a8503020223010000025200000000000002510000000906072a850302021e01");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDescForEcGost512Pri(String alias) throws KalkanException {
        byte[] p11Desc = Hex.decode("0000000000000004030000000000000100000001010000000200000001010000017000000001000000017100000001010000010000000004031032d4000001100000000000000111000000000000010c000000010000000163000000010100000166000000040012000040000600000000000000010100000000000001030000000101000001050000000100000001080000000101000001090000000100000001070000000100000001620000000100000001650000000101000001640000000101000002100000000100400002120000000000000202000000010000000011ffffffff000002500000000b06092a85030701020102010000025200000000000002510000000906072a850302021e01");
        return this.generateObjectDesc(alias, p11Desc);
    }

    private byte[] generateObjectDesc(String alias, byte[] objectBlob) throws KalkanException {
        byte[] label = this.generateLabelForObjectDesc(alias);
        ByteBuffer bb = ByteBuffer.allocate(objectBlob.length + 16 + label.length * 2);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(objectBlob);
        bb.putInt(3);
        bb.putInt(label.length);
        bb.put(label);
        bb.putInt(258);
        bb.putInt(label.length);
        bb.put(label);
        return bb.array();
    }

    private synchronized byte[] generateLabelForObjectDesc(String alias) throws KalkanException {
        try {
            byte b;
            if (this.aliasToNcaIdMap.containsKey(alias)) {
                String t = "nca_" + this.aliasToNcaIdMap.get(alias) + "_" + alias;
                return t.getBytes("UTF8");
            }
            byte ncaId = 0;
            for (b = 1; b <= 127; b = (byte)(b + 1)) {
                if (this.aliasToNcaIdMap.containsValue(b)) continue;
                ncaId = b;
                break;
            }
            if (ncaId == 0) {
                for (b = -1; b <= -128; b = (byte)(b - 1)) {
                    if (this.aliasToNcaIdMap.containsValue(b)) continue;
                    ncaId = b;
                    break;
                }
            }
            if (ncaId == 0) {
                throw new KalkanException("no free id found", (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
            }
            String t = "nca_" + ncaId + "_" + alias;
            return t.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
    }

    private static ResponseAPDU sendLongDataCommand(CardChannel ch, int cla, int ins, int p1, int p2, byte[] data) throws KalkanException, CardException {
        ResponseAPDU resp;
        byte[] subData;
        int offset = 0;
        do {
            subData = new byte[Math.min(255, data.length - offset)];
            System.arraycopy(data, offset, subData, 0, subData.length);
            CommandAPDU comm = new CommandAPDU(cla, ins, p1, p2, subData, 255);
            resp = ch.transmit(comm);
        } while ((offset += subData.length) != data.length);
        return resp;
    }

    private byte[] signGOST(byte[] data, byte keyId) throws KalkanException, CardException {
        int algId;
        byte[] cData = kz.gov.pki.kalkan.util.Arrays.clone(data);
        kz.gov.pki.kalkan.util.Arrays.reverse(cData);
        String algName = this.priKeyAlg.get(keyId);
        if ("GOST512".equals(algName)) {
            algId = 2;
        } else if ("GOST".equals(algName)) {
            algId = 1;
        } else {
            throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
        }
        ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 18, algId, this.priKeysIds.get(keyId) & 0xFF, cData);
        if (resp.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", resp.getSW());
        }
        byte[] sign = resp.getData();
        kz.gov.pki.kalkan.util.Arrays.reverse(sign);
        return sign;
    }

    private byte[] signRSA(byte[] data, byte keyId) throws KalkanException, CardException {
        byte[] cData = kz.gov.pki.kalkan.util.Arrays.clone(data);
        kz.gov.pki.kalkan.util.Arrays.reverse(cData);
        byte[] data256 = AKey.encodePkcs1(data, 256);
        ResponseAPDU resp = AKey.sendLongDataCommand(this.ch, 128, 18, 0, this.priKeysIds.get(keyId) & 0xFF, data256);
        if (resp.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", resp.getSW());
        }
        byte[] sign = resp.getData();
        return sign;
    }

    private static byte[] encodePkcs1(byte[] t, int len) {
        byte[] b = new byte[len];
        b[1] = 1;
        for (int i = 2; i < len - t.length - 1; ++i) {
            b[i] = -1;
        }
        System.arraycopy(t, 0, b, len - t.length, t.length);
        return b;
    }

    private synchronized void deleteTokenObject(short obj) throws KalkanException, CardException {
        CommandAPDU command = new CommandAPDU(128, 14, (obj & 0xFF00) >> 8, obj & 0xFF);
        ResponseAPDU resp = this.ch.transmit(command);
        if (resp.getSW() != 36864) {
            throw new KalkanException(PCSCCode.CARD_EXCEPTION).set("SW", resp.getSW());
        }
    }

    private static class AKeyObjectIdentified {
        public short id;
        public short type;
        public String alias;
        public String alg;

        public AKeyObjectIdentified() {
        }

        public AKeyObjectIdentified(short id, short type, String alias, String alg) {
            this.id = id;
            this.type = type;
            this.alias = alias;
            this.alg = alg;
        }
    }
}

