/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.parsers.DG11Parser;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.encoders.Hex;

public final class KZIDCard
extends AKToken {
    private static final String RSAALIAS = "RSA0";
    private static final String RSA2048ALIAS1 = "RSA1";
    private static final String RSA2048ALIAS2 = "RSA2";
    private static final String RSA2048ALIAS3 = "RSA3";
    private static final String RSA2048ALIAS4 = "RSA4";
    private static final String GOSTALIAS1 = "GOST1";
    private static final String GOSTALIAS2 = "GOST2";
    private Map<String, Byte> aliases = null;
    private static final Map<Byte, byte[]> certByKey = new HashMap<Byte, byte[]>();
    private static final byte[] p = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -105};
    private static final byte[] q = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, 97, 16, 112, -103, 90, -47, 0, 69, -124, 27, 9, -73, 97, -72, -109};
    private static final byte[] xy = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -115, -111, -28, 113, -32, -104, -100, -38, 39, -33, 80, 90, 69, 63, 43, 118, 53, 41, 79, 45, -33, 35, -29, -79, 34, -84, -55, -100, -98, -97, 30, 20};
    private static final byte[] a = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -108};
    private static final byte[] b = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -90};
    private static final byte[] MF = new byte[]{63, 0};
    private static final byte[] IIN_EF = new byte[]{3, 1};
    private static final byte[] DG11_EF = new byte[]{-96, 0, 0, 2, 71, 16, 1};
    private static final byte[] SDO_DF = new byte[]{1, 1};

    public KZIDCard(String tName, String pin) throws KalkanException {
        super(tName, pin);
        this.connect();
        try {
            this.capdu = new CommandAPDU(0, 202, 223, 1, 9);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.NOT_KZIDCARD);
            }
            this.tokenId = Hex.encodeStr(this.respApdu.getData());
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        this.aliases = new HashMap<String, Byte>();
        this.aliases.put(RSA2048ALIAS1 + this.tokenId, (byte)-121);
        this.aliases.put(RSA2048ALIAS2 + this.tokenId, (byte)-120);
        try {
            this.getPublicKey("RSA", (byte)-119);
            this.getPublicKey("RSA", (byte)-118);
            this.aliases.put(RSA2048ALIAS3 + this.tokenId, (byte)-119);
            this.aliases.put(RSA2048ALIAS4 + this.tokenId, (byte)-118);
        }
        catch (KalkanException e) {
            if (e.getErrorCode() == PCSCCode.INVALID_PUBKEY) {
                this.debugOut("There are no additional SDOs!");
            }
            throw e;
        }
        this.infoMap.put("FULLNAME", this.getFullName());
        this.infoMap.put("IIN", this.getIIN());
        if (pin != null) {
            this.verifyPin(pin);
        }
    }

    protected void verifyPin(String pin) throws KalkanException {
        if (pin == null || pin.getBytes().length != 4) {
            throw new KalkanException("Pin length != 4", (ErrorCode)PCSCCode.INVALID_PIN_VALUE);
        }
        byte[] pinb = new byte[]{48, 48, 48, 48, 48, 48, 48, 48};
        try {
            this.selectFile(0, false, MF);
            System.arraycopy(pin.getBytes(), 0, pinb, 0, 4);
            this.capdu = new CommandAPDU(0, 32, 0, 2, pinb);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                String sw = Integer.toHexString(this.respApdu.getSW());
                if (this.respApdu.getSW1() == 99) {
                    int retryCount = Character.getNumericValue(Integer.toHexString(this.respApdu.getSW2()).charAt(1));
                    throw new KalkanException(PCSCCode.WRONG_PIN).set("RetryCount", retryCount).set("SW", sw);
                }
                if (this.respApdu.getSW() == 27011 || this.respApdu.getSW() == 27012) {
                    throw new KalkanException(PCSCCode.BLOCKED_PIN);
                }
                throw new KalkanException(PCSCCode.WRONG_PIN).set("SW", sw);
            }
            this.debugOut("verification... ok!");
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    private byte[] getPublicKeyRSA(byte keyId) throws CardException, KalkanException {
        this.debugOut("Get RAW RSA public key");
        byte[] publicKey = new byte[256];
        byte sdoId = (byte)(keyId & 0x7F);
        byte[] rsaModulus = new byte[]{0, -53, 63, -1, 11, 77, 9, -1, -96, sdoId, 5, 127, 73, 2, -127, 0};
        if (sdoId != 6) {
            this.selectFile(1, false, SDO_DF);
        }
        this.capdu = new CommandAPDU(rsaModulus);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        byte[] publicKeyRaw = this.respApdu.getData();
        int rawKeyLength = publicKeyRaw.length - 15;
        if (rawKeyLength != publicKey.length) {
            this.debugOut("Incorrect key length: " + rawKeyLength);
            throw new KalkanException(PCSCCode.INVALID_PUBKEY);
        }
        System.arraycopy(publicKeyRaw, 15, publicKey, 0, publicKey.length);
        return publicKey;
    }

    private byte[] getPublicKeyGOST(byte keyId) throws CardException, KalkanException {
        int i;
        this.debugOut("Get RAW GOST public key");
        byte[] publicKey = new byte[64];
        byte[] publicKeyGostAPDU = new byte[]{0, -53, 63, -1, 11, 77, 9, -1, -94, keyId, 5, 127, 78, 2, -122, 0};
        this.capdu = new CommandAPDU(publicKeyGostAPDU);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        byte[] publicKeyRaw = new byte[64];
        System.arraycopy(this.respApdu.getData(), 9, publicKeyRaw, 0, 64);
        for (i = 0; i < 32; ++i) {
            publicKey[i] = publicKeyRaw[31 - i];
        }
        for (i = 0; i < 32; ++i) {
            publicKey[i + 32] = publicKeyRaw[63 - i];
        }
        return publicKey;
    }

    public byte[] getPublicKey(String algName, byte keyId) throws KalkanException {
        byte[] ret = null;
        try {
            this.selectFile(0, false, MF);
            if (algName.equals("GOST")) {
                ret = this.getPublicKeyGOST(keyId);
            } else if (algName.equals("RSA")) {
                ret = this.getPublicKeyRSA(keyId);
            }
        }
        catch (CardException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private byte[] signRSA(byte[] data, byte keyId) throws CardException, KalkanException {
        this.debugOut("RSA signing");
        byte[] hash = data;
        if (keyId != -122) {
            this.selectFile(1, false, SDO_DF);
        }
        this.capdu = new CommandAPDU(0, 34, 65, 164, new byte[]{-107, 1, 64, -124, 1, keyId, -128, 1, 2});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        if (this.respApdu.getSW() != 36864) {
            if (this.respApdu.getSW() == 27264) {
                byte sdoId = (byte)(keyId & 0x7F);
                this.capdu = new CommandAPDU(0, 34, 65, 164, new byte[]{-107, 1, 64, -124, 1, sdoId, -128, 1, 2});
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW() != 36864) {
                    throw new KalkanException("Signing with ID-Card of 2020 failed.", (ErrorCode)PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
                }
            } else {
                throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
            }
        }
        this.capdu = new CommandAPDU(0, 136, 2, 0, hash);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        return this.respApdu.getData();
    }

    private byte[] signGOST(byte[] data, byte keyId) throws CardException, KalkanException {
        int i;
        this.debugOut("GOST signing");
        this.capdu = new CommandAPDU(0, 34, 65, 182, new byte[]{-107, 1, 64, -124, 1, keyId, -128, 1, 116});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        this.capdu = new CommandAPDU(0, 42, 158, 154, data);
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        byte[] gostSignRaw = this.respApdu.getData();
        byte[] gostSign = new byte[64];
        for (i = 0; i < 32; ++i) {
            gostSign[i] = gostSignRaw[31 - i];
        }
        for (i = 0; i < 32; ++i) {
            gostSign[i + 32] = gostSignRaw[63 - i];
        }
        return gostSign;
    }

    public byte[] sign(String algName, byte[] data, byte keyId) throws KalkanException {
        byte[] ret = null;
        try {
            this.selectFile(0, false, MF);
            if (algName.equals("GOST")) {
                ret = this.signGOST(data, keyId);
            } else if (algName.equals("RSA")) {
                ret = this.signRSA(data, keyId);
            }
        }
        catch (CardException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private byte genKeyPairRSA(String alias, boolean isXch) throws KalkanException, CardException {
        this.debugOut("RSA key pair generation");
        byte ret = 0;
        if (alias.startsWith(RSAALIAS)) {
            alias = alias.replaceFirst(RSAALIAS, "");
            ret = -122;
        } else if (alias.startsWith(RSA2048ALIAS1)) {
            alias = alias.replaceFirst(RSA2048ALIAS1, "");
            ret = -121;
        } else if (alias.startsWith(RSA2048ALIAS2)) {
            alias = alias.replaceFirst(RSA2048ALIAS2, "");
            ret = -120;
        } else if (alias.startsWith(RSA2048ALIAS3)) {
            alias = alias.replaceFirst(RSA2048ALIAS3, "");
            ret = -119;
        } else if (alias.startsWith(RSA2048ALIAS4)) {
            alias = alias.replaceFirst(RSA2048ALIAS4, "");
            ret = -118;
        } else {
            throw new KalkanException("Non-existent alias: " + alias, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
        if (ret != -122) {
            this.selectFile(1, false, SDO_DF);
        }
        this.capdu = new CommandAPDU(0, 70, 2, 0, new byte[]{-92, 3, -124, 1, ret});
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            if (this.respApdu.getSW() == 27264) {
                byte sdoId = (byte)(ret & 0x7F);
                this.capdu = new CommandAPDU(0, 70, 2, 0, new byte[]{-92, 3, -124, 1, sdoId});
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW() != 36864) {
                    throw new KalkanException("Generation with ID-Card of 2020 failed.", (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
                }
            } else {
                throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
            }
        }
        return ret;
    }

    private byte genKeyPairGOST(String alias) throws KalkanException, CardException {
        byte ret;
        this.debugOut("GOST key pair generation");
        if (alias.startsWith(GOSTALIAS1)) {
            alias = alias.replaceFirst(GOSTALIAS1, "");
            ret = 1;
        } else if (alias.startsWith(GOSTALIAS2)) {
            alias = alias.replaceFirst(GOSTALIAS2, "");
            ret = 2;
        } else {
            throw new KalkanException("Non-existent alias: " + alias, (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
        }
        if (!this.checkParameters(ret)) {
            this.updateParameters(ret);
        }
        this.capdu = new CommandAPDU(0, 70, 2, 0, new byte[]{-74, 3, -124, 1, ret});
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
        }
        return ret;
    }

    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KalkanException {
        byte ret;
        block4: {
            this.verifyPin(this.pin);
            try {
                if (algName.equals("GOST")) {
                    ret = this.genKeyPairGOST(alias);
                    break block4;
                }
                if (algName.equals("RSA")) {
                    ret = this.genKeyPairRSA(alias, isXch);
                    break block4;
                }
                throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
            }
            catch (CardException e) {
                throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
        return ret;
    }

    private void debugOut(String s) {
        System.out.println("[KZ ID CARD]> " + s);
    }

    public void disconnect() {
        try {
            if (this.sc != null) {
                this.sc.disconnect(false);
            }
        }
        catch (CardException e) {
            this.debugOut(e.getMessage());
        }
    }

    private String getIIN() throws KalkanException {
        String iin = null;
        try {
            this.selectFile(0, false, MF);
            this.respApdu = this.selectFile(2, false, IIN_EF);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.SELECT).set("SW", this.respApdu.getSW());
            }
            this.capdu = new CommandAPDU(0, 176, 0, 0, 12);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.READ_BINARY).set("SW", this.respApdu.getSW());
            }
            byte[] data = this.respApdu.getData();
            if (data != null && data.length != 12) {
                throw new KalkanException(PCSCCode.INVALID_DATA).set("SW", this.respApdu.getSW());
            }
            iin = new String(data);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return iin;
    }

    private String getFullName() throws KalkanException {
        String ret = "";
        try {
            this.respApdu = this.selectFile(4, false, DG11_EF);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.SELECT).set("SW", this.respApdu.getSW());
            }
            this.capdu = new CommandAPDU(0, 176, 139, 0, 256);
            this.respApdu = this.ch.transmit(this.capdu);
            byte[] data = this.respApdu.getData();
            if (data == null) {
                throw new KalkanException(PCSCCode.INVALID_DATA).set("SW", this.respApdu.getSW());
            }
            DG11Parser parser = new DG11Parser(data);
            StringBuilder sb = new StringBuilder();
            ret = sb.append(parser.getLastname()).append(" ").append(parser.getFirstname()).append(" ").append(parser.getSecondname()).toString();
            this.infoMap.put("LASTNAME", parser.getLastname());
            this.infoMap.put("FIRSTNAME", parser.getFirstname());
            this.infoMap.put("MIDDLENAME", parser.getSecondname());
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private void updateParameters(byte keyId) throws CardException, KalkanException {
        this.debugOut("Update GOST parameters");
        byte[] createSDOprivate = new byte[]{0, -37, 63, -1, -5, -1, -110, keyId, -127, -10, 127, 79, -127, -14, -121, 1, 1, -122, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -123, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, 97, 16, 112, -103, 90, -47, 0, 69, -124, 27, 9, -73, 97, -72, -109, -124, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -115, -111, -28, 113, -32, -104, -100, -38, 39, -33, 80, 90, 69, 63, 43, 118, 53, 41, 79, 45, -33, 35, -29, -79, 34, -84, -55, -100, -98, -97, 30, 20, -125, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -90, -126, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -108, -127, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -105, -128, 1, 116};
        this.capdu = new CommandAPDU(createSDOprivate);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.UPDATE_GOSTPARAMS);
        }
        byte[] createSDOpub1 = new byte[]{16, -37, 63, -1, -8, -1, -94, keyId, -126, 1, 23, 127, 78, -126, 1, 18, -121, 1, 1, -122, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -123, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, 97, 16, 112, -103, 90, -47, 0, 69, -124, 27, 9, -73, 97, -72, -109, -124, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -115, -111, -28, 113, -32, -104, -100, -38, 39, -33, 80, 90, 69, 63, 43, 118, 53, 41, 79, 45, -33, 35, -29, -79, 34, -84, -55, -100, -98, -97, 30, 20, -125, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -90, -126, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -108};
        this.capdu = new CommandAPDU(createSDOpub1);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.UPDATE_GOSTPARAMS);
        }
        byte[] createSDOpub2 = new byte[]{0, -37, 63, -1, 37, -127, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -105, -128, 1, 116};
        this.capdu = new CommandAPDU(createSDOpub2);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.UPDATE_GOSTPARAMS);
        }
    }

    private byte[] getParameter(byte keyId, byte param) throws CardException, KalkanException {
        byte[] value = null;
        byte[] apduG = new byte[]{0, -53, 63, -1, 11, 77, 9, -1, -94, keyId, 5, 127, 78, 2, param, 0};
        this.capdu = new CommandAPDU(apduG);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.GET_GOSTPARAMS);
        }
        byte[] data = this.respApdu.getData();
        if (data != null && data.length > 9) {
            value = new byte[data.length - 9];
            System.arraycopy(data, 9, value, 0, value.length);
        }
        if (value == null) {
            throw new KalkanException(PCSCCode.GET_GOSTPARAMS);
        }
        return value;
    }

    private boolean checkParameters(byte keyId) throws CardException, KalkanException {
        return Arrays.equals(q, this.getParameter(keyId, (byte)-123)) && Arrays.equals(xy, this.getParameter(keyId, (byte)-124)) && Arrays.equals(b, this.getParameter(keyId, (byte)-125)) && Arrays.equals(a, this.getParameter(keyId, (byte)-126)) && Arrays.equals(p, this.getParameter(keyId, (byte)-127));
    }

    private void setCertificate(byte fileId, byte[] certificate) throws KalkanException, CardException {
        this.debugOut("Set certificate");
        try {
            ByteArrayOutputStream gzbaos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(gzbaos);
            gzout.write(certificate);
            gzout.close();
            gzbaos.close();
            byte[] gzcer = gzbaos.toByteArray();
            if (gzcer.length > 2048) {
                throw new KalkanException(PCSCCode.LARGE_GZCERT).set("MaxGZCertSize", 2048).set("CertSize", certificate.length).set("GZCertSize", gzcer.length);
            }
            short certSize = (short)gzcer.length;
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(certSize);
            this.debugOut("Certificate has been GZipped");
            this.debugOut("was: " + certificate.length + "; now: " + certSize);
            this.selectFile(0, false, MF);
            if (fileId == -121 || fileId == -120 || fileId == -119 || fileId == -118) {
                this.selectFile(1, false, new byte[]{8, 1});
            }
            this.selectFile(2, false, certByKey.get(fileId));
            this.capdu = new CommandAPDU(0, 214, 0, 0, new byte[]{bb.get(0), bb.get(1)});
            this.respApdu = this.ch.transmit(this.capdu);
            this.writeBinary(gzcer, (short)2, certSize);
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
    }

    public void setCertificate(String alias, byte[] certificate) throws KalkanException {
        try {
            this.setCertificate(this.aliases.get(alias), certificate);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public byte[] getCertificate(String alias) throws KalkanException {
        byte[] ret = null;
        Byte keyId = this.aliases.get(alias);
        if (keyId != null) {
            ret = this.getCertificate(keyId);
        }
        return ret;
    }

    private byte[] getCertificate(byte fileId) throws KalkanException {
        byte[] ret = null;
        this.debugOut("Get certificate");
        try {
            this.selectFile(0, false, MF);
            if (fileId == -121 || fileId == -120 || fileId == -119 || fileId == -118) {
                this.selectFile(1, false, new byte[]{8, 1});
            }
            this.selectFile(2, false, certByKey.get(fileId));
            this.capdu = new CommandAPDU(0, 176, 0, 0, 2);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(this.respApdu.getData());
            short certSize = bb.getShort(0);
            if (certSize == 0) {
                return null;
            }
            this.debugOut("certsize = " + certSize);
            byte[] certificate = this.readBinary((short)2, certSize);
            ByteArrayOutputStream ungzbaos = new ByteArrayOutputStream();
            ByteArrayInputStream gzbais = new ByteArrayInputStream(certificate);
            try {
                this.debugOut("UnGZipping certificate");
                GZIPInputStream gzin = new GZIPInputStream(gzbais);
                int c = gzin.read();
                while (c != -1) {
                    ungzbaos.write(c);
                    c = gzin.read();
                }
                gzin.close();
                gzbais.close();
                ungzbaos.close();
                ret = ungzbaos.toByteArray();
            }
            catch (IOException ioe) {
                ret = certificate;
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    public Map getAliases() throws KalkanException {
        return this.aliases;
    }

    public PrivateKey getKey(String alias) throws KalkanException {
        this.verifyPin(this.pin);
        PrivateKey ret = null;
        if (alias.equals(RSAALIAS + this.tokenId)) {
            ret = new AKRSAPrivateKey(this, -122);
        } else if (alias.equals(RSA2048ALIAS1 + this.tokenId)) {
            ret = new AKRSAPrivateKey(this, -121);
        } else if (alias.equals(RSA2048ALIAS2 + this.tokenId)) {
            ret = new AKRSAPrivateKey(this, -120);
        } else if (alias.equals(RSA2048ALIAS3 + this.tokenId)) {
            ret = new AKRSAPrivateKey(this, -119);
        } else if (alias.equals(RSA2048ALIAS4 + this.tokenId)) {
            ret = new AKRSAPrivateKey(this, -118);
        } else if (alias.equals(GOSTALIAS1 + this.tokenId)) {
            ret = new AKGOST34310PrivateKey(this, 1);
        } else if (alias.equals(GOSTALIAS2 + this.tokenId)) {
            ret = new AKGOST34310PrivateKey(this, 2);
        } else {
            throw new KalkanException(PCSCCode.INVALID_PRIVKEY);
        }
        return ret;
    }

    public byte[] getRandom(int lc) {
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(0, 132, 0, 0, 8);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                ret = this.respApdu.getData();
            }
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    private ResponseAPDU selectFile(int type, boolean isDataNeed, byte[] file) throws CardException {
        this.capdu = new CommandAPDU(0, 164, type, isDataNeed ? 0 : 12, file);
        return this.ch.transmit(this.capdu);
    }

    public void deleteEntry(String alias) throws KalkanException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void changePin(byte type, String pin) throws KalkanException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        certByKey.put((byte)-122, new byte[]{6, 1});
        certByKey.put((byte)-121, new byte[]{1, 1});
        certByKey.put((byte)-120, new byte[]{1, 2});
        certByKey.put((byte)-119, new byte[]{1, 1});
        certByKey.put((byte)-118, new byte[]{1, 2});
        certByKey.put((byte)1, new byte[]{7, 1});
        certByKey.put((byte)2, new byte[]{7, 2});
    }
}

