/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.AKGOST3410_2015PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.parsers.MapFileParser;
import kz.gov.pki.kalkan.pcsc.parsers.TLVParser;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.Arrays;
import kz.gov.pki.kalkan.util.ByteUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;

public final class Kaztoken
extends AKToken {
    private static final short MIN_FREEMEM_FOR_CERT = 5120;
    private static final short MIN_FREEMEM_FOR_KEY = 2048;

    public Kaztoken(String tName, String pin) throws KalkanException {
        super(tName, pin);
        this.connect();
        try {
            this.capdu = new CommandAPDU(0, 202, 1, 129, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.NOT_KAZTOKEN);
            }
            this.tokenId = Hex.encodeStr(this.respApdu.getData()).substring(8);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        if (pin != null) {
            this.verifyPin(pin);
        }
    }

    public void verifyPin(String pin) throws KalkanException {
        if (pin == null || pin.isEmpty()) {
            throw new KalkanException(PCSCCode.INVALID_PIN_VALUE);
        }
        try {
            this.reset();
            this.capdu = new CommandAPDU(0, 32, 0, 2, pin.getBytes());
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                this.capdu = new CommandAPDU(0, 32, 0, 2);
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW1() == 99) {
                    int retryCount = Character.getNumericValue(Integer.toHexString(this.respApdu.getSW2()).charAt(1));
                    throw new KalkanException(PCSCCode.WRONG_PIN).set("RetryCount", retryCount).set("SW", this.respApdu.getSW());
                }
                if (this.respApdu.getSW() == 27011) {
                    throw new KalkanException(PCSCCode.BLOCKED_PIN);
                }
                throw new KalkanException(PCSCCode.WRONG_PIN).set("SW", this.respApdu.getSW());
            }
            this.debugOut("verification... ok!");
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    private int getAvailableMemorySize() {
        int ret = 0;
        try {
            this.capdu = new CommandAPDU(0, 202, 1, 138, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(this.respApdu.getData());
            this.debugOut("Available (bytes): " + bb.getInt(0));
            ret = bb.getInt(0);
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    private MapFileParser getMapFile() throws CardException, KalkanException {
        MapFileParser mapParser = null;
        this.debugOut("reading map file...");
        this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 16, 16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 27266) {
            this.debugOut("Creating map DF");
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 56, 0, -128, 2, 0, 16, -125, 2, 16, 16, -122, 15, 67, 2, 2, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864 && this.respApdu.getSW() != 27273) {
                throw new CardException("Could not create map file");
            }
            mapParser = new MapFileParser(null);
        } else {
            this.capdu = new CommandAPDU(0, -92, 0, 4, new byte[]{16, 16}, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            TLVParser tlvParser = new TLVParser(this.respApdu.getData());
            mapParser = new MapFileParser(this.readBinary((short)0, tlvParser.getFileLen()));
        }
        return mapParser;
    }

    private MapFileParser updateMapFile(String alias, boolean isRemoval) throws CardException, IOException, KalkanException {
        MapFileParser mapParser = this.getMapFile();
        if (alias == null) {
            throw new KalkanException("Alias is null", (ErrorCode)PCSCCode.UPDATE_MAP_FAILURE);
        }
        if (isRemoval) {
            if (!mapParser.getRevMapFile().containsKey(alias)) {
                throw new KalkanException(alias + " not found ", (ErrorCode)PCSCCode.UPDATE_MAP_FAILURE);
            }
        } else {
            if (mapParser.getNewId() == 255) {
                throw new KalkanException("Maximum File ID has been reached.", (ErrorCode)PCSCCode.UPDATE_MAP_FAILURE);
            }
            if (mapParser.getRevMapFile().containsKey(alias)) {
                throw new KalkanException(alias + " already exists", (ErrorCode)PCSCCode.UPDATE_MAP_FAILURE);
            }
        }
        this.debugOut("Updating map file...");
        ByteBuffer fileSize = ByteBuffer.allocate(2);
        fileSize.putShort(isRemoval ? (short)(mapParser.getSize() - alias.length() - 2) : (short)(mapParser.getSize() + alias.length() + 2));
        this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        this.capdu = new CommandAPDU(0, -28, 0, 0, new byte[]{16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 1, 0, -128, 2, fileSize.get(0), fileSize.get(1), -125, 2, 16, 16, -122, 15, 66, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
        this.respApdu = this.ch.transmit(this.capdu);
        byte[] newMap = mapParser.updateData(alias, isRemoval);
        this.writeBinary(newMap, (short)0, (short)newMap.length);
        return mapParser;
    }

    private void reset() throws CardException {
        this.capdu = new CommandAPDU(128, 64, 0, 0, 0);
        this.respApdu = this.ch.transmit(this.capdu);
    }

    public void disconnect() {
        try {
            this.reset();
            this.sc.disconnect(false);
        }
        catch (CardException e) {
            this.debugOut(e.getMessage());
        }
    }

    private void debugOut(String s) {
        System.out.println("[Kaztoken]> " + s);
    }

    private byte[] signGOST(byte[] data, byte keyId) throws CardException, KalkanException {
        this.debugOut("GOST signing");
        this.capdu = new CommandAPDU(0, 34, 65, 182, new byte[]{-111, 1, 64, -124, 1, keyId});
        this.respApdu = this.ch.transmit(this.capdu);
        this.capdu = new CommandAPDU(0, 42, 158, 154, data, 255);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        return this.respApdu.getData();
    }

    private byte[] signRSA(byte[] data, byte keyId) throws CardException, KalkanException {
        this.debugOut("RSA signing");
        byte[] hash = data;
        Arrays.reverse(hash);
        this.capdu = new CommandAPDU(0, 34, 65, 182, new byte[]{-107, 1, 64, -124, 1, keyId});
        this.respApdu = this.ch.transmit(this.capdu);
        int mLen = this.getPublicKeyRSA(keyId).length;
        byte[] part = new byte[mLen - hash.length];
        int l = part.length;
        part[l - 1] = 0;
        part[l - 2] = 1;
        for (int i = 1; i < l - 2; ++i) {
            part[i] = -1;
        }
        this.capdu = new CommandAPDU(16, 42, 158, 154, hash);
        this.respApdu = this.ch.transmit(this.capdu);
        int o = 0;
        while (o < l - 1) {
            byte[] sdata;
            if (o + 255 < l) {
                sdata = new byte[255];
                System.arraycopy(part, o, sdata, 0, 255);
                this.capdu = new CommandAPDU(16, 42, 158, 154, sdata);
                this.respApdu = this.ch.transmit(this.capdu);
                o += 255;
                continue;
            }
            sdata = new byte[l - o];
            System.arraycopy(part, o, sdata, 0, sdata.length);
            this.capdu = new CommandAPDU(0, 42, 158, 154, sdata, mLen < 256 ? mLen : 256);
            this.respApdu = this.ch.transmit(this.capdu);
            o = l;
        }
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        byte[] sgn = this.respApdu.getData();
        Arrays.reverse(sgn);
        return sgn;
    }

    private byte[] getPublicKeyRSA(byte keyId) throws CardException, KalkanException {
        this.debugOut("Get RAW RSA public key");
        this.capdu = new CommandAPDU(0, 70, 129, (int)keyId, 256);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        byte[] modulus = this.respApdu.getData();
        modulus = ByteUtils.inverseCopyByte(modulus, 0, modulus.length);
        return modulus;
    }

    private byte[] getPublicKeyGOST(byte keyId) throws CardException, KalkanException {
        this.debugOut("Get RAW GOST public key");
        this.capdu = new CommandAPDU(0, 70, 129, (int)keyId, 255);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        return this.respApdu.getData();
    }

    public byte[] getPublicKey(String algName, byte keyId) throws KalkanException {
        byte[] ret = null;
        try {
            if (algName.equals("GOST") || algName.equals("GOST512")) {
                ret = this.getPublicKeyGOST(keyId);
            } else if (algName.equals("RSA")) {
                ret = this.getPublicKeyRSA(keyId);
            }
        }
        catch (CardException ce) {
            new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    public byte[] sign(String algName, byte[] data, byte keyId) throws KalkanException {
        byte[] ret = null;
        try {
            if (algName.equals("GOST") || algName.equals("GOST512")) {
                ret = this.signGOST(data, keyId);
            } else if (algName.equals("RSA")) {
                ret = this.signRSA(data, keyId);
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private byte genKeyPairRSA(String alias, boolean isXch, int keyLength) throws KalkanException, CardException {
        byte ret;
        try {
            ByteBuffer bb = ByteBuffer.allocate(2);
            int keyHalf = keyLength / 8 / 2;
            bb.putShort((short)(keyHalf * 5 + 8));
            MapFileParser mapParser = this.updateMapFile(alias, false);
            this.debugOut("RSA key generation");
            byte newId = mapParser.getNewId();
            byte destiny = (byte)(isXch ? 1 : 0);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, newId, -123, 6, 35, 0, destiny, -1, 0, 0, -122, 15, 71, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            bb.clear();
            bb.putShort((short)(keyHalf * 3));
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, newId, -123, 6, 51, 0, destiny, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, 70, 0, newId);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
            }
            ret = newId;
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
        return ret;
    }

    private byte genKeyPairGOST(String alias, String algName) throws KalkanException, CardException {
        byte ret;
        try {
            MapFileParser mapParser = this.updateMapFile(alias, false);
            this.debugOut(algName + " key generation");
            byte ksfSize = 32;
            byte ksfType = 3;
            if ("GOST512".equals(algName)) {
                ksfSize = 64;
                ksfType = 67;
            }
            byte newId = mapParser.getNewId();
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, 0, ksfSize, -125, 2, 0, newId, -123, 6, ksfType, 32, 0, -1, 0, 0, -122, 15, 71, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, 0, (byte)(ksfSize << 1), -125, 2, 0, newId, -123, 6, (byte)(ksfType | 0x10), 32, 0, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, 70, 0, newId);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
            }
            ret = newId;
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
        return ret;
    }

    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KalkanException {
        byte ret;
        block5: {
            this.verifyPin(this.pin);
            int freemem = this.getAvailableMemorySize();
            if (freemem < 2048) {
                throw new KalkanException(PCSCCode.NOT_ENOUGH_MEMORY).set("FreeMemory", freemem);
            }
            try {
                if (algName.equals("GOST") || algName.equals("GOST512")) {
                    ret = this.genKeyPairGOST(alias, algName);
                    break block5;
                }
                if (algName.equals("RSA")) {
                    ret = this.genKeyPairRSA(alias, isXch, keyLength);
                    break block5;
                }
                throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
            }
            catch (CardException ce) {
                throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
        return ret;
    }

    private void setCertificate(byte fileId, byte[] certificate) throws KalkanException, CardException {
        try {
            ByteArrayOutputStream gzbaos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(gzbaos);
            gzout.write(certificate);
            gzout.close();
            gzbaos.close();
            this.debugOut("Certificate has been GZipped");
            byte[] gzcer = gzbaos.toByteArray();
            if (gzcer.length > 2048) {
                throw new KalkanException(PCSCCode.LARGE_GZCERT).set("MaxGZCertSize", 2048).set("CertSize", certificate.length).set("GZCertSize", gzcer.length);
            }
            short certSize = (short)gzcer.length;
            this.debugOut("was: " + certificate.length + "; now: " + certSize);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(certSize);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, fileId});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0, new byte[]{0, fileId});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 1, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, fileId, -122, 15, 66, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.writeBinary(gzcer, (short)0, certSize);
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
    }

    public void setCertificate(String alias, byte[] certificate) throws KalkanException {
        this.verifyPin(this.pin);
        int freemem = this.getAvailableMemorySize();
        if (freemem < 5120) {
            throw new KalkanException(PCSCCode.NOT_ENOUGH_MEMORY).set("FreeMemory", freemem);
        }
        try {
            this.setCertificate(this.getMapFile().getRevMapFile().get(alias), certificate);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public byte[] getCertificate(String alias) throws KalkanException {
        byte[] ret = null;
        try {
            ret = this.getCertificate(this.getMapFile().getRevMapFile().get(alias));
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private byte[] getCertificate(byte fileId) throws KalkanException, CardException {
        this.debugOut("Get certificate");
        byte[] ret = null;
        this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, fileId}, 256);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SELECT).set("SW", this.respApdu.getSW());
        }
        TLVParser tlvParser = new TLVParser(this.respApdu.getData());
        short certSize = tlvParser.getFileLen();
        byte[] certificate = this.readBinary((short)0, certSize);
        ByteArrayOutputStream ungzbaos = new ByteArrayOutputStream();
        ByteArrayInputStream gzbais = new ByteArrayInputStream(certificate);
        try {
            this.debugOut("Certificate ungzipping");
            GZIPInputStream gzin = new GZIPInputStream(gzbais);
            int c = gzin.read();
            while (c != -1) {
                ungzbaos.write(c);
                c = gzin.read();
            }
            gzin.close();
            gzbais.close();
            ungzbaos.close();
            ret = ungzbaos.toByteArray();
        }
        catch (IOException ioe) {
            ret = certificate;
        }
        return ret;
    }

    public Map getAliases() throws KalkanException {
        try {
            return this.getMapFile().getRevMapFile();
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public PrivateKey getKey(String alias) throws KalkanException {
        PrivateKey ret;
        block6: {
            this.verifyPin(this.pin);
            ret = null;
            try {
                Byte id = this.getMapFile().getRevMapFile().get(alias);
                this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 2, 0, id}, 256);
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW() == 36864) {
                    if (ByteUtils.indexOf(this.respApdu.getData(), new byte[]{-123, 6, 3}, 0) != -1) {
                        ret = new AKGOST34310PrivateKey(this, id);
                        break block6;
                    }
                    if (ByteUtils.indexOf(this.respApdu.getData(), new byte[]{-123, 6, 35}, 0) != -1) {
                        ret = new AKRSAPrivateKey(this, id);
                        break block6;
                    }
                    if (ByteUtils.indexOf(this.respApdu.getData(), new byte[]{-123, 6, 67}, 0) != -1) {
                        ret = new AKGOST3410_2015PrivateKey(this, id);
                        break block6;
                    }
                    throw new KalkanException("Unknown key", (ErrorCode)PCSCCode.INVALID_PRIVKEY);
                }
                throw new KalkanException(PCSCCode.INVALID_PRIVKEY).set("SW", this.respApdu.getSW());
            }
            catch (CardException ce) {
                throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
        return ret;
    }

    public byte[] getRandom(int lc) {
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(0, 132, 0, 0, lc > 256 ? 256 : lc);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                ret = this.respApdu.getData();
            }
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    public void deleteEntry(String alias) throws KalkanException {
        try {
            Byte id = this.getMapFile().getRevMapFile().get(alias);
            this.updateMapFile(alias, true);
            this.debugOut("Deleting " + alias);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 1, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 2, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
    }

    public void changePin(byte type, String pin) throws KalkanException {
        int pinl = pin.getBytes().length;
        if (pinl > 32) {
            throw new KalkanException(PCSCCode.INVALID_PIN_VALUE).set("MaxLength", 32);
        }
        byte[] data = new byte[6 + pinl];
        System.arraycopy(pin.getBytes(), 0, data, 6, pinl);
        data[0] = -128;
        data[1] = 2;
        data[2] = 0;
        data[3] = (byte)pinl;
        data[4] = -91;
        data[5] = (byte)pinl;
        this.capdu = new CommandAPDU(0, 36, 1, (int)type, data);
        try {
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.CHANGEPIN_FAILURE).set("SW", this.respApdu.getSW());
        }
    }
}

