/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils.verifier;

import java.util.ArrayList;
import java.util.List;
import kz.gov.pki.provider.utils.verifier.VerifierType;

public class VerifierFlags {
    private List<VerifierType> listVerifierType;
    private String currentVerificationType;
    public static final String AUTH = "AUTH";
    public static final String SIGNATURE = "SIGNATURE";
    public static final String SETUP_ADMIN = "SETUP_ADMIN";

    public VerifierFlags(String verificationType) {
        this.currentVerificationType = verificationType;
        this.listVerifierType = new ArrayList<VerifierType>();
        if (verificationType.equalsIgnoreCase(AUTH)) {
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_TYPE_AUTHENTICATION);
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_KNCA_USER);
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_VALIDITY_WITH_STATUS);
        }
        if (verificationType.equalsIgnoreCase(SIGNATURE)) {
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_TYPE_SIGNATURE);
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_KNCA_USER);
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_VALIDITY_WITH_STATUS);
        }
        if (verificationType.equalsIgnoreCase(SETUP_ADMIN)) {
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR);
            this.listVerifierType.add(VerifierType.X509CERTIFICATE_KNCA_USER);
        }
    }

    public List<VerifierType> getListVerifierType() {
        return this.listVerifierType;
    }

    public boolean containsVerifierType(VerifierType vt) {
        return this.getListVerifierType().contains((Object)vt);
    }

    public void addVerifyerType(VerifierType vt) {
        if (!this.containsVerifierType(vt)) {
            this.getListVerifierType().add(vt);
        }
    }

    public void removeVerifyerType(VerifierType vt) {
        if (this.containsVerifierType(vt)) {
            this.getListVerifierType().remove((Object)vt);
        }
    }

    public String getCurrentVerificationType() {
        return this.currentVerificationType;
    }
}

