package kz.arta.nca_iiscon.util;

import java.util.concurrent.atomic.AtomicLong;

public class ApplicationIdGenerator {
    private static final String PREFIX = "052";

    private final AtomicLong counter;

    public ApplicationIdGenerator() {
        long start = System.currentTimeMillis() % 1_000_000_000L;
        this.counter = new AtomicLong(start);
    }

    public String generate() {
        long next = counter.getAndUpdate(prev -> (prev + 1) % 1_000_000_000L);
        String suffix = String.format("%09d", next);
        return PREFIX + suffix;
    }

}
