package kz.arta.documentServices.rest.response;

public class ErrorCode {

    public static final int NO_ERROR = 0;

    public static final int EXCEPTION = 13;

    public static final int WARNING = 666;

    public static final int EMPTY_DATA = 1;

    public static final int ACCESS_DENIED = 2;

    public static final int INVALID_DATA = 3;

    public static final int ILLEGAL_OBJECTIVE_APPOINTMENT = 101;

    public static final int ILLEGAL_OBJECTIVE_SAVE = 102;

    public static final int ILLEGAL_OBJECTIVE_REJECT = 103;

    public static final int ILLEGAL_OBJECTIVE_DELETE = 104;

    public static final int ILLEGAL_OBJECTIVE_CANCEL = 105;

    public static final int ILLEGAL_OBJECTIVE_APPROVE = 106;

    /**
     * Родительская цель не существует или завершена
     */
    public static final int PARENT_OBJECTIVE_DOES_NOT_EXIST = 107;

    /**
     * Предпринята попытка изменить показатель для цели
     */
    public static final int OBJECTIVE_POINTER_HAS_BEEN_APPROVED = 108;

    /**
     * Статус цели изменен во время редактирования
     */
    public static final int OBJECTIVE_STATE_CHANGED_CLOSED = 109;

    /**
     * Статус цели изменен (отклонена)
     */
    public static final int OBJECTIVE_STATE_CHANGED_REJECTED = 110;

    /**
     * Статус цели изменен (утверждена)
     */
    public static final int OBJECTIVE_STATE_CHANGED_APPROVED = 111;

    /**
     * Цель не может быть отклонена так как уж утверждена
     */
    public static final int OBJECTIVE_CANNOT_BE_CANCELED = 112;

    /**
     * Данный пользователь не может быть удален, так как является
     * единственным администратором корневого подразделения
     */
    public static final int AT_LEAST_SINGLE_ADMIN_SHOULD_BE = 201;

    public static final int TOO_LONG_LAST_NAME = 202;

    public static final int TOO_LONG_FIRST_NAME = 203;

    public static final int TOO_LONG_PATRONYMIC = 204;

    public static final int TOO_LONG_MAIL = 205;

    public static final int TOO_LONG_LOGIN = 206;

    public static final int TOO_LONG_PASSWORD = 207;

    public static final int TOO_LONG_DEPARTMENT_NAME_RU = 208;

    public static final int TOO_LONG_DEPARTMENT_NAME_EN = 209;

    public static final int TOO_LONG_DEPARTMENT_NAME_KZ = 210;

    public static final int TOO_LONG_POSITION_NAME_RU = 208;

    public static final int TOO_LONG_POSITION_NAME_EN = 209;

    public static final int TOO_LONG_POSITION_NAME_KZ = 210;

    /**
     * Пользователя пытаются назначить на должность на которою он уже назначен
     */
    public static final int USER_HAS_THIS_POSITION = 211;

    /**
     * Родительский элемнт не существует
     */
    public static final int PARENT_DEPARMENT_DOES_NOT_EXIST = 212;

    /**
     * Достигнуто максимальное количество пользователей в базе данных
     */
    public static final int MAX_USERS_COUNT_EXCEEDED = 213;

    /**
     * Элемент не существует
     */
    public static final int ELEMENT_DOES_NOT_EXIST = 214;

    /**
     * Должность удалена
     */
    public static final int POSITION_NOT_FOUND = 215;

    /**
     * Пользователь удален
     */
    public static final int USER_NOT_FOUND = 216;

    /**
     * у департамента уже есть руководитель
     */
    public static final int DEPARTMENT_HAS_MANAGER = 217;

    /**
     * Время исполнения задачи пересекается со временем исполнения
     * другой задачи, либо время начала позже времени завершения
     */
    public static final int ILLEGAL_TASK_TIME = 301;

    /**
     * Не выбрана цель для задачи, либо данная цель не исполняется
     * пользователем или завершена.
     */
    public static final int ILLEGAL_TASK_OBJECTIVE = 302;

    /**
     * Руководитель пытается назначить задачу задним числом
     */
    public static final int CANNOT_APPOINT_TASK_IN_THE_PAST = 303;

    /**
     * Неверная формула показателя
     */
    public static final int INVALID_POINTER_FORMULA = 401;

    /**
     * В формуле показателя обнаружена циклическая ссылка
     */
    public static final int CYCLE_LINK = 402;

    /**
     * Код показателя содержит недопустимые символы (пробелы)
     */
    public static final int INVALID_CODE = 403;

    /**
     * Данный код уже испоьзуется
     */
    public static final int CODE_IN_USE = 404;

    /**
     * существуют цели оцениваемые данным показателем
     */
    public static final int POINTER_HAS_OBJECTIVES = 405;

    /**
     * Существуют результирующие показатели в расчете значений которых участвует данный показатель
     */
    public static final int POINTER_HAS_POINTERS = 406;

    /**
     * Показатель используется в расчете др показателей, его длина не мрожет быть равна 0
     */
    public static final int POINTER_CODE_LENGTH_CANNOT_BE_NULL = 407;


    /**
     * Значение показателя может быть изменено явно только для свободных и
     * формирующих показателей
     */
    public static final int VALUE_CANNOT_BE_CHANGED_FOR_THIS_POINTER_TYPE = 410;

    /**
     * Показатель не существует
     */
    public static final int POINTER_DOES_NOT_EXIST = 411;

    public static final int INVALID_POINTER_VALUE = 412;

    public static final int POINTER_NOT_FOUND = 413;

    /**
     * Пользователь с таким логином уже существует
     */
    public static final int LOGIN_IS_ALREADY_EXIST = 23;


    public static final int ACTION_PERCENT_CANNOT_BE_CHANGED_MANUALLY = 501;

    /**
     * Нет руководителей
     */
    public static final int NO_OWN_MANAGER = 502;

    /**
     * Нельзя завершить работу
     */
    public static final int CANNOT_FINISH_WORKS = 503;

    public static final int CERTIFICATE_INVALIDATED = 601;
    public static final int CERTIFICATE_REVOKED = 602;

    public static final int ICON_TOO_BIG = 701;
    public static final int NOT_PNG = 702;

    /**
     * Не валидная дата для создания/копирования мероприятия
     */
    public static final int INVALID_PROJECT_DATE = 801;
    public static final int INVALID_PROJECT_START_DATE = 802;
    public static final int INVALID_PROJECT_FINISH_DATE = 803;


    /**
     * подписи
     */

    public static final int SIGN_DATA_CHANGED = 901;
    public static final int SIGNS_LIST_CHANGED = 902;
    public static final int SIGNS_LIST_EMPTY = 903;

    public static final int OBJECT_NOT_FOUND = 904;

    /**
     * невалидное ркк
     */
    public static final int RCC_INVALID = 905;

    /**
     * ошибка ссылок на объект
     */
    public static final int OBJECT_REFERENCE_ERROR = 1000;
}
