## Сборка

Сборка осуществляется при помощи [Gradle Build Tool](https://gradle.org/)

```bash
$ ./gradle war
```

Собранный `documentServices.war` необходимо поместить
в `/opt/synergy/jboss/standalone/deployments`

## Конфигурация

Приложение читает конфигурационный файл `documentServices.properties`
в директории `/opt/synergy/jboss/standalone/configuration`.

Параметры конфигурации:

```properties
# Приведенные ниже значения параметров являются значениями по-умолчанию

# Адрес Synergy для доступа к REST API
synergy.url=http://127.0.0.1:8080/Synergy
# Логин пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.login=1
# Пароль пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.password=1
```

Дать права для файла.
```
chown jboss:synergy /opt/synergy/jboss/standalone/configuration/documentServices.properties
```

Также необходимо в файле `standalone-onesynergy.xml` находящегося
в директории `/opt/synergy/jboss/standalone/configuration`,
добавить пул соеденений для базы MySQL,
```
jndi-name="java:/documentServicesDS"
```
```
pool-name="documentServices_ds"
```

Перезапустить JBoss


Также необходимо в файле `synergy-base` находящегося
в директории `/etc/nginx/sties-enabled/`,
добавить строку,
```
location /documentServices {
proxy_pass              http://127.0.0.1:8080/documentServices;
}
```

Проверить конфиг
```
nginx -t
```

В случае если конфиг корректный будет ответ
```
nginx: the configuration file /etc/nginx/nginx.conf syntax is ok                                                                                                                                                                             
nginx: configuration file /etc/nginx/nginx.conf test is successful
```

Перечитываем конфиг nginx
```
nginx -s reload
```
