## Сборка

Сборка осуществляется при помощи [Gradle Build Tool](https://gradle.org/)

```bash
$ ./gradle war
```

1. Необходимо создать в БД Synergy таблицу `opened_documents`
```sql
CREATE TABLE IF NOT EXISTS `opened_documents` (
`documentID` char(36),
`dataUUID` bigint(20) unsigned,
`userID` char(36),
`date` char(36),
PRIMARY KEY  (`documentID`)
) ENGINE=InnoDB COMMENT='открытые документы';
```

2. Собранный `documentServices.war` необходимо поместить
в `/opt/synergy/jboss/standalone/deployments`

## Конфигурация

Приложение читает конфигурационный файл `documentServices.properties`
в директории `/opt/synergy/jboss/standalone/configuration`.

Параметры конфигурации:

```properties
# Приведенные ниже значения параметров являются значениями по-умолчанию

# Адрес Synergy для доступа к REST API
synergy.url=http://127.0.0.1:8080/Synergy
# Логин пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.login=1
# Пароль пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.password=1
```

Дать права для файла.
```
chown jboss:synergy /opt/synergy/jboss/standalone/configuration/documentServices.properties
```

В файле `standalone-onesynergy.xml` находящегося
в директории `/opt/synergy/jboss/standalone/configuration`,
добавить пул соеденений для базы MySQL,
```xml
<datasource jta="false" jndi-name="java:/documentServicesDS" pool-name="document_services_ds" enabled="true" use-java-context="true">
    <connection-url>jdbc:mysql://127.0.0.1:3306/synergy?setUnicode=true&amp;characterEncoding=utf8</connection-url>
    <driver>com.mysql.nonxa</driver>
    <pool>
        <min-pool-size>20</min-pool-size>
        <max-pool-size>200</max-pool-size>
    </pool>
    <security>
        <user-name>root</user-name>
        <password>root</password>
    </security>
</datasource>
```

и jms очередь:

```xml
<jms-queue name="DocflowDocument" entries="queue/DocflowDocument java:jboss/queues/Synergy/DocflowDocument" durable="true"/>
```

В файле `api-observation-configuration.xml` находящегося
в директории `/opt/synergy/jboss/standalone/configuration/arta/`, добавить listener
```xml
<listener>
    <queue>java:jboss/queues/Synergy/DocflowDocument</queue>
    <event>event.docflow.document.*</event>
</listener>
```

Перезапустить JBoss


Также необходимо в файле `synergy-base` находящегося
в директории `/etc/nginx/sties-enabled/`,
добавить строку,
```
location /documentServices {
proxy_pass              http://127.0.0.1:8080/documentServices;
}
```

Проверить конфиг
```
nginx -t
```

В случае если конфиг корректный будет ответ
```
nginx: the configuration file /etc/nginx/nginx.conf syntax is ok                                                                                                                                                                             
nginx: configuration file /etc/nginx/nginx.conf test is successful
```

Перечитываем конфиг nginx
```
nginx -s reload
```
