package kz.arta.documentServices.rest.response;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.Serializable;

public class ErrorPOJO implements Serializable {
    /**
     * Значение кода ошибки по умолчанию
     */
    private static final int DEFAULT_ERROR_CODE = ErrorCode.EXCEPTION;

    /**
     * код ошибки
     */
    private int errorCode = 0;
    /**
     * ошибка
     */
    private String errorMessage = "";

    public ErrorPOJO() {
    }

    public ErrorPOJO(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    /**
     * создает jaxrs ответ на основе конструктора {@link ErrorPOJO}
     *
     * @param errorCode    код ошибки
     * @param errorMessage сообщение
     */
    public static Response buildResponse(int errorCode, String errorMessage) {
        return new ErrorPOJO(errorCode, errorMessage)
                .buildResponse();
    }

    /**
     * возвращает валидный ответ
     *
     * @param errorMessage сообщение
     * @return jaxrs ответ
     */
    public static Response buildValid(String errorMessage) {
        return Response.ok(new ErrorPOJO(ErrorCode.NO_ERROR, errorMessage)).build();
    }

    /**
     * {@link #buildResponse(int, String)}
     */
    public static Response buildResponse(String errorMessage) {
        return buildResponse(DEFAULT_ERROR_CODE, errorMessage);
    }

    public Response buildResponse() {
        return Response.serverError().entity(this).build();
    }

    public Response buildResponse(Response.StatusType status) {
        return Response.status(status).entity(this).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
