package kz.arta.documentServices.rest.response;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.Serializable;

/**
 * Created by exile
 * Date: 10.02.16
 * Time: 11:04
 * класс обертка для ошибок
 */
public class ResponsePOJO<T> implements Serializable {
    /**
     * Значение кода ошибки по умолчанию
     */
    private static final int DEFAULT_ERROR_CODE = ErrorCode.EXCEPTION;

    /**
     * Код ошибки
     */
    private int errorCode = 0;

    /**
     * Наименование ошибки
     */
    private String errorMessage = "OK";

    /**
     * Результат
     */
    private T data;

    public ResponsePOJO() {
    }

    /**
     * Конструктор с успешным ответом по умолчанию
     */
    public ResponsePOJO(T data) {
        this.data = data;
    }

    /**
     * Конструктор с успешным ответом по умолчанию но с произвольным статусом
     */
    public ResponsePOJO(int errorCode, T data) {
        this.errorCode = ErrorCode.NO_ERROR;
        this.data = data;
    }

    /**
     * Конструктор с произвольным ответом
     *
     * @param errorCode    Код ошибки
     * @param errorMessage Наименование ошибки
     * @param data         Объект (Класса) *Вернется в ключе data*
     */
    public ResponsePOJO(int errorCode, String errorMessage, T data) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.data = data;
    }

    public static ResponsePOJO exception(Exception e) {
        return exception(e.getMessage());
    }

    public static ResponsePOJO exception(String msg) {
        return new ResponsePOJO(ErrorCode.EXCEPTION, msg);
    }

    /**
     * создает jaxrs ответ на основе конструктора {@link ResponsePOJO}
     *
     * @param errorCode    код ошибки
     * @param errorMessage сообщение
     */
    public static Response buildResponse(int errorCode, String errorMessage) {
        return new ResponsePOJO(errorCode, errorMessage)
                .buildResponse();
    }

    /**
     * Возвращает валидный ответ
     *
     * @param errorMessage сообщение
     * @return jaxrs ответ
     */
    public static Response buildValid(String errorMessage) {
        return Response.ok(new ResponsePOJO(ErrorCode.NO_ERROR, errorMessage)).build();
    }

    /**
     * {@link #buildResponse(int, String)}
     */
    public static Response buildResponse(String errorMessage) {
        return buildResponse(DEFAULT_ERROR_CODE, errorMessage);
    }

    public Response buildResponse() {
        return Response.serverError().entity(this).build();
    }

    public Response buildResponse(Response.StatusType status) {
        return Response.status(status).entity(this).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T object) {
        this.data = object;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }
}
