package kz.arta.documentServices.service;

import kz.arta.documentServices.rest.PersonApi;
import kz.arta.documentServices.rest.response.*;
import kz.arta.documentServices.listeners.DocflowDocumentListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;

@Path("/document")
@RequestScoped
public class DocumentRestServices {

    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentRestServices.class);

    @GET
    @Path("/isopen")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public Response documentIsOpen(@QueryParam("documentID") String documentID, @Context HttpHeaders headers) throws IOException {
        if (documentID == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Не передан documentID")).build();
        }

        List<String> authHeaders = headers.getRequestHeader(HttpHeaders.AUTHORIZATION);

        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                int statusAuth = PersonApi.checkUserAuth(authHeaders.get(0));
                if(statusAuth != 200) {
                    return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.ACCESS_DENIED, "Ошибка авторизации")).build();
                }

                HashMap<String, String> openInfo = DocflowDocumentListener.checkOpenDocument(documentID);

                if(openInfo.get("dataUUID") == null) {
                    return Response.ok(new ResponsePOJO(ErrorCode.NO_ERROR, null)).build();
                } else {
                    return Response.ok(new ResponsePOJO(openInfo)).build();
                }
            } catch (Exception e) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorPOJO(ErrorCode.EXCEPTION, e.getMessage())).build();
            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Ошибка авторизации")).build();
        }
    }

    @GET
    @Path("/info")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public Response documentInfo(@QueryParam("documentID") String documentID, @Context HttpHeaders headers) throws IOException {
        if (documentID == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Не передан documentID")).build();
        }

        List<String> authHeaders = headers.getRequestHeader(HttpHeaders.AUTHORIZATION);

        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                int statusAuth = PersonApi.checkUserAuth(authHeaders.get(0));
                if(statusAuth != 200) {
                    return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.ACCESS_DENIED, "Ошибка авторизации")).build();
                }

                HashMap<String, String> docInfo = DocflowDocumentListener.getDocumentInfo(documentID);

                if(docInfo.get("dataUUID") == null) {
                    return Response.ok(new ResponsePOJO(ErrorCode.NO_ERROR, null)).build();
                } else {
                    return Response.ok(new ResponsePOJO(docInfo)).build();
                }
            } catch (Exception e) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorPOJO(ErrorCode.EXCEPTION, e.getMessage())).build();
            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Ошибка авторизации")).build();
        }
    }

    @GET
    @Path("/list")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public Response getAllOpenDocuments(@Context HttpHeaders headers) throws IOException {
        List<String> authHeaders = headers.getRequestHeader(HttpHeaders.AUTHORIZATION);
        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                int statusAuth = PersonApi.checkUserAuth(authHeaders.get(0));
                if(statusAuth != 200) {
                    return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.ACCESS_DENIED, "Ошибка авторизации")).build();
                }

                List allDocuments = DocflowDocumentListener.getAllDocuments();
                return Response.ok(new ResponsePOJO(allDocuments)).build();
            } catch (Exception e) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorPOJO(ErrorCode.EXCEPTION, e.getMessage())).build();
            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Ошибка авторизации")).build();
        }
    }

    @POST
    @Path("/remove/{documentID}")
    @Produces(MediaType.APPLICATION_JSON)
    public Response removeDocument(@PathParam("documentID") String documentID, @Context HttpHeaders headers) throws IOException {
        List<String> authHeaders = headers.getRequestHeader(HttpHeaders.AUTHORIZATION);
        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                int statusAuth = PersonApi.checkUserAuth(authHeaders.get(0));
                if(statusAuth != 200) {
                    return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.ACCESS_DENIED, "Ошибка авторизации")).build();
                }
                int res = DocflowDocumentListener.deleteRow(documentID);
                return Response.ok(new ResponsePOJO(res)).build();
            } catch (Exception e) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorPOJO(ErrorCode.EXCEPTION, e.getMessage())).build();
            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Ошибка авторизации")).build();
        }
    }

    @POST
    @Path("/removeAll")
    @Produces(MediaType.APPLICATION_JSON)
    public Response removeAllDocuments(@Context HttpHeaders headers) throws IOException {
        List<String> authHeaders = headers.getRequestHeader(HttpHeaders.AUTHORIZATION);
        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                int statusAuth = PersonApi.checkUserAuth(authHeaders.get(0));
                if(statusAuth != 200) {
                    return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.ACCESS_DENIED, "Ошибка авторизации")).build();
                }
                int res = DocflowDocumentListener.deleteAllRows();
                return Response.ok(new ResponsePOJO(res)).build();
            } catch (Exception e) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorPOJO(ErrorCode.EXCEPTION, e.getMessage())).build();
            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorPOJO(ErrorCode.EXCEPTION, "Ошибка авторизации")).build();
        }
    }
}
