package kz.arta.ext.jdm.config;

import kz.arta.ext.jdm.config.model.Deployment;
import kz.arta.ext.jdm.config.model.Deployments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * Created by timur on 10/10/16.
 */
public class Config {

    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    private String filePath = "/opt/synergy/jdm/deployments.xml";

    private String deploymentsPath = "/opt/synergy/jboss/standalone/deployments";

    private String tmpPath = "/opt/tmpDeployments";

    private Deployments deployments;

    private Config() {
        readConfig();
    }

    private static Config config = null;

    public static Config getInstance() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    private void readConfig() {

        FileInputStream fin = null;

        try {

            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            fin = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            int read;
            while ((read = fin.read(buffer, 0, buffer.length)) != -1) {
                bout.write(buffer, 0, read);
            }

            deployments = JAXB.unmarshal(new ByteArrayInputStream(bout.toByteArray()), Deployments.class);

        } catch (Exception exc){
            LOGGER.error(exc.getMessage(), exc);
        } finally {
            try {
                fin.close();
            } catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public String getDeploymentsPath() {
        return deploymentsPath;
    }

    public String getTmpPath() {
        return tmpPath;
    }

    public Deployments getDeployments() {
        return deployments;
    }
}
