package kz.arta.ext.jdm.config;

import kz.arta.ext.jdm.config.model.Deployment;
import kz.arta.ext.jdm.config.model.Deployments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by timur on 10/11/16.
 */
public class DeploymentsList {


    private HashMap <String, DeploymentItem> items = new HashMap<>();

    public DeploymentsList(Deployments deployments) {

        for (Deployment deployment: deployments.getDeployments()) {
            DeploymentItem item = null;
            if (items.containsKey(deployment.getName())) {
                item = items.get(deployment.getName());
            } else {
                item = new DeploymentItem();
                item.fileName = deployment.getName();
                items.put(item.fileName, item);
            }
            item.dependsOnList.add(deployment.getDependsOn());
        }
    }


    private class DeploymentItem {

        String fileName;

        List<String> dependsOnList = new ArrayList<>();

        boolean isDeployed;
    }
}
